/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator;

import java.util.Base64;
import java.util.BitSet;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.spread.generator.AuxiliaryCellStyleInfo;
import kd.tmc.fpm.business.spread.generator.BitSetConverter;
import kd.tmc.fpm.business.spread.generator.ICellStyleInfoConvert;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.common.enums.SpecialColorEnum;
import kd.tmc.fpm.spread.widget.DisplayTypeEnum;
import kd.tmc.fpm.spread.widget.style.HorizontalAlignEnum;
import kd.tmc.fpm.spread.widget.style.VerticalAlignEnum;

public class AuxiliaryCellStyleConvert
implements ICellStyleInfoConvert {
    @Override
    public AuxiliaryCellStyleInfo toAuxiliaryCellStyle(ReportCalcVal reportCalcVal, CellDimTypeEnum cellDimType) {
        HorizontalAlignEnum horizontalAlign = HorizontalAlignEnum.Center;
        if (cellDimType == CellDimTypeEnum.ROWDIMS && reportCalcVal.getColSpan() <= 1) {
            horizontalAlign = HorizontalAlignEnum.LEFT;
        } else if (cellDimType == CellDimTypeEnum.DATADIMS) {
            horizontalAlign = HorizontalAlignEnum.LEFT;
        } else if (!(cellDimType != CellDimTypeEnum.EXTDIMS || reportCalcVal.getValueType().getReportCellType() == ReportCellType.TEXT && "==".equals(reportCalcVal.getDisplayVal()))) {
            horizontalAlign = HorizontalAlignEnum.LEFT;
        }
        ReportCellType reportCellType = reportCalcVal.getValueType().getReportCellType();
        if (reportCellType == ReportCellType.AMOUNT || reportCellType == ReportCellType.PERCENT) {
            horizontalAlign = HorizontalAlignEnum.RIGHT;
        } else if (reportCellType == ReportCellType.DATE) {
            horizontalAlign = HorizontalAlignEnum.Center;
        }
        AuxiliaryCellStyleInfo auxiliaryCellStyle = new AuxiliaryCellStyleInfo.AuxiliaryCellStyleInfoBuilder().setLock(!reportCalcVal.isEnable()).setSummary(reportCalcVal.isSummary()).setColSpanUp1(reportCalcVal.getColSpan() > 1).setRowSpanUp1(reportCalcVal.getRowSpan() > 1).setFormula(EmptyUtil.isNoEmpty((Object)reportCalcVal.getFormula())).setReferenceCell(reportCalcVal.isReferenceCell()).setEmptyValue(EmptyUtil.isEmpty((Object)reportCalcVal.getValue())).setReprotCellType(reportCalcVal.getValueType().getReportCellType()).setDisplayType(reportCalcVal.getDisplayType()).setCellDimType(cellDimType).setVerticalAlign(VerticalAlignEnum.Center).setHorizontalAlign(horizontalAlign).setSpecialColor(reportCalcVal.getSpecialColor()).setLevel((short)reportCalcVal.getLevel()).build();
        return auxiliaryCellStyle;
    }

    @Override
    public AuxiliaryCellStyleInfo toAuxiliaryCellStyle(String cellStyleBitSetMark) {
        BitSet bitSet = BitSet.valueOf(Base64.getDecoder().decode(cellStyleBitSetMark));
        AuxiliaryCellStyleInfo auxiliaryCellStyle = new AuxiliaryCellStyleInfo.AuxiliaryCellStyleInfoBuilder().setLock(bitSet.get(AuxiliaryCellStyleInfo.bitRangeMap.get("LOCK_BIT_MARK")[0])).setSummary(bitSet.get(AuxiliaryCellStyleInfo.bitRangeMap.get("SUMMARY_BIT_MARK")[0])).setColSpanUp1(bitSet.get(AuxiliaryCellStyleInfo.bitRangeMap.get("COLSPANUP1_BIT_MARK")[0])).setRowSpanUp1(bitSet.get(AuxiliaryCellStyleInfo.bitRangeMap.get("ROWSPANUP1_BIT_MARK")[0])).setFormula(bitSet.get(AuxiliaryCellStyleInfo.bitRangeMap.get("FORMULA_BIT_MARK")[0])).setReferenceCell(bitSet.get(AuxiliaryCellStyleInfo.bitRangeMap.get("REFERENCE_BIT_MARK")[0])).setEmptyValue(bitSet.get(AuxiliaryCellStyleInfo.bitRangeMap.get("EMPTYVAL_BIT_MARK")[0])).setReprotCellType(new BitSetConverter<ReportCellType>(bitSet).getValue(bs -> {
            Integer[] range = AuxiliaryCellStyleInfo.bitRangeMap.get("REPORTCELLTYPE_BIT_MARK");
            Integer markIndex = BitSetConverter.getMarkIndex(bs.get(range[0], range[range.length - 1] + 1), range.length);
            if (markIndex == 0) {
                return null;
            }
            return ReportCellType.getReportCellType(markIndex - 1);
        })).setDisplayType(new BitSetConverter<DisplayTypeEnum>(bitSet).getValue(bs -> {
            Integer[] range = AuxiliaryCellStyleInfo.bitRangeMap.get("DISPLAYTYPE_BIT_MARK");
            Integer markIndex = BitSetConverter.getMarkIndex(bs.get(range[0], range[range.length - 1] + 1), range.length);
            if (markIndex == 0) {
                return null;
            }
            return DisplayTypeEnum.getDisplayType((int)(markIndex - 1));
        })).setCellDimType(new BitSetConverter<CellDimTypeEnum>(bitSet).getValue(bs -> {
            Integer[] range = AuxiliaryCellStyleInfo.bitRangeMap.get("CELLDIMTYPE_BIT_MARK");
            Integer markIndex = BitSetConverter.getMarkIndex(bs.get(range[0], range[range.length - 1] + 1), range.length);
            if (markIndex == 0) {
                return null;
            }
            return CellDimTypeEnum.getCellDimType((int)(markIndex - 1));
        })).setVerticalAlign(new BitSetConverter<VerticalAlignEnum>(bitSet).getValue(bs -> {
            Integer[] range = AuxiliaryCellStyleInfo.bitRangeMap.get("VERTICALALIGN_BIT_MARK");
            Integer markIndex = BitSetConverter.getMarkIndex(bs.get(range[0], range[range.length - 1] + 1), range.length);
            if (markIndex == 0) {
                return null;
            }
            return VerticalAlignEnum.getVerticalAlign((int)(markIndex - 1));
        })).setHorizontalAlign(new BitSetConverter<HorizontalAlignEnum>(bitSet).getValue(bs -> {
            Integer[] range = AuxiliaryCellStyleInfo.bitRangeMap.get("HORIZONALIGN_BIT_MARK");
            Integer markIndex = BitSetConverter.getMarkIndex(bs.get(range[0], range[range.length - 1] + 1), range.length);
            if (markIndex == 0) {
                return null;
            }
            return HorizontalAlignEnum.getHorizontalAlign((int)(markIndex - 1));
        })).setSpecialColor(new BitSetConverter<SpecialColorEnum>(bitSet).getValue(bs -> {
            Integer[] range = AuxiliaryCellStyleInfo.bitRangeMap.get("SPECIALCOLOR_BIT_MARK");
            Integer markIndex = BitSetConverter.getMarkIndex(bs.get(range[0], range[range.length - 1] + 1), range.length);
            if (markIndex == 0) {
                return null;
            }
            return SpecialColorEnum.getSpecialColor((int)(markIndex - 1));
        })).setLevel(new BitSetConverter<Short>(bitSet).getValue(bs -> {
            Integer[] range = AuxiliaryCellStyleInfo.bitRangeMap.get("LEVEL_BIT_MARK");
            Integer markIndex = BitSetConverter.getMarkIndex(bs.get(range[0], range[range.length - 1] + 1), range.length);
            return markIndex.shortValue();
        })).build();
        return auxiliaryCellStyle;
    }
}

