/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator;

import java.util.Base64;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.spread.generator.report.cell.ICellDisplayTypeStyleDeal;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.common.enums.SpecialColorEnum;
import kd.tmc.fpm.spread.widget.DisplayTypeEnum;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;
import kd.tmc.fpm.spread.widget.style.HorizontalAlignEnum;
import kd.tmc.fpm.spread.widget.style.VerticalAlignEnum;

public class AuxiliaryCellStyleInfo
implements ICellDisplayTypeStyleDeal {
    public static Map<String, Integer[]> bitRangeMap = new HashMap<String, Integer[]>();
    private static final int BITSET_LENGTH = 32;
    private BitSet cellStyleMarkSet = new BitSet(32);
    private boolean isReferenceCell;
    private boolean isEmptyValue;
    private ReportCellType reprotCellType;
    private DisplayTypeEnum displayType;
    private CellDimTypeEnum cellDimType;
    private VerticalAlignEnum verticalAlign;
    private HorizontalAlignEnum horizontalAlign;
    private boolean isLock;
    private boolean isSummary;
    private short level;
    private boolean isColSpanUp1;
    private boolean isRowSpanUp1;
    private SpecialColorEnum specialColor;
    private boolean isFormula;

    public String toCellStyleMark() {
        this.fillCellStyleMark(this.isLock, bitRangeMap.get("LOCK_BIT_MARK")[0]);
        this.fillCellStyleMark(this.isSummary, bitRangeMap.get("SUMMARY_BIT_MARK")[0]);
        this.fillCellStyleMark(this.isColSpanUp1, bitRangeMap.get("COLSPANUP1_BIT_MARK")[0]);
        this.fillCellStyleMark(this.isRowSpanUp1, bitRangeMap.get("ROWSPANUP1_BIT_MARK")[0]);
        this.fillCellStyleMark(this.isFormula, bitRangeMap.get("FORMULA_BIT_MARK")[0]);
        this.fillCellStyleMark(this.isReferenceCell, bitRangeMap.get("REFERENCE_BIT_MARK")[0]);
        this.fillCellStyleMark(this.isEmptyValue, bitRangeMap.get("EMPTYVAL_BIT_MARK")[0]);
        if (this.reprotCellType != null) {
            this.fillCellStyleMark(this.reprotCellType.ordinal() + 1, bitRangeMap.get("REPORTCELLTYPE_BIT_MARK"));
        }
        if (this.displayType != null) {
            this.fillCellStyleMark(this.displayType.ordinal() + 1, bitRangeMap.get("DISPLAYTYPE_BIT_MARK"));
        }
        if (this.cellDimType != null) {
            this.fillCellStyleMark(this.cellDimType.ordinal() + 1, bitRangeMap.get("CELLDIMTYPE_BIT_MARK"));
        }
        if (this.verticalAlign != null) {
            this.fillCellStyleMark(this.verticalAlign.ordinal() + 1, bitRangeMap.get("VERTICALALIGN_BIT_MARK"));
        }
        if (this.horizontalAlign != null) {
            this.fillCellStyleMark(this.horizontalAlign.ordinal() + 1, bitRangeMap.get("HORIZONALIGN_BIT_MARK"));
        }
        if (this.specialColor != null) {
            this.fillCellStyleMark(this.specialColor.ordinal() + 1, bitRangeMap.get("SPECIALCOLOR_BIT_MARK"));
        }
        this.fillCellStyleMark(this.level, bitRangeMap.get("LEVEL_BIT_MARK"));
        return Base64.getEncoder().encodeToString(this.cellStyleMarkSet.toByteArray());
    }

    public CellStyleInfo generateStyle() {
        CellStyleInfo cellStyle = new CellStyleInfo();
        cellStyle.setHa(this.horizontalAlign);
        cellStyle.setVa(this.verticalAlign);
        cellStyle.setL(Boolean.valueOf(this.isLock));
        short level = this.level;
        if (this.isSummary) {
            level = 1;
        }
        cellStyle.setTi(Integer.valueOf(level >= 1 ? level : (short)0));
        if (this.cellDimType == CellDimTypeEnum.ROWDIMS) {
            cellStyle.setBkc("#EDF1F4");
        } else if (this.cellDimType == CellDimTypeEnum.COLDIMS) {
            cellStyle.setBkc("#D0D5DC");
        } else if (this.cellDimType == CellDimTypeEnum.DATADIMS) {
            if (this.isLock || this.isFormula) {
                cellStyle.setBkc("#F5F5F5");
            }
        } else if (this.cellDimType == CellDimTypeEnum.EXTDIMS && this.isLock) {
            cellStyle.setBkc("#FCE4D6");
        }
        if (this.isReferenceCell && this.cellDimType != CellDimTypeEnum.COLDIMS) {
            cellStyle.setBkc("#EAF9FF");
        }
        if (this.reprotCellType == ReportCellType.AMOUNT && this.isEmptyValue) {
            cellStyle.setFrc("#999999");
        }
        if (this.specialColor != null) {
            cellStyle.setBkc(this.specialColor.getColor());
        }
        if (this.displayType == null || DisplayTypeEnum.NORMAR == this.displayType) {
            this.normal(cellStyle);
        } else if (this.displayType != null && DisplayTypeEnum.WARNING == this.displayType) {
            this.warning(cellStyle);
        } else if (this.displayType != null && DisplayTypeEnum.ERROR == this.displayType) {
            this.error(cellStyle);
        } else if (this.displayType != null && DisplayTypeEnum.MUSTRECORD == this.displayType) {
            this.mustRecord(cellStyle);
        }
        if (this.reprotCellType == ReportCellType.AMOUNT) {
            cellStyle.setFm("#,##0.00");
        } else if (this.reprotCellType == ReportCellType.DATE) {
            cellStyle.setFm("yyyy/MM/dd");
        } else if (this.reprotCellType == ReportCellType.TEXT) {
            cellStyle.setFm("@");
        } else if (this.reprotCellType == ReportCellType.PERCENT) {
            cellStyle.setFm("#,##0.0000%");
        }
        return cellStyle;
    }

    private AuxiliaryCellStyleInfo(AuxiliaryCellStyleInfoBuilder builder) {
        this.specialColor = builder.specialColor;
        this.cellDimType = builder.cellDimType;
        this.reprotCellType = builder.reprotCellType;
        this.displayType = builder.displayType;
        this.horizontalAlign = builder.horizontalAlign;
        this.isColSpanUp1 = builder.isColSpanUp1;
        this.isLock = builder.isLock;
        this.isRowSpanUp1 = builder.isRowSpanUp1;
        this.isSummary = builder.isSummary;
        this.level = builder.level;
        this.verticalAlign = builder.verticalAlign;
        this.isEmptyValue = builder.isEmptyValue;
        this.isFormula = builder.isFormula;
        this.isReferenceCell = builder.isReferenceCell;
    }

    private void fillCellStyleMark(int ordinal, Integer[] range) {
        int start = range[0];
        int end = range[range.length - 1];
        if (start > 32) {
            throw new KDBizException(String.format("Exceed BitSet max length: currentInx=%d, maxInx=%d", start, 32));
        }
        String binaryStr = Integer.toBinaryString(ordinal);
        if (binaryStr.length() > end - start + 1) {
            throw new KDBizException(String.format("BitSet Save OutFlow: ordinal=%d, binary=%s, allocation range [%d, %d]", ordinal, binaryStr, start, end));
        }
        if (binaryStr.length() < end - start + 1) {
            StringBuffer sb = new StringBuffer(binaryStr);
            while (sb.length() < end - start + 1) {
                sb = sb.insert(0, "0");
            }
            binaryStr = sb.toString();
        }
        for (int inx = start; inx <= end; ++inx) {
            char ch = binaryStr.charAt(inx - start);
            if (ch != '1') continue;
            this.cellStyleMarkSet.set(inx);
        }
    }

    private void fillCellStyleMark(boolean flag, int inx) {
        if (inx > 32) {
            throw new KDBizException(String.format("Exceed BitSet max length: currentInx=%d, maxInx=%d", inx, 32));
        }
        if (flag) {
            this.cellStyleMarkSet.set(inx);
        }
    }

    static {
        bitRangeMap.put("LOCK_BIT_MARK", new Integer[]{0});
        bitRangeMap.put("SUMMARY_BIT_MARK", new Integer[]{1});
        bitRangeMap.put("COLSPANUP1_BIT_MARK", new Integer[]{2});
        bitRangeMap.put("ROWSPANUP1_BIT_MARK", new Integer[]{3});
        bitRangeMap.put("FORMULA_BIT_MARK", new Integer[]{4});
        bitRangeMap.put("REFERENCE_BIT_MARK", new Integer[]{5});
        bitRangeMap.put("EMPTYVAL_BIT_MARK", new Integer[]{6});
        bitRangeMap.put("REPORTCELLTYPE_BIT_MARK", new Integer[]{7, 8, 9});
        bitRangeMap.put("DISPLAYTYPE_BIT_MARK", new Integer[]{10, 11, 12});
        bitRangeMap.put("CELLDIMTYPE_BIT_MARK", new Integer[]{13, 14, 15});
        bitRangeMap.put("VERTICALALIGN_BIT_MARK", new Integer[]{16, 17});
        bitRangeMap.put("HORIZONALIGN_BIT_MARK", new Integer[]{18, 19});
        bitRangeMap.put("SPECIALCOLOR_BIT_MARK", new Integer[]{20, 21, 22, 23});
        bitRangeMap.put("LEVEL_BIT_MARK", new Integer[]{24, 25, 26, 27, 28});
    }

    public static class AuxiliaryCellStyleInfoBuilder {
        private boolean isLock;
        private boolean isSummary;
        private boolean isColSpanUp1;
        private boolean isRowSpanUp1;
        private boolean isFormula;
        private boolean isReferenceCell;
        private boolean isEmptyValue;
        private ReportCellType reprotCellType;
        private DisplayTypeEnum displayType;
        private CellDimTypeEnum cellDimType;
        private VerticalAlignEnum verticalAlign;
        private HorizontalAlignEnum horizontalAlign;
        private short level;
        private SpecialColorEnum specialColor;

        public AuxiliaryCellStyleInfo build() {
            return new AuxiliaryCellStyleInfo(this);
        }

        public AuxiliaryCellStyleInfoBuilder setReprotCellType(ReportCellType reprotCellType) {
            this.reprotCellType = reprotCellType;
            return this;
        }

        public AuxiliaryCellStyleInfoBuilder setDisplayType(DisplayTypeEnum displayType) {
            this.displayType = displayType;
            return this;
        }

        public AuxiliaryCellStyleInfoBuilder setCellDimType(CellDimTypeEnum cellDimType) {
            this.cellDimType = cellDimType;
            return this;
        }

        public AuxiliaryCellStyleInfoBuilder setVerticalAlign(VerticalAlignEnum verticalAlign) {
            this.verticalAlign = verticalAlign;
            return this;
        }

        public AuxiliaryCellStyleInfoBuilder setHorizontalAlign(HorizontalAlignEnum horizontalAlign) {
            this.horizontalAlign = horizontalAlign;
            return this;
        }

        public AuxiliaryCellStyleInfoBuilder setLock(boolean lock) {
            this.isLock = lock;
            return this;
        }

        public AuxiliaryCellStyleInfoBuilder setSummary(boolean summary) {
            this.isSummary = summary;
            return this;
        }

        public AuxiliaryCellStyleInfoBuilder setLevel(short level) {
            this.level = level;
            return this;
        }

        public AuxiliaryCellStyleInfoBuilder setColSpanUp1(boolean colSpanUp1) {
            this.isColSpanUp1 = colSpanUp1;
            return this;
        }

        public AuxiliaryCellStyleInfoBuilder setRowSpanUp1(boolean rowSpanUp1) {
            this.isRowSpanUp1 = rowSpanUp1;
            return this;
        }

        public AuxiliaryCellStyleInfoBuilder setSpecialColor(SpecialColorEnum specialColor) {
            this.specialColor = specialColor;
            return this;
        }

        public AuxiliaryCellStyleInfoBuilder setFormula(boolean formula) {
            this.isFormula = formula;
            return this;
        }

        public AuxiliaryCellStyleInfoBuilder setReferenceCell(boolean referenceCell) {
            this.isReferenceCell = referenceCell;
            return this;
        }

        public AuxiliaryCellStyleInfoBuilder setEmptyValue(boolean emptyValue) {
            this.isEmptyValue = emptyValue;
            return this;
        }
    }
}

