/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.generator.actions.impl.FormulaProcessV3Action;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class AnalysisFormulaProcessAction
extends FormulaProcessV3Action {
    private static final Log logger = LogFactory.getLog(AnalysisFormulaProcessAction.class);
    private FormulaProcessV3Action.CalcValColQueryIndex dataIndex;
    private FormulaProcessV3Action.CalcValColQueryIndex summaryIndex;
    private Dimension orgDimension;
    private Map<Long, DimMember> orgMemberMap;

    public AnalysisFormulaProcessAction(FundPlanSystem system, ReportDataSource report) {
        super(system, report);
        this.orgDimension = system.getMainDimList().stream().filter(dimension -> dimension.getDimType().isOrgDim()).findFirst().get();
        this.orgMemberMap = this.orgDimension.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
    }

    @Override
    public void execute(ReportModel reportModel) {
        logger.info("AnalysisFormulaProcessAction start :\u4f53\u7cfb\u3010{}\u3011\uff0c\u67e5\u8be2\u5230\u7684\u6570\u636e\u91cf\uff1a{}", (Object)this.system.getName(), (Object)this.report.getReportDataList().size());
        List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
        if (EmptyUtil.isEmpty(reportCalcModelList)) {
            return;
        }
        for (ReportCalcModel reportCalcModel : reportCalcModelList) {
            this.process(reportCalcModel);
        }
        logger.info("AnalysisFormulaProcessAction end ");
    }

    private void process(ReportCalcModel reportCalcModel) {
        List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
        if (EmptyUtil.isEmpty(dataValList)) {
            return;
        }
        List<ReportCalcVal> summaryDataList = dataValList.stream().filter(ReportCalcVal::isDataCell).filter(reportCalcVal -> !reportCalcVal.isReferenceCell()).filter(ReportCalcVal::isSummary).filter(reportCalcVal -> !reportCalcVal.isTotalSummary()).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(summaryDataList)) {
            logger.info("\u4e0d\u5b58\u9700\u8981\u5904\u7406\u7684\u5c0f\u8ba1\u5355\u5143\u683c");
            return;
        }
        List<FormulaProcessV3Action.CalcValColRowInfo> summaryInfoList = summaryDataList.stream().map(FormulaProcessV3Action.CalcValColRowInfo::new).collect(Collectors.toList());
        this.summaryIndex = this.build(summaryInfoList, reportCalcModel);
        List<FormulaProcessV3Action.CalcValColRowInfo> calcValColRowInfoList = dataValList.stream().filter(ReportCalcVal::isDataCell).filter(reportCalcVal -> !reportCalcVal.isReferenceCell()).filter(reportCalcVal -> !reportCalcVal.isSummary()).map(FormulaProcessV3Action.CalcValColRowInfo::new).collect(Collectors.toList());
        this.dataIndex = this.build(calcValColRowInfoList, reportCalcModel);
        this.processOrgSummary(reportCalcModel, summaryDataList);
    }

    private void processOrgSummary(ReportCalcModel reportCalcModel, List<ReportCalcVal> summaryDataList) {
        ReportTemplate template = this.report.getTemplate();
        Optional<TemplateDim> findOrgDim = template.getAllTemplateDim().stream().filter(td -> td.getDimType() == DimensionType.ORG).findFirst();
        if (!findOrgDim.isPresent()) {
            return;
        }
        TemplateDim orgTemplateDim = findOrgDim.get();
        if (orgTemplateDim.getLocation() == DimLocation.PAGE) {
            return;
        }
        List<Long> memberScope = orgTemplateDim.getMemberScope();
        ArrayList<Object> topOrgList = new ArrayList<Object>(memberScope.size());
        for (Long memberId : memberScope) {
            DimMember member = this.orgMemberMap.get(memberId);
            DimMember curr = member;
            for (DimMember parent = member.getParent(); parent != null; parent = parent.getParent()) {
                if (!memberScope.contains(parent.getId())) continue;
                curr = parent;
            }
            if (topOrgList.contains(curr.getId())) continue;
            topOrgList.add(curr.getId());
        }
        this.processSummaryByLocation(reportCalcModel, orgTemplateDim, summaryDataList, topOrgList);
    }

    private void processSummaryByLocation(ReportCalcModel reportCalcModel, TemplateDim orgTemplateDim, List<ReportCalcVal> summaryDataList, List<Object> topOrgList) {
        boolean isColSummary = orgTemplateDim.getLocation() == DimLocation.COL;
        ReportCalcTree reportCalcTree = isColSummary ? reportCalcModel.getColTree() : reportCalcModel.getRowTree();
        ReportCalcValTreeNode root = reportCalcTree.getRoot();
        List<ReportCalcValTreeNode> orgSummaryNodeList = this.getAllOrgSummaryChildren(root);
        for (ReportCalcVal currentCell : summaryDataList) {
            ReportCalcValTreeNode orgSummaryNode = this.getOrgSummaryNode(orgSummaryNodeList, currentCell, isColSummary);
            if (orgSummaryNode == null) continue;
            List<ReportCalcVal> result = this.findSourceDataList(currentCell, reportCalcModel, orgSummaryNode, isColSummary, topOrgList);
            Map<String, Object> currencyInfoMap = this.getCurrencyInfoMap(reportCalcModel, result);
            currentCell.setFormula(this.getSumFormula(currentCell, result, currencyInfoMap));
            if (currentCell.getValueType().getReportCellType() != ReportCellType.PERCENT) continue;
            this.handlePercentVal(currentCell, result);
        }
    }

    private List<ReportCalcVal> findSourceDataList(ReportCalcVal currentCell, ReportCalcModel reportCalcModel, ReportCalcValTreeNode orgSummaryNode, boolean isColSummary, List<Object> topOrgList) {
        HashSet<Integer> rowLittleSumIndex = new HashSet<Integer>(128);
        HashSet<Integer> colLittleSumIndex = new HashSet<Integer>(128);
        this.fillRowAndColIndex(rowLittleSumIndex, colLittleSumIndex, reportCalcModel, null);
        int col = currentCell.getCol();
        int row = currentCell.getRow();
        DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfo(col, row);
        this.filterNullIfNeed(dimensionInfo);
        boolean superpositionSummary = this.isParentSummary(orgSummaryNode) || rowLittleSumIndex.contains(row) && colLittleSumIndex.contains(col);
        ReportDataIndexQueryMap<String> indexQueryMap = superpositionSummary ? this.summaryIndex.getIndexQueryMap() : this.dataIndex.getIndexQueryMap();
        Map<String, ReportCalcVal> dataMap = superpositionSummary ? this.summaryIndex.getDataMap() : this.dataIndex.getDataMap();
        List<String> list = indexQueryMap.findList(dimensionInfo);
        if (EmptyUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        List<ReportCalcVal> result = list.stream().distinct().map(dataMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (superpositionSummary) {
            ReportCalcValTreeNode parent = orgSummaryNode.getParent();
            if (isColSummary) {
                result.removeIf(reportCalcVal -> reportCalcVal.getCol() < parent.getCol() || reportCalcVal.getCol() > parent.getCol() + parent.getColSpan() - 1);
            } else {
                result.removeIf(reportCalcVal -> reportCalcVal.getRow() < parent.getRow() || reportCalcVal.getRow() > parent.getRow() + parent.getRowSpan() - 1);
            }
        }
        result.removeIf(reportCalcVal -> reportCalcVal.getRow() == row && reportCalcVal.getCol() == col);
        if (isColSummary && (orgSummaryNode.getChildren() == null || orgSummaryNode.getChildren().size() <= 1) && orgSummaryNode.getParent() != null && orgSummaryNode.getParent().isSummary()) {
            return result;
        }
        this.removeNotTopOrgData(result, reportCalcModel, topOrgList);
        return result;
    }

    private void removeNotTopOrgData(List<ReportCalcVal> result, ReportCalcModel reportCalcModel, List<Object> topOrgList) {
        for (int i = result.size() - 1; i >= 0; --i) {
            ReportCalcVal sourceCell = result.get(i);
            DimensionInfoBean sourceDimensionInfo = reportCalcModel.getDimensionInfo(sourceCell.getCol(), sourceCell.getRow());
            Object memberId = sourceDimensionInfo.getMemberByDimensionId(this.orgDimension.getId());
            if (topOrgList.contains(memberId)) continue;
            result.remove(sourceCell);
        }
    }

    private boolean isParentSummary(ReportCalcValTreeNode orgSummaryNode) {
        if (orgSummaryNode.getParent() == null) {
            return false;
        }
        for (ReportCalcValTreeNode parent = orgSummaryNode.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getCalcVal().isSummary()) continue;
            return true;
        }
        return false;
    }

    private ReportCalcValTreeNode getOrgSummaryNode(List<ReportCalcValTreeNode> orgSummaryNodeList, ReportCalcVal currentCell, Boolean isColSummary) {
        int col = currentCell.getCol();
        int row = currentCell.getRow();
        if (isColSummary.booleanValue()) {
            Optional<ReportCalcValTreeNode> isOrgColSummary = orgSummaryNodeList.stream().filter(node -> node.getCol() <= col && node.getCol() + node.getColSpan() - 1 >= col).max(Comparator.comparing(ReportCalcValTreeNode::getCol));
            return isOrgColSummary.orElse(null);
        }
        Optional<ReportCalcValTreeNode> isOrgRowSummary = orgSummaryNodeList.stream().filter(node -> node.getRow() <= row && node.getRow() + node.getRowSpan() - 1 >= row).max(Comparator.comparing(ReportCalcValTreeNode::getRow));
        return isOrgRowSummary.orElse(null);
    }

    public List<ReportCalcValTreeNode> getAllOrgSummaryChildren(ReportCalcValTreeNode treeNode) {
        ArrayList<ReportCalcValTreeNode> allMemberList = new ArrayList<ReportCalcValTreeNode>();
        this.getAllChildren(treeNode, allMemberList);
        return allMemberList;
    }

    private void getAllChildren(ReportCalcValTreeNode node, List<ReportCalcValTreeNode> outValList) {
        if (this.orgDimension.getId().equals(node.getCalcVal().getDimensionId()) && node.isSummary()) {
            outValList.add(node);
        }
        if (node.isSummary() && outValList.contains(node.getParent())) {
            outValList.add(node);
        }
        if (node.getChildren() == null) {
            return;
        }
        for (ReportCalcValTreeNode child : node.getChildren()) {
            this.getAllChildren(child, outValList);
        }
    }
}

