/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.ReportValueFormulaTypeEnum;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperatorSymbol;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.enums.FormulaSymbolEnum;
import kd.tmc.fpm.business.spread.generator.actions.impl.FormulaProcessV3Action;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.MetricMemberTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.util.CellReference;

public class DetailReportFormulaProcessAction
extends FormulaProcessV3Action {
    private static final Log logger = LogFactory.getLog(DetailReportFormulaProcessAction.class);

    public DetailReportFormulaProcessAction(FundPlanSystem system, ReportDataSource report) {
        super(system, report);
    }

    @Override
    protected void processSummary(ReportCalcModel reportCalcModel, List<ReportCalcVal> summaryDataList, FormulaProcessV3Action.CalcValColQueryIndex queryIndex, Predicate<ReportCalcVal> sumPredicate, Predicate<ReportCalcVal> colLittleSumCellFilter) {
        ReportTemplate template = this.report.getTemplate();
        if (template.getTemplateType() != TemplateType.DETAIL) {
            super.processSummary(reportCalcModel, summaryDataList, queryIndex, sumPredicate, colLittleSumCellFilter);
            return;
        }
        if (EmptyUtil.isEmpty(summaryDataList)) {
            logger.info("\u4e0d\u5b58\u5728\u9700\u8981\u6c47\u603b\u7684cell");
            return;
        }
        List<ReportCalcVal> totalRowCells = summaryDataList.stream().filter(sumPredicate).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(totalRowCells) || !((ReportCalcVal)totalRowCells.get(0)).isTotalSummary()) {
            logger.info("\u4e0d\u5b58\u5728\u5408\u8ba1\u884c\u7684cell");
            super.processSummary(reportCalcModel, summaryDataList, queryIndex, sumPredicate, colLittleSumCellFilter);
            return;
        }
        FormulaProcessV3Action.CalcValColQueryIndex queryTotalRowIndex = this.buildIndex(reportCalcModel, 0);
        Optional<TemplateDim> currencyOptional = template.getColDimList().stream().filter(templateDim -> templateDim.getDimType() == DimensionType.CURRENCY).findFirst();
        Optional<TemplateDim> subjectOptional = template.getColDimList().stream().filter(templateDim -> templateDim.getDimType() == DimensionType.SUBJECTS).findFirst();
        boolean currencyInCol = currencyOptional.isPresent();
        boolean subjectInCol = subjectOptional.isPresent();
        boolean allInPage = !currencyInCol && !subjectInCol;
        boolean offCombineAndCurrencyInPage = !TemplateInfoHelper.hasEnableSubjectFlowCombine(template) && !currencyInCol;
        for (ReportCalcVal reportCalcVal : totalRowCells) {
            Map<String, Object> currencyInfoMap;
            int col = reportCalcVal.getCol();
            List<Object> reportCalcValList = new ArrayList(0);
            if (allInPage || offCombineAndCurrencyInPage) {
                DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfoWithVirtual(col, reportCalcVal.getRow());
                this.filterNullIfNeed(dimensionInfo);
                Long metricDimId = this.metricDim.getId();
                Object metricMemberId = dimensionInfo.getMemberByDimensionId(metricDimId);
                Optional<Object> metricMemberOpt = Optional.empty();
                if (!Objects.equals(metricMemberId, 0L)) {
                    metricMemberOpt = this.metricDim.getAllDimMemberList().stream().filter(MetricMember.class::isInstance).filter(member -> Objects.equals(member.getId(), metricMemberId)).map(MetricMember.class::cast).findAny();
                }
                if (!metricMemberOpt.isPresent() || ((MetricMember)metricMemberOpt.get()).getMetricType() == MetricMemberTypeEnum.BASE) {
                    if (reportCalcVal.isTotalSummaryOfLittleSummary()) {
                        reportCalcValList = this.filterSumItems(totalRowCells, reportCalcVal);
                        currencyInfoMap = this.getCurrencyInfoMap(reportCalcModel, reportCalcValList);
                        reportCalcVal.setFormula(this.getSumFormula(reportCalcVal, reportCalcValList, currencyInfoMap));
                    } else {
                        reportCalcValList = reportCalcModel.getDataValList().stream().filter(rcv -> rcv.getCol() == col && rcv.getRow() != reportCalcVal.getRow()).collect(Collectors.toList());
                        BigDecimal currBaseMetricTotalAmt = BigDecimal.ZERO;
                        for (ReportCalcVal reportCalcVal2 : reportCalcValList) {
                            if (Objects.isNull(reportCalcVal2.getValue())) continue;
                            BigDecimal baseMetricValAmt = (BigDecimal)reportCalcVal2.getValue();
                            currBaseMetricTotalAmt = currBaseMetricTotalAmt.add(baseMetricValAmt);
                        }
                        reportCalcVal.setValue(currBaseMetricTotalAmt);
                        reportCalcVal.setDisplayVal(currBaseMetricTotalAmt.toPlainString());
                    }
                } else {
                    this.calTotalRowMetricVal(reportCalcVal, reportCalcModel, queryTotalRowIndex);
                }
            } else if (reportCalcVal.isTotalSummaryOfLittleSummary()) {
                reportCalcValList = this.filterSumItems(totalRowCells, reportCalcVal);
                currencyInfoMap = this.getCurrencyInfoMap(reportCalcModel, reportCalcValList);
                reportCalcVal.setFormula(this.getSumFormula(reportCalcVal, reportCalcValList, currencyInfoMap));
            } else {
                this.calTotalRowMetricVal(reportCalcVal, reportCalcModel, queryTotalRowIndex);
            }
            this.handlePercentVal(reportCalcVal, reportCalcValList);
        }
    }

    protected List<ReportCalcVal> filterSumItems(List<ReportCalcVal> totalRowCells, ReportCalcVal reportCalcVal) {
        List indexes = totalRowCells.stream().filter(rcv -> rcv.getRow() == reportCalcVal.getRow()).filter(ReportCalcVal::isTotalSummaryOfLittleSummary).sorted(Comparator.comparing(ReportCalcVal::getCol)).map(ReportCalcVal::getCol).collect(Collectors.toList());
        Integer previousSumColIndex = 0;
        int currentCol = reportCalcVal.getCol();
        int currentIdx = indexes.indexOf(currentCol);
        int size = indexes.size();
        int lastIdx = size - 1;
        if (currentIdx >= 1) {
            if (size > 2) {
                int theLastOne = (Integer)indexes.get(size - 1);
                int lastButTwo = (Integer)indexes.get(size - 2);
                if (currentIdx < lastIdx || theLastOne - lastButTwo > 1) {
                    previousSumColIndex = (Integer)indexes.get(currentIdx - 1);
                }
            } else if (size > 1) {
                previousSumColIndex = (Integer)indexes.get(currentIdx - 1);
            }
        }
        int beginCol = previousSumColIndex;
        List<ReportCalcVal> result = totalRowCells.stream().filter(rcv -> !rcv.isTotalSummaryOfLittleSummary()).filter(rcv -> rcv.getRow() == reportCalcVal.getRow()).filter(rcv -> {
            boolean lowSumCol;
            boolean bl = lowSumCol = rcv.getCol() < reportCalcVal.getCol();
            boolean highCol = beginCol == 0 ? rcv.getCol() >= beginCol : rcv.getCol() > beginCol;
            return highCol && lowSumCol;
        }).collect(Collectors.toList());
        return result;
    }

    protected Formula getSumFormulaForTotalRow(ReportCalcVal leftCalcVal, List<ReportCalcVal> reportCalcValList) {
        Formula formula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(new CellReference(leftCalcVal.getRow(), leftCalcVal.getCol()).formatAsString());
        formula.setLeftVal(leftOperationVal);
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        for (ReportCalcVal reportCalcVal : reportCalcValList) {
            int currCol = reportCalcVal.getCol();
            int currRow = reportCalcVal.getRow();
            String excelPost = new CellReference(currRow, currCol).formatAsString();
            FormulaOperationVal rightVal = new FormulaOperationVal();
            rightVal.setName(excelPost);
            if (reportCalcVal.getValue() != null) {
                rightVal.setValue(reportCalcVal.getValue().toString());
            }
            operator.add(rightVal);
            FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.PLUS);
            operator.add(addSymbol);
        }
        if (CollectionUtils.isNotEmpty(operator)) {
            operator.removeLast();
        }
        formula.setOperator(operator);
        return formula;
    }

    protected FormulaProcessV3Action.CalcValColQueryIndex buildIndex(ReportCalcModel reportCalcModel, int rowOffset) {
        List dimensionIds;
        List calcValColRowInfoList = reportCalcModel.getDataValList().stream().filter(reportCalcVal -> reportCalcVal.isDataCell() || this.isAmountType((ReportCalcVal)reportCalcVal)).filter(reportCalcVal -> !reportCalcVal.isReferenceCell()).filter(reportCalcVal -> !reportCalcVal.isSummary()).map(FormulaProcessV3Action.CalcValColRowInfo::new).collect(Collectors.toList());
        ReportDataIndexQueryMap<String> map = new ReportDataIndexQueryMap<String>(calcValColRowInfoList.size());
        Set mainDimensionIds = this.system.getMainDimList().stream().map(Dimension::getId).collect(Collectors.toSet());
        boolean enableSubjectFlowCombine = TemplateInfoHelper.hasEnableSubjectFlowCombine(this.report.getTemplate());
        if (enableSubjectFlowCombine && !CollectionUtils.isEmpty(dimensionIds = reportCalcModel.getColTree().getLeafList().stream().filter(item -> item.getCalcVal().isVirtualCell()).map(item -> item.getCalcVal().getDimensionId()).collect(Collectors.toList()))) {
            mainDimensionIds.addAll(dimensionIds);
        }
        HashMap<String, ReportCalcVal> dataMap = new HashMap<String, ReportCalcVal>(calcValColRowInfoList.size());
        for (FormulaProcessV3Action.CalcValColRowInfo calcValColRowInfo : calcValColRowInfoList) {
            ReportCalcVal reportCalcVal2 = calcValColRowInfo.getReportCalcVal();
            DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfoWithVirtual(reportCalcVal2.getCol(), reportCalcVal2.getRow() - rowOffset);
            this.filterNullIfNeed(dimensionInfo);
            List dimensionIdList = dimensionInfo.getDimensionIdList();
            List memberIdList = dimensionInfo.getMemberIdList();
            for (int i = 0; i < dimensionIdList.size(); ++i) {
                Long dimensionId = (Long)dimensionIdList.get(i);
                if (!mainDimensionIds.contains(dimensionId)) continue;
                Long memberId = (Long)memberIdList.get(i);
                map.addData(dimensionId, memberId, calcValColRowInfo.getColRow());
            }
            dataMap.put(calcValColRowInfo.getColRow(), reportCalcVal2);
        }
        return new FormulaProcessV3Action.CalcValColQueryIndex(map, dataMap);
    }

    private boolean isAmountType(ReportCalcVal reportCalcVal) {
        if (reportCalcVal.getValueType() == null) {
            return false;
        }
        if (reportCalcVal.getValueType().getReportCellType() == null) {
            return false;
        }
        return reportCalcVal.getValueType().getReportCellType() == ReportCellType.AMOUNT;
    }

    private void calTotalRowMetricVal(ReportCalcVal currReportCalcVal, ReportCalcModel reportCalcModel, FormulaProcessV3Action.CalcValColQueryIndex queryTotalRowIndex) {
        int col = currReportCalcVal.getCol();
        int row = currReportCalcVal.getRow();
        DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfoWithVirtual(col, row);
        this.filterNullIfNeed(dimensionInfo);
        Long metricDimId = this.metricDim.getId();
        Object metricMemberId = dimensionInfo.getMemberByDimensionId(metricDimId);
        Optional<Object> metricMemberOpt = Optional.empty();
        if (!Objects.equals(metricMemberId, 0L)) {
            metricMemberOpt = this.metricDim.getAllDimMemberList().stream().filter(MetricMember.class::isInstance).filter(member -> Objects.equals(member.getId(), metricMemberId)).map(MetricMember.class::cast).findAny();
        }
        if (!metricMemberOpt.isPresent() || ((MetricMember)metricMemberOpt.get()).getMetricType() == MetricMemberTypeEnum.BASE) {
            this.calTotalRowBaseMetricValCal(currReportCalcVal, dimensionInfo, queryTotalRowIndex);
            return;
        }
        if (((MetricMember)metricMemberOpt.get()).getMetricType() == MetricMemberTypeEnum.ANALYSE) {
            this.calTotalRowAnalyseMetricVal(currReportCalcVal, dimensionInfo, (MetricMember)metricMemberOpt.get(), queryTotalRowIndex, reportCalcModel);
        }
    }

    private void calTotalRowBaseMetricValCal(ReportCalcVal reportCalcVal, DimensionInfoBean dimensionInfo, FormulaProcessV3Action.CalcValColQueryIndex queryTotalRowIndex) {
        OptionalInt netInFlowMemberIdx = IntStream.range(0, dimensionInfo.getMemberIdList().size()).filter(i -> Objects.equals(dimensionInfo.getMemberIdList().get(i), FlowType.NETINFLOW.getVirtualId())).findAny();
        if (netInFlowMemberIdx.isPresent()) {
            this.calNetFlowTotalRowBaseMetricValCal(reportCalcVal, dimensionInfo, queryTotalRowIndex, netInFlowMemberIdx.getAsInt());
            return;
        }
        List<ReportCalcVal> reportCalcValList = this.findReportCalcValListByDimensionInfoInfo(dimensionInfo, queryTotalRowIndex);
        if (CollectionUtils.isEmpty(reportCalcValList)) {
            return;
        }
        if (CollectionUtils.isEmpty(reportCalcValList = reportCalcValList.stream().filter(item -> item.getCol() == reportCalcVal.getCol()).collect(Collectors.toList()))) {
            return;
        }
        BigDecimal currBaseMetricTotalAmt = BigDecimal.ZERO;
        for (ReportCalcVal baseMetricReportCalcVal : reportCalcValList) {
            if (Objects.isNull(baseMetricReportCalcVal.getValue())) continue;
            BigDecimal baseMetricValAmt = (BigDecimal)baseMetricReportCalcVal.getValue();
            currBaseMetricTotalAmt = currBaseMetricTotalAmt.add(baseMetricValAmt);
        }
        reportCalcVal.setValue(currBaseMetricTotalAmt);
        reportCalcVal.setDisplayVal(currBaseMetricTotalAmt.toPlainString());
    }

    private List<ReportCalcVal> findReportCalcValListByDimensionInfoInfo(DimensionInfoBean dimensionInfo, FormulaProcessV3Action.CalcValColQueryIndex queryTotalRowIndex) {
        ReportDataIndexQueryMap<String> indexQueryMap = queryTotalRowIndex.getIndexQueryMap();
        Map<String, ReportCalcVal> dataMap = queryTotalRowIndex.getDataMap();
        List<String> list = indexQueryMap.findList(dimensionInfo);
        if (EmptyUtil.isEmpty(list)) {
            return new ArrayList<ReportCalcVal>(0);
        }
        return list.stream().distinct().map(dataMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void calTotalRowAnalyseMetricVal(ReportCalcVal reportCalcVal, DimensionInfoBean dimensionInfo, MetricMember analyseMetricMember, FormulaProcessV3Action.CalcValColQueryIndex queryTotalRowIndex, ReportCalcModel reportCalcModel) {
        OptionalInt netInFlowMemberIdx = IntStream.range(0, dimensionInfo.getMemberIdList().size()).filter(i -> Objects.equals(dimensionInfo.getMemberIdList().get(i), FlowType.NETINFLOW.getVirtualId())).findAny();
        if (netInFlowMemberIdx.isPresent()) {
            this.calNetFlowTotalRowAnalyseMetricValCal(reportCalcVal, dimensionInfo, analyseMetricMember, queryTotalRowIndex, reportCalcModel, netInFlowMemberIdx.getAsInt());
            return;
        }
        HashMap<TemplateMetricType, String> calculateParam = new HashMap<TemplateMetricType, String>(8);
        List<ReportValueFormulaTypeEnum> reportValueFormulaTypeEnums = MetricValueUtils.splitFormulaBaseMetricType(analyseMetricMember.getValStr());
        for (ReportValueFormulaTypeEnum reportValueFormulaTypeEnum : reportValueFormulaTypeEnums) {
            TemplateMetricType templateMetricType = MetricValueUtils.switchType(reportValueFormulaTypeEnum);
            MetricMember currBaseMetricMember = this.templateMetricType2MetricMemberMap.get(templateMetricType.getCode());
            DimensionInfoBean dimensionInfoBeanCopy = dimensionInfo.copy();
            dimensionInfoBeanCopy.replaceValueIfContains(analyseMetricMember.getDimensionId(), (Object)currBaseMetricMember.getId());
            List<ReportCalcVal> reportCalcValList = this.findReportCalcValListByDimensionInfoInfo(dimensionInfoBeanCopy, queryTotalRowIndex);
            if (CollectionUtils.isEmpty(reportCalcValList)) {
                reportCalcVal.setValue(BigDecimal.ZERO);
                reportCalcVal.setDisplayVal(BigDecimal.ZERO.toPlainString());
                reportCalcVal.setFormula(null);
                return;
            }
            Map<String, Object> currencyInfoMap = this.getCurrencyInfoMap(reportCalcModel, reportCalcValList);
            BigDecimal currBaseMetricTotalAmt = BigDecimal.ZERO;
            for (ReportCalcVal baseMetricReportCalcVal : reportCalcValList) {
                if (Objects.isNull(baseMetricReportCalcVal.getValue())) continue;
                String key = String.join((CharSequence)"_", String.valueOf(baseMetricReportCalcVal.getCol()), String.valueOf(baseMetricReportCalcVal.getRow()));
                Object currencyId = currencyInfoMap.getOrDefault(key, 0L);
                BigDecimal rate = this.getCurrencyRate((Long)currencyId, currencyInfoMap);
                BigDecimal baseMetricValAmt = rate.multiply((BigDecimal)baseMetricReportCalcVal.getValue());
                currBaseMetricTotalAmt = currBaseMetricTotalAmt.add(baseMetricValAmt);
            }
            calculateParam.put(templateMetricType, currBaseMetricTotalAmt.toPlainString());
        }
        BigDecimal analyseMetricTotalAmt = MetricValueUtils.computeByExpress(analyseMetricMember, calculateParam);
        analyseMetricTotalAmt = MetricValueUtils.transferScaleIfPercent(analyseMetricMember.getDataType().isPercent(), analyseMetricTotalAmt);
        reportCalcVal.setValue(analyseMetricTotalAmt);
        reportCalcVal.setDisplayVal(analyseMetricTotalAmt.toPlainString());
    }

    private void calNetFlowTotalRowBaseMetricValCal(ReportCalcVal reportCalcVal, DimensionInfoBean dimensionInfo, FormulaProcessV3Action.CalcValColQueryIndex queryTotalRowIndex, int netInFlowMemberIdIdx) {
        DimensionInfoBean dimensionInfoBeanCopy = dimensionInfo.copy();
        Long flowDimId = (Long)dimensionInfoBeanCopy.getDimensionIdList().get(netInFlowMemberIdIdx);
        dimensionInfoBeanCopy.replaceValueIfContains(flowDimId, (Object)FlowType.IN.getVirtualId());
        BigDecimal inFlowTotalAmt = this.sumReportCalcValListByDimensionInfoInfo(dimensionInfoBeanCopy, queryTotalRowIndex, reportCalcVal.getCol());
        dimensionInfoBeanCopy.replaceValueIfContains(flowDimId, (Object)FlowType.OUT.getVirtualId());
        BigDecimal outFlowTotalAmt = this.sumReportCalcValListByDimensionInfoInfo(dimensionInfoBeanCopy, queryTotalRowIndex, reportCalcVal.getCol());
        BigDecimal netInFlowTotalAmt = inFlowTotalAmt.subtract(outFlowTotalAmt);
        reportCalcVal.setValue(netInFlowTotalAmt);
        reportCalcVal.setDisplayVal(netInFlowTotalAmt.toPlainString());
    }

    private void calNetFlowTotalRowAnalyseMetricValCal(ReportCalcVal reportCalcVal, DimensionInfoBean dimensionInfo, MetricMember analyseMetricMember, FormulaProcessV3Action.CalcValColQueryIndex queryTotalRowIndex, ReportCalcModel reportCalcModel, int netInFlowMemberIdIdx) {
        HashMap<TemplateMetricType, String> calculateParam = new HashMap<TemplateMetricType, String>(8);
        List<ReportValueFormulaTypeEnum> reportValueFormulaTypeEnums = MetricValueUtils.splitFormulaBaseMetricType(analyseMetricMember.getValStr());
        for (ReportValueFormulaTypeEnum reportValueFormulaTypeEnum : reportValueFormulaTypeEnums) {
            TemplateMetricType templateMetricType = MetricValueUtils.switchType(reportValueFormulaTypeEnum);
            MetricMember currBaseMetricMember = this.templateMetricType2MetricMemberMap.get(templateMetricType.getCode());
            DimensionInfoBean dimensionInfoBeanCopy = dimensionInfo.copy();
            dimensionInfoBeanCopy.replaceValueIfContains(analyseMetricMember.getDimensionId(), (Object)currBaseMetricMember.getId());
            HashMap<FlowType, BigDecimal> inOutMap = new HashMap<FlowType, BigDecimal>(2, 1.0f);
            inOutMap.put(FlowType.IN, BigDecimal.ZERO);
            inOutMap.put(FlowType.OUT, BigDecimal.ZERO);
            for (FlowType flowType : inOutMap.keySet()) {
                Long flowDimId = (Long)dimensionInfoBeanCopy.getDimensionIdList().get(netInFlowMemberIdIdx);
                dimensionInfoBeanCopy.replaceValueIfContains(flowDimId, (Object)flowType.getVirtualId());
                List<ReportCalcVal> reportCalcValList = this.findReportCalcValListByDimensionInfoInfo(dimensionInfoBeanCopy, queryTotalRowIndex);
                if (CollectionUtils.isEmpty(reportCalcValList)) continue;
                Map<String, Object> currencyInfoMap = this.getCurrencyInfoMap(reportCalcModel, reportCalcValList);
                BigDecimal currBaseMetricTotalAmt = BigDecimal.ZERO;
                for (ReportCalcVal baseMetricReportCalcVal : reportCalcValList) {
                    if (Objects.isNull(baseMetricReportCalcVal.getValue())) continue;
                    String key = String.join((CharSequence)"_", String.valueOf(baseMetricReportCalcVal.getCol()), String.valueOf(baseMetricReportCalcVal.getRow()));
                    Object currencyId = currencyInfoMap.getOrDefault(key, 0L);
                    BigDecimal rate = this.getCurrencyRate((Long)currencyId, currencyInfoMap);
                    BigDecimal baseMetricValAmt = rate.multiply((BigDecimal)baseMetricReportCalcVal.getValue());
                    currBaseMetricTotalAmt = currBaseMetricTotalAmt.add(baseMetricValAmt);
                }
                inOutMap.put(flowType, currBaseMetricTotalAmt);
            }
            BigDecimal currBaseMetricTotalAmt = ((BigDecimal)inOutMap.get((Object)FlowType.IN)).subtract((BigDecimal)inOutMap.get((Object)FlowType.OUT));
            calculateParam.put(templateMetricType, currBaseMetricTotalAmt.toPlainString());
        }
        BigDecimal analyseMetricTotalAmt = MetricValueUtils.computeByExpress(analyseMetricMember, calculateParam);
        analyseMetricTotalAmt = MetricValueUtils.transferScaleIfPercent(analyseMetricMember.getDataType().isPercent(), analyseMetricTotalAmt);
        reportCalcVal.setValue(analyseMetricTotalAmt);
        reportCalcVal.setDisplayVal(analyseMetricTotalAmt.toPlainString());
    }

    private BigDecimal sumReportCalcValListByDimensionInfoInfo(DimensionInfoBean dimensionInfo, FormulaProcessV3Action.CalcValColQueryIndex queryTotalRowIndex, int currCol) {
        List<ReportCalcVal> reportCalcValList = this.findReportCalcValListByDimensionInfoInfo(dimensionInfo, queryTotalRowIndex);
        if (CollectionUtils.isEmpty(reportCalcValList)) {
            return BigDecimal.ZERO;
        }
        if (CollectionUtils.isEmpty(reportCalcValList = reportCalcValList.stream().filter(item -> item.getCol() == currCol).collect(Collectors.toList()))) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (ReportCalcVal reportCalcVal : reportCalcValList) {
            if (Objects.isNull(reportCalcVal.getValue())) continue;
            BigDecimal baseMetricValAmt = (BigDecimal)reportCalcVal.getValue();
            totalAmt = totalAmt.add(baseMetricValAmt);
        }
        return totalAmt;
    }
}

