/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDataType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcVirtualTreeNode;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportTemplateBuildV2Action;
import kd.tmc.fpm.spread.widget.DisplayTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class ExportTemplateBuildAction
extends ReportTemplateBuildV2Action {
    public ExportTemplateBuildAction(FundPlanSystem system, ReportDataSource report) {
        super(system, report);
    }

    @Override
    protected List<ReportCalcVal> buildDetailColDimValListForTree(List<TemplateDim> dimList) {
        TemplateDim templateDim;
        ReportCalcValTreeNode colRoot = new ReportCalcValTreeNode();
        List<Dimension> systemDimList = this.system.getDimList();
        Map systemDimMap = systemDimList.stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        Optional<TemplateDim> first = dimList.stream().filter(dim -> !dim.isViDim()).filter(TemplateDim::isExpand).findFirst();
        Supplier<List> supplier = Collections::emptyList;
        int maxDepth = 1;
        Optional<TemplateDim> dataBaseDimOptional = dimList.stream().filter(c -> DetailDataType.BASEDATA == c.getDetailDataType()).filter(TemplateDim::isVisible).findFirst();
        if (!first.isPresent() && dataBaseDimOptional.isPresent()) {
            ++maxDepth;
        }
        if (first.isPresent()) {
            ReportCalcValTreeNode node = new ReportCalcValTreeNode();
            this.buildReportDimTree(Collections.singletonList(first.get()), 0, 1, node, null, DimLocation.COL, 0);
            List<ReportCalcValTreeNode> children = node.getChildren();
            while (EmptyUtil.isNoEmpty((Object)children)) {
                ReportCalcValTreeNode anyChild = (ReportCalcValTreeNode)children.get(0);
                children = anyChild.getChildren();
                ++maxDepth;
            }
            supplier = node::getChildren;
        }
        Long expandedDimensionId = 0L;
        for (TemplateDim currDim : dimList) {
            if (this.skipVirtualDim(currDim)) continue;
            Dimension dimension = (Dimension)systemDimMap.get(currDim.getDimensionId());
            ReportCalcValTreeNode treeNode = new ReportCalcValTreeNode();
            treeNode.setDimensionName(currDim.getDimensionName());
            treeNode.setDimensionId(currDim.getDimensionId());
            treeNode.setDisplayVal(currDim.getDimensionName());
            treeNode.setValue(currDim.getDimensionId());
            if (Objects.nonNull(dimension) && dimension.isMustInput()) {
                treeNode.setDisplayType(DisplayTypeEnum.MUSTRECORD);
            }
            ReportValueType reportValueType = new ReportValueType();
            reportValueType.setReportCellType(ReportCellType.TEXT);
            treeNode.getCalcVal().setValueType(reportValueType);
            treeNode.getCalcVal().setVirtualCell(currDim.isViDim());
            if (Objects.nonNull(dimension) && dimension.getDetailDimType() == DetailDimType.PLAN_AMOUNT) {
                treeNode.setSkipVal(true);
            }
            if (Objects.nonNull(dimension) && dimension.getDetailDimType() == DetailDimType.CONNTERPARTY_TYPE) {
                reportValueType.setReportCellType(ReportCellType.MUTI_BASE_DATA);
                List extValList = JSONArray.parseArray((String)DetailDimType.CONNTERPARTY_TYPE.getExtVal().toString(), JSONObject.class);
                HashMap<String, String> extMap = new HashMap<String, String>(extValList.size());
                for (JSONObject o : extValList) {
                    extMap.put(o.getString("value"), o.getString("key"));
                }
                reportValueType.setValue(extMap);
            }
            boolean hasDetailDimDataBase = this.isHasDetailDimDataBase(currDim, treeNode, maxDepth);
            if (currDim.isExpand()) {
                if (EmptyUtil.isNoEmpty((Long)expandedDimensionId)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u3010%1$s\u3011\u5217\u7ef4\u4fe1\u606f\u914d\u7f6e\u9519\u8bef\uff1a\u4ec5\u5141\u8bb8\u4e00\u4e2a\u5217\u6210\u5458\u5e73\u94fa\u5c55\u5f00, \u8bf7\u68c0\u67e5", (String)"ExportTemplateBuildAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]), this.report.getTemplate().getNumber()));
                }
                expandedDimensionId = currDim.getDimensionId();
                treeNode.setChildren(supplier.get());
                treeNode.setSkipVal(true);
            } else {
                if (!currDim.isVisible()) continue;
                if (!hasDetailDimDataBase) {
                    this.createChildren(treeNode, maxDepth, 1);
                }
            }
            colRoot.addChild(treeNode);
        }
        if (first.isPresent() && (templateDim = first.get()).getDimType() == DimensionType.PERIOD) {
            templateDim.setLevel(templateDim.getLevel() + 1);
            this.addVirtualNodeForPeriodHasDetailIfNeed(colRoot, Collections.singletonList(first.get()), DimLocation.COL);
            this.replaceDetailPeriodWithVirtualNode(colRoot, Collections.singletonList(first.get()), DimLocation.COL);
            templateDim.setLevel(templateDim.getLevel() - 1);
        }
        this.rebuildRowColInfo(colRoot, DimLocation.COL);
        this.removeVirtualNodeAndRebuildRowColSpan(colRoot, DimLocation.COL);
        this.reportModel.getTemplateModel().setColTree(new ReportCalcTree(colRoot));
        return colRoot.getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
    }

    @Override
    protected void addVirtualNodeForPeriodHasDetailIfNeed(ReportCalcValTreeNode colRoot, List<TemplateDim> dimList, DimLocation location) {
        if (location != DimLocation.COL) {
            return;
        }
        if (!this.hasDetailPeriod) {
            return;
        }
        Optional<TemplateDim> first = dimList.stream().filter(templateDim -> templateDim.getLocation() == location).filter(templateDim -> templateDim.getDimType() == DimensionType.PERIOD).findFirst();
        if (!first.isPresent()) {
            return;
        }
        TemplateDim templateDim2 = first.get();
        if (!templateDim2.isIncludeSum()) {
            return;
        }
        int level = templateDim2.getLevel();
        List<ReportCalcValTreeNode> periodParentNodes = Collections.emptyList();
        List<ReportCalcValTreeNode> tempChildren = colRoot.getChildren();
        while (level > 1 && CollectionUtils.isNotEmpty(tempChildren) && !CollectionUtils.isNotEmpty(periodParentNodes = tempChildren.stream().filter(Objects::nonNull).filter(rcv -> rcv.getCalcVal() != null && Objects.equals(templateDim2.getDimensionId(), rcv.getCalcVal().getDimensionId())).collect(Collectors.toList()))) {
            tempChildren = tempChildren.stream().map(ReportCalcValTreeNode::getChildren).flatMap(Collection::stream).collect(Collectors.toList());
        }
        for (ReportCalcValTreeNode periodNode : periodParentNodes) {
            List<ReportCalcValTreeNode> periodAndSubSumNode = periodNode.getChildren();
            ReportCalcValTreeNode subSumNode = periodAndSubSumNode.get(periodAndSubSumNode.size() - 1);
            if (ReportCalcVirtualTreeNode.class.isInstance(subSumNode)) continue;
            List<ReportCalcValTreeNode> children = subSumNode.getChildren();
            subSumNode.setChildren(null);
            ReportCalcVirtualTreeNode virtualTreeNode = new ReportCalcVirtualTreeNode();
            subSumNode.addChild(virtualTreeNode);
            virtualTreeNode.setChildren(children);
        }
    }

    private boolean isHasDetailDimDataBase(TemplateDim currDim, ReportCalcValTreeNode treeNode, int max) {
        boolean hasDetailDimDataBase = false;
        if (currDim.getDetailDataType() == DetailDataType.BASEDATA) {
            hasDetailDimDataBase = true;
            ReportCalcValTreeNode valNum = new ReportCalcValTreeNode();
            valNum.setDimensionName("BD_NUMBER");
            valNum.setDimensionId(currDim.getDimensionId());
            valNum.setDisplayVal(ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExportTemplateBuildAction_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            valNum.setDisplayType(DisplayTypeEnum.NUMBER);
            this.createChildren(valNum, max, 2);
            ReportCalcValTreeNode valName = new ReportCalcValTreeNode();
            valName.setDimensionName("BD_NAME");
            valName.setDimensionId(currDim.getDimensionId());
            valName.setDisplayVal(ResManager.loadKDString((String)"\u540d\u79f0", (String)"ExportTemplateBuildAction_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
            treeNode.addChild(valNum);
            treeNode.addChild(valName);
            this.createChildren(valName, max, 2);
        }
        return hasDetailDimDataBase;
    }
}

