/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.impl.AbstractAnalysisReportDataBuildService;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.FlowEnum;

public class MultiAnalysisNetInFlowReportDataService
extends AbstractAnalysisReportDataBuildService {
    public MultiAnalysisNetInFlowReportDataService(AbstractAnalysisReportDataBuildService abstractAnalysisReportDataBuildService) {
        super(abstractAnalysisReportDataBuildService);
    }

    @Override
    protected void rebuildData() {
        super.rebuildData();
        DimensionIndexTree indexTree = this.analysisReport.getIndexTree(this.system);
        Dimension accountTypeDim = this.system.getMainDimensionByDimType(DimensionType.ACCOUNTTYPE);
        Map subjectFlowMemberMap = accountTypeDim.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getNumber, Function.identity(), (a, b) -> a));
        DimMember netInFlowMember = (DimMember)subjectFlowMemberMap.get(FlowEnum.NETINFLOW.getValue());
        if (EmptyUtil.isEmpty((Object)netInFlowMember)) {
            return;
        }
        List leafList = indexTree.getLeafList().stream().filter(node -> node.getDimInfoBean().containsMemberId((Object)netInFlowMember.getId())).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(leafList)) {
            return;
        }
        Long accountTypeDimId = accountTypeDim.getId();
        ArrayList<ReportData> reportDataList = new ArrayList<ReportData>(216);
        for (TreeNode treeNode : leafList) {
            List<Object> dataList = treeNode.getDataList();
            if (EmptyUtil.isNoEmpty(dataList)) continue;
            DimensionInfoBean dimInfoBean = treeNode.getDimInfoBean();
            DimMember inFlowMember = (DimMember)subjectFlowMemberMap.get(FlowEnum.INFLOW.getValue());
            DimensionInfoBean copy = dimInfoBean.copy();
            copy.replaceValueIfContains(accountTypeDimId, (Object)inFlowMember.getId());
            TreeNode inFlowNode = indexTree.find(copy);
            DimMember outFlowMember = (DimMember)subjectFlowMemberMap.get(FlowEnum.OUTFLOW.getValue());
            copy.replaceValueIfContains(accountTypeDimId, (Object)outFlowMember.getId());
            TreeNode outFlowNode = indexTree.find(copy);
            Consumer<ReportData> dataConsumer = this.getNetInFlowDataConsumer(treeNode, netInFlowMember, reportDataList);
            this.calculateNetFlowData(dataConsumer, inFlowNode, outFlowNode);
        }
        if (EmptyUtil.isEmpty(reportDataList)) {
            return;
        }
        this.analysisReport.getReportDataList().addAll(reportDataList);
    }

    private Consumer<ReportData> getNetInFlowDataConsumer(TreeNode treeNode, DimMember netInFlowMember, List<ReportData> reportDataList) {
        return reportData -> {
            if (reportData == null) {
                return;
            }
            List<TemplateDim> dimList = reportData.getDimList();
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                if (!Objects.equals(templateDim.getDimensionId(), netInFlowMember.getDimensionId())) continue;
                reportData.getDimValList().set(i, netInFlowMember.getId());
                break;
            }
            treeNode.addData(reportData);
            reportDataList.add((ReportData)reportData);
        };
    }

    private void calculateNetFlowData(Consumer<ReportData> dataConsumer, TreeNode inFlowNode, TreeNode outFlowNode) {
        ReportData positiveData = this.getPositiveData(inFlowNode);
        if ((positiveData = this.negativeData(positiveData, outFlowNode)) != null) {
            dataConsumer.accept(positiveData);
        }
    }

    private ReportData negativeData(ReportData positiveData, TreeNode outFlowNode) {
        List<Object> dataList = outFlowNode.getDataList();
        if (EmptyUtil.isEmpty(dataList)) {
            return positiveData;
        }
        if (positiveData == null) {
            positiveData = new ReportData((ReportData)dataList.get(0));
            positiveData.clearAmt();
        }
        dataList.stream().map(ReportData.class::cast).forEach(positiveData::subtract);
        return positiveData;
    }

    private ReportData getPositiveData(TreeNode inFlowNode) {
        List<Object> dataList = inFlowNode.getDataList();
        if (EmptyUtil.isEmpty(dataList)) {
            return null;
        }
        ReportData netInFlowReportData = new ReportData((ReportData)dataList.get(0));
        netInFlowReportData.clearAmt();
        dataList.stream().map(ReportData.class::cast).forEach(netInFlowReportData::add);
        return netInFlowReportData;
    }
}

