/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;

public class MultiSumReportSummaryProcessAction
implements IReportDataProcessAction {
    private FundPlanSystem fundPlanSystem;
    private ReportDataSource reportDataSource;
    private static final Log logger = LogFactory.getLog(MultiSumReportSummaryProcessAction.class);

    public MultiSumReportSummaryProcessAction(FundPlanSystem fundPlanSystem, ReportDataSource reportDataSource) {
        this.fundPlanSystem = fundPlanSystem;
        this.reportDataSource = reportDataSource;
    }

    @Override
    public void execute(ReportModel reportModel) {
        logger.info("MultiSumReportSummaryProcessAction start :\u4f53\u7cfb\u3010{}\u3011\uff0c\u67e5\u8be2\u5230\u7684\u6570\u636e\u91cf\uff1a{}", (Object)this.fundPlanSystem.getName(), (Object)this.reportDataSource.getReportDataList().size());
        List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
        if (EmptyUtil.isEmpty(reportCalcModelList)) {
            return;
        }
        reportCalcModelList.forEach(this::process);
        logger.info("MultiSumReportSummaryProcessAction end ");
    }

    private void process(ReportCalcModel reportCalcModel) {
        this.addTotalSummary(reportCalcModel);
    }

    private void addTotalSummary(ReportCalcModel reportCalcModel) {
        int totalSummaryRow = reportCalcModel.getRowDimValList().stream().map(ReportCalcVal::getRow).max(Integer::compareTo).orElse(0) + 1;
        this.createTotalSummaryDim(reportCalcModel, totalSummaryRow);
        this.createTotalSummaryCell(reportCalcModel, totalSummaryRow);
    }

    private void createTotalSummaryCell(ReportCalcModel reportCalcModel, int totalSummaryRow) {
        int minCol;
        List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
        int maxCol = reportCalcModel.getColDimValList().stream().map(ReportCalcVal::getCol).max(Integer::compareTo).orElse(0);
        for (int col = minCol = reportCalcModel.getColDimValList().stream().filter(reportCalcVal -> EmptyUtil.isNoEmpty((Long)reportCalcVal.getDimensionId())).map(ReportCalcVal::getCol).min(Integer::compareTo).orElse(0).intValue(); col <= maxCol; ++col) {
            ReportCalcVal reportCalcVal2 = new ReportCalcVal();
            reportCalcVal2.setRow(totalSummaryRow);
            reportCalcVal2.setCol(col);
            ReportValueType amountType = new ReportValueType();
            amountType.setReportCellType(ReportCellType.AMOUNT);
            reportCalcVal2.setValueType(amountType);
            reportCalcVal2.setColSpan(1);
            reportCalcVal2.setRowSpan(1);
            reportCalcVal2.setSummary(true);
            reportCalcVal2.setEnable(false);
            reportCalcVal2.setDataCell(true);
            dataValList.add(reportCalcVal2);
        }
    }

    private void createTotalSummaryDim(ReportCalcModel reportCalcModel, int totalSummaryRow) {
        List<ReportCalcVal> rowDimValList = reportCalcModel.getRowDimValList();
        int startColIndex = reportCalcModel.getColDimValList().get(0).getCol();
        ReportCalcVal totalSummaryDim = new ReportCalcVal();
        totalSummaryDim.setCol(0);
        totalSummaryDim.setRow(totalSummaryRow);
        totalSummaryDim.setColSpan(startColIndex);
        String totalSummaryRowName = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"MultiSumReportSummaryProcessAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
        totalSummaryDim.setDisplayVal(totalSummaryRowName);
        totalSummaryDim.setValue(totalSummaryRowName);
        ReportValueType type = new ReportValueType();
        type.setReportCellType(ReportCellType.TEXT);
        totalSummaryDim.setValueType(type);
        totalSummaryDim.setRowSpan(1);
        totalSummaryDim.setTotalSummary(true);
        totalSummaryDim.setSummary(true);
        rowDimValList.add(totalSummaryDim);
        Dimension orgDim = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.ORG);
        ReportCalcValTreeNode root = reportCalcModel.getRowTree().getRoot();
        ReportCalcValTreeNode orgSummaryNode = new ReportCalcValTreeNode();
        orgSummaryNode.setDimensionId(orgDim.getId());
        orgSummaryNode.setCol(0);
        orgSummaryNode.setRow(totalSummaryRow);
        orgSummaryNode.setRowSpan(1);
        orgSummaryNode.setSummary(true);
        orgSummaryNode.setTotalSummary(true);
        root.addChild(orgSummaryNode);
    }
}

