/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodDirection;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.generator.actions.impl.FormulaProcessV3Action;
import kd.tmc.fpm.business.utils.LogFormatUtil;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class PeriodStartEndSummaryFormulaDataProcessAction
extends FormulaProcessV3Action {
    private static final Log logger = LogFactory.getLog(PeriodStartEndSummaryFormulaDataProcessAction.class);
    private FormulaProcessV3Action formulaProcessV3Action;
    private Long periodStartCurrentMemberId;
    private Long periodEndCurrentMemberId;
    private Map<PeriodDirection, Map<Long, Long>> periodStartEndPeriodMemberMap;
    private Boolean forceDisposeFormulaAndSummary = null;

    public PeriodStartEndSummaryFormulaDataProcessAction(FundPlanSystem system, ReportDataSource report) {
        super(system, report);
        this.init();
    }

    public PeriodStartEndSummaryFormulaDataProcessAction(FormulaProcessV3Action formulaProcessV3Action) {
        this(formulaProcessV3Action.system, formulaProcessV3Action.report);
        this.formulaProcessV3Action = formulaProcessV3Action;
    }

    public Boolean getForceDisposeFormulaAndSummary() {
        return this.forceDisposeFormulaAndSummary;
    }

    public void setForceDisposeFormulaAndSummary(Boolean forceDisposeFormulaAndSummary) {
        this.forceDisposeFormulaAndSummary = forceDisposeFormulaAndSummary;
    }

    private void init() {
        if (this.shouldUseOther()) {
            logger.info("\u4f7f\u7528\u539f\u516c\u5f0f\u5904\u7406\u5668\uff1a{}", (Object)this.formulaProcessV3Action.getClass().getName());
            return;
        }
        logger.info("\u521d\u59cb\u5316\u671f\u521d\u671f\u672b\u5904\u7406\u5bf9\u8c61.....");
        List<PeriodMember> reportPeriodMemberList = this.report.getPeriodMemberList();
        PeriodMember periodMember = reportPeriodMemberList.get(0);
        ReportPeriodType reportPeriodType = this.report.getReportPeriodType();
        if (Objects.isNull((Object)reportPeriodType.getDetailPeriodType())) {
            this.periodEndCurrentMemberId = reportPeriodMemberList.get(reportPeriodMemberList.size() - 1).getId();
            this.periodStartCurrentMemberId = periodMember.getId();
            this.periodStartEndPeriodMemberMap = Arrays.stream(PeriodDirection.values()).collect(Collectors.toMap(Function.identity(), p -> reportPeriodMemberList.stream().map(DimMember::getId).collect(Collectors.toMap(Function.identity(), Function.identity()))));
            logger.info("\u5f53\u524d\u62a5\u8868\u4e0d\u542b\u660e\u7ec6\u671f\u95f4\uff1a{}", this.periodStartEndPeriodMemberMap);
            return;
        }
        List periodMemberList = periodMember.getChildren().stream().map(PeriodMember.class::cast).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(periodMemberList)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u7f16\u62a5\u7c7b\u578b\u3010%2$s\u3011\u542b\u660e\u7ec6\u671f\u95f4\uff0c\u4f46\u671f\u95f4\u3010%3$s\u3011\u65e0\u660e\u7ec6\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u6210\u5458\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff01", (String)"PeriodStartEndSummaryFormulaDataProcessAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]), this.system.getName(), reportPeriodType.getName(), periodMember.getName()));
        }
        Report report$ = (Report)this.report;
        this.periodStartCurrentMemberId = ((PeriodMember)periodMemberList.get(0)).getId();
        List<PeriodMember> currentAllPeriodMembers = report$.getCurrentAllPeriodMembers();
        this.periodEndCurrentMemberId = currentAllPeriodMembers.get(currentAllPeriodMembers.size() - 1).getId();
        this.periodStartEndPeriodMemberMap = new HashMap<PeriodDirection, Map<Long, Long>>(4);
        for (PeriodDirection periodDirection : PeriodDirection.values()) {
            Map periodMemberMap = this.periodStartEndPeriodMemberMap.computeIfAbsent(periodDirection, k -> new HashMap(2));
            if (periodDirection.isBeginning()) {
                periodMemberMap.put(periodMember.getId(), this.periodStartCurrentMemberId);
            }
            if (periodDirection.isEnding()) {
                periodMemberMap.put(periodMember.getId(), ((PeriodMember)periodMemberList.get(periodMemberList.size() - 1)).getId());
            }
            for (int i = 1; i < reportPeriodMemberList.size(); ++i) {
                PeriodMember current = reportPeriodMemberList.get(i);
                if (report$.isRollContainsDetail()) {
                    List currentDetails = current.getChildren().stream().map(PeriodMember.class::cast).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
                    periodMemberMap.put(current.getId(), ((PeriodMember)currentDetails.get(periodDirection.isBeginning() ? 0 : currentDetails.size() - 1)).getId());
                    continue;
                }
                periodMemberMap.put(current.getId(), current.getId());
            }
            logger.info("\u542b\u660e\u7ec6\u671f\u95f4\uff1a{}", this.periodStartEndPeriodMemberMap);
        }
    }

    @Override
    public void execute(ReportModel reportModel) {
        if (this.shouldUseOther()) {
            this.formulaProcessV3Action.execute(reportModel);
            return;
        }
        super.execute(reportModel);
    }

    @Override
    protected Set<Long> getPeriodStartEndSubjectIds() {
        ReportTemplate template = this.report.getTemplate();
        if (this.isCommonTemplate()) {
            logger.info("\u8c03\u7528\u7236\u7c7b\u83b7\u53d6\u671f\u521d\u671f\u672b\u79d1\u76ee");
            return super.getPeriodStartEndSubjectIds();
        }
        Optional<TemplateDim> first = template.getAllTemplateDim().stream().filter(templateDim -> templateDim.getDimType() == DimensionType.SUBJECTS).findFirst();
        if (!first.isPresent()) {
            logger.info("\u4e0d\u5b58\u5728\u79d1\u76ee\u7ef4\u5ea6");
            return Collections.emptySet();
        }
        TemplateDim templateDim2 = first.get();
        List<Long> memberScope = templateDim2.getMemberScope();
        return memberScope.stream().filter(this.periodStartEndMap::containsKey).map(this.periodStartEndMap::get).filter(Objects::nonNull).map(DimMember::getId).collect(Collectors.toSet());
    }

    private boolean isCommonTemplate() {
        ReportTemplate template = this.report.getTemplate();
        if (template.getTemplateUse() == TemplateUseType.ANALYSIS) {
            return false;
        }
        if (template.getTemplateUse() == TemplateUseType.STATISTIC) {
            return false;
        }
        if (template.getTemplateType() == TemplateType.DETAIL) {
            return false;
        }
        return template.getTemplateUse() != TemplateUseType.SUMMARY || !EmptyUtil.isEmpty(template.getAccountSettings());
    }

    @Override
    protected boolean onlyNeedResetSummaryCell() {
        if (this.report.getTemplate().getTemplateUse() == TemplateUseType.SUMMARY) {
            return false;
        }
        return super.onlyNeedResetSummaryCell();
    }

    @Override
    protected boolean needDisposeFormulaAndSummary() {
        if (this.getForceDisposeFormulaAndSummary() != null) {
            return this.getForceDisposeFormulaAndSummary();
        }
        if (this.report.getTemplate().getTemplateUse() == TemplateUseType.SUMMARY) {
            return false;
        }
        return super.needDisposeFormulaAndSummary();
    }

    @Override
    protected void processSetProcessPeriodStartEndForReferencePeriodIfNeed(ReportCalcModel reportCalcModel, Consumer<FormulaProcessV3Action.CalcValColQueryIndex> callBack) {
        if (this.report.getTemplate().getTemplateUse() == TemplateUseType.SUMMARY) {
            return;
        }
        super.processSetProcessPeriodStartEndForReferencePeriodIfNeed(reportCalcModel, callBack);
    }

    private boolean shouldUseOther() {
        if (Objects.isNull(this.formulaProcessV3Action)) {
            return false;
        }
        ReportTemplate template = this.report.getTemplate();
        return template.getTemplateType().isDetail();
    }

    @Override
    protected Consumer<ReportCalcVal> getResetConsumer(ReportCalcModel reportCalcModel, FormulaProcessV3Action.CalcValColQueryIndex queryIndex) {
        Map leafColDimMap = reportCalcModel.getColTree().getLeafList().stream().collect(Collectors.toMap(ReportCalcValTreeNode::getCol, Function.identity(), (a, b) -> a));
        Map leafRowDimMap = reportCalcModel.getRowTree().getLeafList().stream().collect(Collectors.toMap(ReportCalcValTreeNode::getRow, Function.identity(), (a, b) -> a));
        Map reportCalcValMap = reportCalcModel.getDataValList().stream().collect(Collectors.toMap(rcv -> String.join((CharSequence)"_", String.valueOf(rcv.getRow()), String.valueOf(rcv.getCol())), Function.identity()));
        return reportCalcVal -> {
            int col = reportCalcVal.getCol();
            int row = reportCalcVal.getRow();
            ReportCalcValTreeNode colLeafDimNode = (ReportCalcValTreeNode)leafColDimMap.get(col);
            ReportCalcValTreeNode rowLeafDimNode = (ReportCalcValTreeNode)leafRowDimMap.get(row);
            if (Objects.isNull(colLeafDimNode) || Objects.isNull(rowLeafDimNode)) {
                logger.info("\u884c\uff1a{}\uff0c\u5217\uff1a{} \u5217\u7ef4\u53f6\u5b50\u8282\u70b9\u6216\u884c\u7ef4\u53f6\u5b50\u8282\u70b9\u4e3a\u7a7a", (Object)row, (Object)col);
                reportCalcVal.setValue(null);
                reportCalcVal.setDisplayVal("--");
                reportCalcVal.getValueType().setReportCellType(ReportCellType.TEXT);
                reportCalcVal.setFormula(null);
                return;
            }
            PeriodStartEndCell periodStartEndCell = this.getPeriodStartEndCell(reportCalcModel, colLeafDimNode, rowLeafDimNode, (ReportCalcVal)reportCalcVal);
            this.processRowSummary(reportCalcValMap, periodStartEndCell);
            this.processColSummary(reportCalcValMap, periodStartEndCell, queryIndex);
        };
    }

    private void processColSummary(Map<String, ReportCalcVal> reportCalcValMap, PeriodStartEndCell periodStartEndCell, FormulaProcessV3Action.CalcValColQueryIndex queryIndex) {
        if (periodStartEndCell.isRowSummary()) {
            return;
        }
        if (!periodStartEndCell.isColSummary()) {
            return;
        }
        ReportCalcVal reportCalcVal = periodStartEndCell.getCurrentLittleSumCell();
        ReportCalcModel reportCalcModel = periodStartEndCell.getReportCalcModel();
        if (periodStartEndCell.isMultiSummary() && periodStartEndCell.getCurrentColLittleSummaryNode().getColSpan() == 1) {
            List<ReportCalcVal> reportCalcValList = IntStream.range(periodStartEndCell.getColDirectUpperNode().getCol(), periodStartEndCell.getColDirectUpperNode().getColEnd()).mapToObj(i -> String.join((CharSequence)"_", String.valueOf(periodStartEndCell.getRow()), String.valueOf(i))).map(reportCalcValMap::get).filter(Objects::nonNull).collect(Collectors.toList());
            Map<String, Object> currencyInfoMap = this.getCurrencyInfoMap(reportCalcModel, reportCalcValList);
            reportCalcVal.setFormula(this.getSumFormula(reportCalcVal, reportCalcValList, currencyInfoMap));
            return;
        }
        DimensionInfoBean dimensionInfoBean = periodStartEndCell.getDimensionInfoBean();
        List<ReportCalcVal> list = queryIndex.findList(dimensionInfoBean);
        Map<String, Object> currencyInfoMap = this.getCurrencyInfoMap(reportCalcModel, list);
        reportCalcVal.setFormula(this.getSumFormula(reportCalcVal, list, currencyInfoMap));
    }

    private void processRowSummary(Map<String, ReportCalcVal> reportCalcValMap, PeriodStartEndCell periodStartEndCell) {
        if (!periodStartEndCell.isRowSummary()) {
            return;
        }
        if (periodStartEndCell.isRowMultiSummary()) {
            // empty if block
        }
        List<ReportCalcVal> reportCalcValList = IntStream.range(periodStartEndCell.getRowDirectUpperNode().getRow(), periodStartEndCell.getRowDirectUpperNode().getRowEnd()).mapToObj(i -> String.join((CharSequence)"_", String.valueOf(i), String.valueOf(periodStartEndCell.getCol()))).map(reportCalcValMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, Object> currencyInfoMap = this.getCurrencyInfoMap(periodStartEndCell.getReportCalcModel(), reportCalcValList);
        ReportCalcVal reportCalcVal = periodStartEndCell.getCurrentLittleSumCell();
        reportCalcVal.setFormula(this.getSumFormula(reportCalcVal, reportCalcValList, currencyInfoMap));
    }

    private PeriodStartEndCell getPeriodStartEndCell(ReportCalcModel reportCalcModel, ReportCalcValTreeNode colLeafDimNode, ReportCalcValTreeNode rowLeafDimNode, ReportCalcVal currentLittleSumCell) {
        PeriodStartEndCell periodStartEndCell = new PeriodStartEndCell(reportCalcModel, currentLittleSumCell);
        this.fillPeriodStartEndCellColInfo(periodStartEndCell, colLeafDimNode);
        this.fillPeriodStartEndCellRowInfo(periodStartEndCell, rowLeafDimNode);
        if (periodStartEndCell.isRowSummary()) {
            logger.info("\u884c\u5c0f\u8ba1\uff0c\u76f4\u63a5\u8fd4\u56de");
            return periodStartEndCell;
        }
        if (!periodStartEndCell.isColSummary()) {
            logger.info("\u4e0d\u662f\u5217\u5c0f\u8ba1\uff0c\u76f4\u63a5\u8fd4\u56de");
            return periodStartEndCell;
        }
        if (periodStartEndCell.isTotalSummary()) {
            logger.info("\u5408\u8ba1\u4e0b\u7684\u5355\u5143\u683c\uff0c\u586b\u5145\u672a\u7ef4\u5ea6\u7ec4\u5408\u6dfb\u52a0\u671f\u521d\u671f\u672b\u79d1\u76ee");
            this.addPeriodStartEndDimensionForCurrentReportPeriodIfNeed(periodStartEndCell);
            return periodStartEndCell;
        }
        if (periodStartEndCell.isMultiSummary() && periodStartEndCell.isOriginalDimensionInfoContainsPeriod()) {
            this.addPeriodStartEndDimensionForCurrentReportPeriodIfNeed(periodStartEndCell);
            return periodStartEndCell;
        }
        ReportCalcValTreeNode periodNode = periodStartEndCell.getCurrentColLittleSummaryNode();
        Dimension dimension = this.getDimensionFromNode(periodNode);
        if (dimension == null || !dimension.getDimType().isPeriodDim()) {
            this.addPeriodStartEndDimensionForCurrentReportPeriodIfNeed(periodStartEndCell);
            return periodStartEndCell;
        }
        ReportCalcValTreeNode colDirectUpperNode = periodStartEndCell.getColDirectUpperNode();
        Dimension upperNodeDim = this.getDimensionFromNode(colDirectUpperNode);
        if (Objects.nonNull(upperNodeDim) && Objects.equals(upperNodeDim.getId(), dimension.getId())) {
            this.addPeriodStartEndDimensionIfNeed(periodStartEndCell, colDirectUpperNode);
            return periodStartEndCell;
        }
        this.addPeriodStartEndDimensionForCurrentReportPeriodIfNeed(periodStartEndCell);
        return periodStartEndCell;
    }

    private void addPeriodStartEndDimensionForCurrentReportPeriodIfNeed(PeriodStartEndCell periodStartEndCell) {
        AccountMember accountMember = (AccountMember)this.periodStartEndMap.get(periodStartEndCell.getSubjectMemberId());
        if (Objects.isNull(accountMember)) {
            return;
        }
        ReportCalcValTreeNode skipPeriodNode = periodStartEndCell.getSkipPeriodNode();
        if (Objects.nonNull(skipPeriodNode)) {
            periodStartEndCell.getDimensionInfoBean().addDimensionInfo(this.periodDimensionId, (Object)this.periodStartEndPeriodMemberMap.getOrDefault(accountMember.getPeriodDirection(), Collections.emptyMap()).getOrDefault(skipPeriodNode.getValue(), 0L));
            return;
        }
        if (accountMember.getPeriodDirection().isBeginning()) {
            periodStartEndCell.getDimensionInfoBean().addDimensionInfo(this.periodDimensionId, (Object)this.periodStartCurrentMemberId);
        }
        if (!accountMember.getPeriodDirection().isEnding()) {
            return;
        }
        ReportCalcValTreeNode periodNode = null;
        boolean summaryDownPeriod = false;
        for (ReportCalcValTreeNode currentColLittleSummaryNode = periodStartEndCell.getCurrentColLittleSummaryNode(); currentColLittleSummaryNode != null; currentColLittleSummaryNode = currentColLittleSummaryNode.getParent()) {
            if (!Objects.equals(this.periodDimensionId, currentColLittleSummaryNode.getCalcVal().getDimensionId())) continue;
            periodNode = currentColLittleSummaryNode;
            summaryDownPeriod = true;
            break;
        }
        if (summaryDownPeriod) {
            List<Object> brothers = new ArrayList(1);
            if (this.report.getReportPeriodType().getDetailPeriodType() != null) {
                List parentPeriods = periodNode.getParent().getChildren().stream().filter(node -> !node.isSummary()).collect(Collectors.toList());
                ReportCalcValTreeNode parentPeriod = (ReportCalcValTreeNode)parentPeriods.get(parentPeriods.size() - 1);
                List<ReportCalcValTreeNode> children = parentPeriod.getChildren();
                if (!CollectionUtils.isEmpty(children)) {
                    brothers = children.stream().filter(node -> !node.isSummary()).collect(Collectors.toList());
                }
            } else {
                brothers = periodNode.getParent().getChildren().stream().filter(node -> !node.isSummary()).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(brothers)) {
                Long maxBrother = (Long)((ReportCalcValTreeNode)brothers.get(brothers.size() - 1)).getCalcVal().getValue();
                periodStartEndCell.getDimensionInfoBean().addDimensionInfo(this.periodDimensionId, (Object)maxBrother);
            }
        }
        periodStartEndCell.getDimensionInfoBean().addDimensionInfo(this.periodDimensionId, (Object)this.periodEndCurrentMemberId);
    }

    private void addPeriodStartEndDimensionIfNeed(PeriodStartEndCell periodStartEndCell, ReportCalcValTreeNode colDirectUpperNode) {
        AccountMember accountMember = (AccountMember)this.periodStartEndMap.get(periodStartEndCell.getSubjectMemberId());
        if (Objects.isNull(accountMember)) {
            return;
        }
        if (accountMember.getPeriodDirection().isBeginning()) {
            ReportCalcValTreeNode treeNode = colDirectUpperNode.getChildren().get(0);
            periodStartEndCell.getDimensionInfoBean().addDimensionInfo(this.periodDimensionId, treeNode.getValue());
        }
        if (accountMember.getPeriodDirection().isEnding()) {
            List<ReportCalcValTreeNode> children = colDirectUpperNode.getChildren();
            ReportCalcValTreeNode lastNode = null;
            for (int index = children.size() - 1; index >= 0 && (lastNode = children.get(index)).isSummary(); --index) {
            }
            if (lastNode == null) {
                return;
            }
            periodStartEndCell.getDimensionInfoBean().addDimensionInfo(this.periodDimensionId, lastNode.getCalcVal().getValue());
        }
    }

    private void fillPeriodStartEndCellRowInfo(PeriodStartEndCell periodStartEndCell, ReportCalcValTreeNode leafDimNode) {
        DimensionInfoBean dimensionInfoBean = periodStartEndCell.getDimensionInfoBean();
        int summaryCount = 0;
        for (ReportCalcValTreeNode currentLeafDimNode = leafDimNode; currentLeafDimNode != null && currentLeafDimNode.getParent() != null; currentLeafDimNode = currentLeafDimNode.getParent()) {
            Long dimensionId = currentLeafDimNode.getCalcVal().getDimensionId();
            Dimension subjectDim = this.system.getMainDimensionByDimensionId(dimensionId);
            if (Objects.nonNull(subjectDim) && subjectDim.getDimType().isSubjectDim()) {
                periodStartEndCell.setSubjectMemberId(currentLeafDimNode.getCalcVal().getValue());
            }
            if (!currentLeafDimNode.isSkipVal() && !currentLeafDimNode.isSummary()) {
                dimensionInfoBean.addDimensionInfo(dimensionId, currentLeafDimNode.getValue());
            }
            if (!currentLeafDimNode.isSummary()) continue;
            ++summaryCount;
            periodStartEndCell.setRowSummary(true);
            if (!Objects.isNull(periodStartEndCell.getCurrentRowLittleSummaryNode())) continue;
            this.fillDimensionInfo(periodStartEndCell, currentLeafDimNode, false);
        }
        periodStartEndCell.setRowMultiSummary(summaryCount > 1);
    }

    private void fillPeriodStartEndCellColInfo(PeriodStartEndCell periodStartEndCell, ReportCalcValTreeNode leafDimNode) {
        DimensionInfoBean dimensionInfoBean = periodStartEndCell.getDimensionInfoBean();
        HashSet<ReportCalcValTreeNode> skipNode = new HashSet<ReportCalcValTreeNode>(4);
        int summaryCount = 0;
        for (ReportCalcValTreeNode currentLeafDimNode = leafDimNode; currentLeafDimNode != null && currentLeafDimNode.getParent() != null; currentLeafDimNode = currentLeafDimNode.getParent()) {
            Long dimensionId = currentLeafDimNode.getCalcVal().getDimensionId();
            if (!currentLeafDimNode.isSkipVal() && !currentLeafDimNode.isSummary()) {
                dimensionInfoBean.addDimensionInfo(dimensionId, currentLeafDimNode.getValue());
                if (Objects.equals(dimensionId, this.periodDimensionId)) {
                    periodStartEndCell.setOriginalDimensionInfoContainsPeriod(true);
                }
            }
            if (currentLeafDimNode.isSkipVal()) {
                skipNode.add(currentLeafDimNode);
            }
            if (currentLeafDimNode.isSummary() && currentLeafDimNode.getDimLevel() > 1) {
                ++summaryCount;
                periodStartEndCell.setColSummary(true);
                if (Objects.isNull(periodStartEndCell.getCurrentColLittleSummaryNode())) {
                    this.fillDimensionInfo(periodStartEndCell, currentLeafDimNode, true);
                }
            }
            if (!currentLeafDimNode.isTotalSummary() || currentLeafDimNode.getDimLevel() != 1) continue;
            periodStartEndCell.setTotalSummary(true);
            periodStartEndCell.setColSummary(true);
            ++summaryCount;
            periodStartEndCell.setTotalSummaryNode(currentLeafDimNode);
        }
        Optional<ReportCalcValTreeNode> periodSkipNode = skipNode.stream().filter(node -> Objects.equals(node.getCalcVal().getDimensionId(), this.periodDimensionId)).findFirst();
        if (periodSkipNode.isPresent() && !dimensionInfoBean.getDimensionIdList().contains(this.periodDimensionId)) {
            periodStartEndCell.setSkipPeriodNode(periodSkipNode.get());
        }
        periodStartEndCell.setMultiSummary(summaryCount > 1);
    }

    private void fillDimensionInfo(PeriodStartEndCell periodStartEndCell, ReportCalcValTreeNode currentLeafDimNode, boolean isCol) {
        if (isCol) {
            periodStartEndCell.setCurrentColLittleSummaryNode(currentLeafDimNode);
        } else {
            periodStartEndCell.setCurrentRowLittleSummaryNode(currentLeafDimNode);
        }
        ReportCalcValTreeNode parent = currentLeafDimNode.getParent();
        if (Objects.nonNull(parent) && Objects.nonNull(parent.getParent())) {
            if (isCol) {
                periodStartEndCell.setColDirectUpperNode(parent);
            } else {
                periodStartEndCell.setRowDirectUpperNode(parent);
            }
        }
    }

    private Dimension getDimensionFromNode(ReportCalcValTreeNode node) {
        if (node == null) {
            return null;
        }
        Long dimensionId = node.getCalcVal().getDimensionId();
        return this.system.getMainDimensionByDimensionId(dimensionId);
    }

    class PeriodStartEndCell {
        private DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
        private ReportCalcValTreeNode rowDirectUpperNode;
        private ReportCalcValTreeNode colDirectUpperNode;
        private boolean totalSummary;
        private boolean colSummary;
        private boolean rowSummary;
        private boolean multiSummary;
        private boolean rowMultiSummary;
        private int row;
        private int col;
        private ReportCalcValTreeNode currentColLittleSummaryNode;
        private ReportCalcValTreeNode currentRowLittleSummaryNode;
        private ReportCalcValTreeNode totalSummaryNode;
        private boolean originalDimensionInfoContainsPeriod;
        private ReportCalcValTreeNode skipPeriodNode;
        private Object subjectMemberId;
        private ReportCalcVal currentLittleSumCell;
        private ReportCalcModel reportCalcModel;

        public PeriodStartEndCell(ReportCalcModel reportCalcModel, ReportCalcVal currentLittleSumCell) {
            this.currentLittleSumCell = currentLittleSumCell;
            this.row = currentLittleSumCell.getRow();
            this.col = currentLittleSumCell.getCol();
            this.reportCalcModel = reportCalcModel;
            List<ReportCalcVal> pageDimValList = reportCalcModel.getPageDimValList();
            Optional.of(pageDimValList).orElseGet(Collections::emptyList).forEach(rcv -> this.getDimensionInfoBean().addDimensionInfo(rcv.getDimensionId(), rcv.getValue()));
        }

        public DimensionInfoBean getDimensionInfoBean() {
            return this.dimensionInfoBean;
        }

        public void setDimensionInfoBean(DimensionInfoBean dimensionInfoBean) {
            this.dimensionInfoBean = dimensionInfoBean;
        }

        public ReportCalcValTreeNode getRowDirectUpperNode() {
            return this.rowDirectUpperNode;
        }

        public void setRowDirectUpperNode(ReportCalcValTreeNode rowDirectUpperNode) {
            this.rowDirectUpperNode = rowDirectUpperNode;
        }

        public ReportCalcValTreeNode getColDirectUpperNode() {
            return this.colDirectUpperNode;
        }

        public void setColDirectUpperNode(ReportCalcValTreeNode colDirectUpperNode) {
            this.colDirectUpperNode = colDirectUpperNode;
        }

        public boolean isTotalSummary() {
            return this.totalSummary;
        }

        public void setTotalSummary(boolean totalSummary) {
            this.totalSummary = totalSummary;
        }

        public boolean isColSummary() {
            return this.colSummary;
        }

        public void setColSummary(boolean colSummary) {
            this.colSummary = colSummary;
        }

        public boolean isRowSummary() {
            return this.rowSummary;
        }

        public void setRowSummary(boolean rowSummary) {
            this.rowSummary = rowSummary;
        }

        public boolean isMultiSummary() {
            return this.multiSummary;
        }

        public void setMultiSummary(boolean multiSummary) {
            this.multiSummary = multiSummary;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public int getCol() {
            return this.col;
        }

        public void setCol(int col) {
            this.col = col;
        }

        public ReportCalcValTreeNode getCurrentColLittleSummaryNode() {
            return this.currentColLittleSummaryNode;
        }

        public void setCurrentColLittleSummaryNode(ReportCalcValTreeNode currentColLittleSummaryNode) {
            this.currentColLittleSummaryNode = currentColLittleSummaryNode;
        }

        public ReportCalcValTreeNode getCurrentRowLittleSummaryNode() {
            return this.currentRowLittleSummaryNode;
        }

        public void setCurrentRowLittleSummaryNode(ReportCalcValTreeNode currentRowLittleSummaryNode) {
            this.currentRowLittleSummaryNode = currentRowLittleSummaryNode;
        }

        public ReportCalcValTreeNode getTotalSummaryNode() {
            return this.totalSummaryNode;
        }

        public void setTotalSummaryNode(ReportCalcValTreeNode totalSummaryNode) {
            this.totalSummaryNode = totalSummaryNode;
            this.totalSummary = true;
        }

        public Object getSubjectMemberId() {
            return this.subjectMemberId;
        }

        public void setSubjectMemberId(Object subjectMemberId) {
            this.subjectMemberId = subjectMemberId;
        }

        public boolean isRowMultiSummary() {
            return this.rowMultiSummary;
        }

        public void setRowMultiSummary(boolean rowMultiSummary) {
            this.rowMultiSummary = rowMultiSummary;
        }

        public ReportCalcVal getCurrentLittleSumCell() {
            return this.currentLittleSumCell;
        }

        public void setCurrentLittleSumCell(ReportCalcVal currentLittleSumCell) {
            this.currentLittleSumCell = currentLittleSumCell;
        }

        public ReportCalcModel getReportCalcModel() {
            return this.reportCalcModel;
        }

        public void setReportCalcModel(ReportCalcModel reportCalcModel) {
            this.reportCalcModel = reportCalcModel;
        }

        public boolean isOriginalDimensionInfoContainsPeriod() {
            return this.originalDimensionInfoContainsPeriod;
        }

        public void setOriginalDimensionInfoContainsPeriod(boolean originalDimensionInfoContainsPeriod) {
            this.originalDimensionInfoContainsPeriod = originalDimensionInfoContainsPeriod;
        }

        public ReportCalcValTreeNode getSkipPeriodNode() {
            return this.skipPeriodNode;
        }

        public void setSkipPeriodNode(ReportCalcValTreeNode skipPeriodNode) {
            this.skipPeriodNode = skipPeriodNode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            return sb.append("PeriodStartEndCell: ").append("row\uff1a").append(this.row).append("col:").append(this.col).append("\n").append("dimensionInfo: ").append(LogFormatUtil.formatDimensionBeanInfo(this.dimensionInfoBean, PeriodStartEndSummaryFormulaDataProcessAction.this.system)).append("\n").toString();
        }
    }
}

