/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.generator.actions.impl.FormulaProcessV3Action;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class PeriodStartEndSummaryFormulaProcessAction
extends FormulaProcessV3Action {
    private static final Log logger = LogFactory.getLog(PeriodStartEndSummaryFormulaProcessAction.class);

    public PeriodStartEndSummaryFormulaProcessAction(FundPlanSystem system, ReportDataSource report) {
        super(system, report);
    }

    @Override
    protected Set<Long> getPeriodStartEndSubjectIds() {
        ReportTemplate template = this.report.getTemplate();
        if (this.isCommonTemplate()) {
            return super.getPeriodStartEndSubjectIds();
        }
        Optional<TemplateDim> first = template.getAllTemplateDim().stream().filter(templateDim -> templateDim.getDimType() == DimensionType.SUBJECTS).findFirst();
        if (!first.isPresent()) {
            logger.info("\u4e0d\u5b58\u5728\u79d1\u76ee\u7ef4\u5ea6");
            return Collections.emptySet();
        }
        TemplateDim templateDim2 = first.get();
        List<Long> memberScope = templateDim2.getMemberScope();
        return memberScope.stream().filter(this.periodStartEndMap::containsKey).map(this.periodStartEndMap::get).filter(Objects::nonNull).map(DimMember::getId).collect(Collectors.toSet());
    }

    private boolean isCommonTemplate() {
        ReportTemplate template = this.report.getTemplate();
        if (template.getTemplateUse() == TemplateUseType.ANALYSIS) {
            return false;
        }
        if (template.getTemplateUse() == TemplateUseType.STATISTIC) {
            return false;
        }
        return template.getTemplateType() != TemplateType.DETAIL;
    }

    @Override
    protected Consumer<ReportCalcVal> getResetConsumer(ReportCalcModel reportCalcModel, FormulaProcessV3Action.CalcValColQueryIndex queryIndex) {
        if (Objects.isNull((Object)this.report.getReportPeriodType().getDetailPeriodType())) {
            return super.getResetConsumer(reportCalcModel, queryIndex);
        }
        if (Report.class.isInstance(this.report)) {
            return super.getResetConsumer(reportCalcModel, queryIndex);
        }
        Report report$ = (Report)this.report;
        HashSet<Long> periodMembers = new HashSet<Long>(16);
        List periodMemberList = report$.getPeriodMemberList().stream().sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        periodMembers.add(((PeriodMember)periodMemberList.get(0)).getId());
        if (report$.isRollContainsDetail()) {
            periodMembers.addAll(periodMemberList.subList(1, periodMemberList.size()).stream().map(DimMember::getId).collect(Collectors.toSet()));
        }
        List upperPeriodDimList = reportCalcModel.getColDimValList().stream().filter(reportCalcVal -> Objects.equals(this.periodDimensionId, reportCalcVal.getDimensionId())).filter(rcv -> periodMembers.contains(rcv.getValue())).collect(Collectors.toList());
        HashMap<Integer, ReportCalcVal> upperPeriodColIndexMap = new HashMap<Integer, ReportCalcVal>(128);
        for (ReportCalcVal reportCalcVal2 : upperPeriodDimList) {
            for (int i = reportCalcVal2.getCol(); i < reportCalcVal2.getCol() + reportCalcVal2.getColSpan(); ++i) {
                upperPeriodColIndexMap.put(i, reportCalcVal2);
            }
        }
        ReportDataIndexQueryMap<String> indexQueryMap = queryIndex.getIndexQueryMap();
        Map<String, ReportCalcVal> dataMap = queryIndex.getDataMap();
        Consumer<ReportCalcVal> resetFunction = reportCalcVal -> {
            int col = reportCalcVal.getCol();
            Integer integer = col;
            if (!upperPeriodColIndexMap.containsKey(integer)) {
                this.setTextEmptyValue((ReportCalcVal)reportCalcVal);
                return;
            }
            ReportCalcVal upperPeriodDim = (ReportCalcVal)upperPeriodColIndexMap.get(integer);
            if (Objects.isNull(upperPeriodDim) || EmptyUtil.isEmpty((Object)upperPeriodDim.getValue())) {
                this.setTextEmptyValue((ReportCalcVal)reportCalcVal);
                return;
            }
            DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfo(col, reportCalcVal.getRow());
            List dimensionIdList = dimensionInfo.getDimensionIdList();
            int index = dimensionIdList.indexOf(this.periodDimensionId);
            Object periodMemberId = upperPeriodDim.getValue();
            Long detailFirstPeriodMemberId = periodMemberList.stream().filter(periodMember -> Objects.equals(periodMember.getId(), periodMemberId)).map(DimMember::getAllChildMember).filter(Objects::nonNull).flatMap(Collection::stream).map(PeriodMember.class::cast).sorted(Comparator.comparing(PeriodMember::getStartDate)).map(DimMember::getId).findFirst().get();
            if (index == -1) {
                dimensionIdList.add(this.periodDimensionId);
                dimensionInfo.getMemberIdList().add(detailFirstPeriodMemberId);
            } else {
                dimensionInfo.getMemberIdList().set(index, detailFirstPeriodMemberId);
            }
            List list = indexQueryMap.findList(dimensionInfo);
            if (EmptyUtil.isEmpty(list)) {
                this.setTextEmptyValue((ReportCalcVal)reportCalcVal);
                return;
            }
            List<ReportCalcVal> dataList = list.stream().map(dataMap::get).filter(Objects::nonNull).collect(Collectors.toList());
            reportCalcVal.getValueType().setReportCellType(ReportCellType.AMOUNT);
            Map<String, Object> currencyInfoMap = this.getCurrencyInfoMap(reportCalcModel, dataList);
            reportCalcVal.setFormula(this.getSumFormula((ReportCalcVal)reportCalcVal, dataList, currencyInfoMap));
        };
        return resetFunction;
    }

    private void setTextEmptyValue(ReportCalcVal reportCalcVal) {
        reportCalcVal.setValue(null);
        reportCalcVal.setDisplayVal("--");
        reportCalcVal.getValueType().setReportCellType(ReportCellType.TEXT);
        reportCalcVal.setFormula(null);
    }
}

