/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.mvc.enums.PlanChangeReferIndex;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperatorSymbol;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.enums.FormulaSymbolEnum;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import org.apache.poi.ss.util.CellReference;

public class PlanChangeFormulaAction
implements IReportDataProcessAction {
    private static final Log logger = LogFactory.getLog(PlanChangeFormulaAction.class);
    protected ReportDataSource report;
    protected FundPlanSystem system;

    public PlanChangeFormulaAction(FundPlanSystem system, ReportDataSource report) {
        this.system = system;
        this.report = report;
    }

    @Override
    public void execute(ReportModel reportModel) {
        BillStatus recordBillStatus = ((PlanChangeReport)this.report).getRecordBillStatus();
        List<Dimension> dimList = this.system.getDimList();
        Dimension adJustDim = dimList.stream().filter(item -> item.getDimType() == DimensionType.ADJUSTDATATYPE).findFirst().get();
        List<DimMember> allDimMemberList = adJustDim.getAllDimMemberList();
        DimMember currPlanAmtMember = allDimMemberList.stream().filter(item -> item.getNumber().equals(PlanChangeReferIndex.CURRENTPLANAMT.getValue())).findFirst().get();
        DimMember justMember = allDimMemberList.stream().filter(item -> item.getNumber().equals(PlanChangeReferIndex.ADJUSTAMT.getValue())).findFirst().get();
        DimMember afterJustMember = allDimMemberList.stream().filter(item -> item.getNumber().equals(PlanChangeReferIndex.AFTERADJUSTAMT.getValue())).findFirst().get();
        Optional<DimMember> afterJustAbleOptional = allDimMemberList.stream().filter(item -> item.getNumber().equals(PlanChangeReferIndex.ADJUSTEDAVAILABLEAMT.getValue())).findFirst();
        DimMember afterJustAbleMemberT = null;
        DimMember lockAmtMemberT = null;
        DimMember realAmtMemberT = null;
        if (afterJustAbleOptional.isPresent()) {
            Optional<DimMember> lockAmtOptional = allDimMemberList.stream().filter(item -> item.getNumber().equals(PlanChangeReferIndex.LOCKAMT.getValue())).findFirst();
            Optional<DimMember> realAmtOptional = allDimMemberList.stream().filter(item -> item.getNumber().equals(PlanChangeReferIndex.REALAMT.getValue())).findFirst();
            if (!lockAmtOptional.isPresent() || !realAmtOptional.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u8003\u6307\u6807\u5305\u542b\u8c03\u6574\u540e\u53ef\u7528\u4f59\u989d\u65f6\u5fc5\u987b\u5305\u542b\u9884\u5360\u7528\u989d\u5ea6\u548c\u5df2\u6267\u884c\u989d\u5ea6", (String)"PlanChangeFormulaAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            afterJustAbleMemberT = afterJustAbleOptional.get();
            realAmtMemberT = realAmtOptional.get();
            lockAmtMemberT = lockAmtOptional.get();
        }
        DimMember afterJustAbleMember = afterJustAbleMemberT;
        DimMember lockAmtMember = lockAmtMemberT;
        DimMember realAmtMember = realAmtMemberT;
        List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
        for (ReportCalcModel reportCalcModel : reportCalcModelList) {
            List<ReportCalcVal> colDimValList = reportCalcModel.getColDimValList();
            List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
            Map<Integer, List<ReportCalcVal>> rowDataListMap = dataValList.stream().collect(Collectors.groupingBy(ReportCalcVal::getRow));
            int currColIndex = -1;
            int currCol = -1;
            List afterJustColList = colDimValList.stream().filter(item -> afterJustMember.getId().equals(item.getValue())).collect(Collectors.toList());
            List afterJustColIndexList = afterJustColList.stream().map(ReportCalcVal::getCol).collect(Collectors.toList());
            if (recordBillStatus == BillStatus.STAGE || recordBillStatus == BillStatus.COMMITTED) {
                List currPlanAmtColIndexList = colDimValList.stream().filter(item -> currPlanAmtMember.getId().equals(item.getValue())).map(ReportCalcVal::getCol).sorted().collect(Collectors.toList());
                List justColIndexList = colDimValList.stream().filter(item -> justMember.getId().equals(item.getValue())).map(ReportCalcVal::getCol).sorted().collect(Collectors.toList());
                List afterJustDataValList = dataValList.stream().filter(item -> afterJustColIndexList.contains(item.getCol())).sorted(Comparator.comparing(ReportCalcVal::getCol)).collect(Collectors.toList());
                for (int i = 0; i < afterJustDataValList.size(); ++i) {
                    ReportCalcVal reportCalcVal = (ReportCalcVal)afterJustDataValList.get(i);
                    int finalCurrColIndex = currColIndex = reportCalcVal.getCol() == currCol ? currColIndex : currColIndex + 1;
                    List<ReportCalcVal> rowDataList = rowDataListMap.get(reportCalcVal.getRow());
                    List<ReportCalcVal> rightList = rowDataList.stream().filter(item -> item.getCol() == ((Integer)currPlanAmtColIndexList.get(finalCurrColIndex)).intValue() || item.getCol() == ((Integer)justColIndexList.get(finalCurrColIndex)).intValue()).collect(Collectors.toList());
                    Formula formula = this.getFormula(reportCalcVal, rightList, FormulaSymbolEnum.PLUS);
                    reportCalcVal.setEnable(false);
                    reportCalcVal.setFormula(formula);
                    currCol = reportCalcVal.getCol();
                }
            }
            if (afterJustAbleMember == null) continue;
            List afterJustAbleColList = colDimValList.stream().filter(item -> afterJustAbleMember.getId().equals(item.getValue())).collect(Collectors.toList());
            List afterJustAbleColIndexList = afterJustAbleColList.stream().map(ReportCalcVal::getCol).collect(Collectors.toList());
            List lockAmtColIndexList = colDimValList.stream().filter(item -> lockAmtMember.getId().equals(item.getValue())).map(ReportCalcVal::getCol).sorted().collect(Collectors.toList());
            List realAmtColIndexList = colDimValList.stream().filter(item -> realAmtMember.getId().equals(item.getValue())).map(ReportCalcVal::getCol).sorted().collect(Collectors.toList());
            List afterJustAbleDataValList = dataValList.stream().filter(item -> afterJustAbleColIndexList.contains(item.getCol())).sorted(Comparator.comparing(ReportCalcVal::getCol)).collect(Collectors.toList());
            rowDataListMap = dataValList.stream().collect(Collectors.groupingBy(ReportCalcVal::getRow));
            currColIndex = -1;
            currCol = -1;
            for (int i = 0; i < afterJustAbleDataValList.size(); ++i) {
                ReportCalcVal reportCalcVal = (ReportCalcVal)afterJustAbleDataValList.get(i);
                int finalCurrColIndex = currColIndex = reportCalcVal.getCol() == currCol ? currColIndex : currColIndex + 1;
                List<ReportCalcVal> rowDataList = rowDataListMap.get(reportCalcVal.getRow());
                List<ReportCalcVal> rightList = rowDataList.stream().filter(item -> item.getCol() == ((Integer)afterJustColIndexList.get(finalCurrColIndex)).intValue()).collect(Collectors.toList());
                rightList.addAll(rowDataList.stream().filter(item -> item.getCol() == ((Integer)lockAmtColIndexList.get(finalCurrColIndex)).intValue() || item.getCol() == ((Integer)realAmtColIndexList.get(finalCurrColIndex)).intValue()).collect(Collectors.toList()));
                Formula formula = this.getFormula(reportCalcVal, rightList, FormulaSymbolEnum.MINUS);
                reportCalcVal.setEnable(false);
                reportCalcVal.setFormula(formula);
                currCol = reportCalcVal.getCol();
            }
        }
    }

    private Formula getFormula(ReportCalcVal leftCalcVal, List<ReportCalcVal> dataValList, FormulaSymbolEnum symbolEnum) {
        Formula formula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(new CellReference(leftCalcVal.getRow(), leftCalcVal.getCol()).formatAsString());
        formula.setLeftVal(leftOperationVal);
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        for (ReportCalcVal reportCalcVal : dataValList) {
            String excelPost = new CellReference(reportCalcVal.getRow(), reportCalcVal.getCol()).formatAsString();
            FormulaOperationVal rightVal = new FormulaOperationVal();
            rightVal.setName(excelPost);
            if (reportCalcVal.getValue() != null) {
                rightVal.setValue(reportCalcVal.getValue().toString());
            }
            operator.add(rightVal);
            FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(symbolEnum);
            operator.add(addSymbol);
        }
        operator.removeLast();
        formula.setOperator(operator);
        return formula;
    }
}

