/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.enums.PlanChangeReferIndex;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;

public class PlanChangeSpecialAction
implements IReportDataProcessAction {
    private FundPlanSystem system;
    private ReportDataSource report;

    public PlanChangeSpecialAction(FundPlanSystem system, ReportDataSource report) {
        this.system = system;
        this.report = report;
    }

    @Override
    public void execute(ReportModel reportModel) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("PlanChangeSpecialAction_Execute");){
            span.addTag("PlanChangeSpecialAction_step1");
            ReportTemplate template = this.report.getTemplate();
            span.addTag("PlanChangeSpecialAction_step2");
            List<Dimension> dimList = this.system.getDimList();
            span.addTag("PlanChangeSpecialAction_step3");
            Dimension adJustDim = dimList.stream().filter(item -> item.getDimType() == DimensionType.ADJUSTDATATYPE).findFirst().get();
            List<DimMember> allDimMemberList = adJustDim.getAllDimMemberList();
            span.addTag("PlanChangeSpecialAction_step4");
            DimMember currPlanAmtMember = allDimMemberList.stream().filter(item -> item.getNumber().equals(PlanChangeReferIndex.CURRENTPLANAMT.getValue())).findFirst().get();
            span.addTag("PlanChangeSpecialAction_step5");
            DimMember justMember = allDimMemberList.stream().filter(item -> item.getNumber().equals(PlanChangeReferIndex.ADJUSTAMT.getValue())).findFirst().get();
            span.addTag("PlanChangeSpecialAction_step6");
            Optional<DimMember> applyPlanAmtOp = allDimMemberList.stream().filter(item -> item.getNumber().equals(PlanChangeReferIndex.PLANAMT.getValue())).findFirst();
            span.addTag("PlanChangeSpecialAction_step6");
            Optional<DimMember> lockAmtOp = allDimMemberList.stream().filter(item -> item.getNumber().equals(PlanChangeReferIndex.LOCKAMT.getValue())).findFirst();
            span.addTag("PlanChangeSpecialAction_step7");
            Optional<DimMember> realAmtOp = allDimMemberList.stream().filter(item -> item.getNumber().equals(PlanChangeReferIndex.REALAMT.getValue())).findFirst();
            span.addTag("PlanChangeSpecialAction_step8");
            Optional<DimMember> availableAmtOp = allDimMemberList.stream().filter(item -> item.getNumber().equals(PlanChangeReferIndex.AVAILABLEAMT.getValue())).findFirst();
            span.addTag("PlanChangeSpecialAction_step9");
            Optional<DimMember> afterAvailableAmtOp = allDimMemberList.stream().filter(item -> item.getNumber().equals(PlanChangeReferIndex.ADJUSTEDAVAILABLEAMT.getValue())).findFirst();
            List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
            span.addTag("PlanChangeSpecialAction_step10");
            for (ReportCalcModel reportCalcModel : reportCalcModelList) {
                List<ReportCalcVal> colDimValList = reportCalcModel.getColDimValList();
                Set disableColSet = colDimValList.stream().filter(item -> {
                    if (item.getValue() == null) {
                        return false;
                    }
                    if (item.getValue().equals(currPlanAmtMember.getId())) {
                        return true;
                    }
                    if (applyPlanAmtOp.isPresent() && item.getValue().equals(((DimMember)applyPlanAmtOp.get()).getId())) {
                        return true;
                    }
                    if (lockAmtOp.isPresent() && item.getValue().equals(((DimMember)lockAmtOp.get()).getId())) {
                        return true;
                    }
                    if (realAmtOp.isPresent() && item.getValue().equals(((DimMember)realAmtOp.get()).getId())) {
                        return true;
                    }
                    if (availableAmtOp.isPresent() && item.getValue().equals(((DimMember)availableAmtOp.get()).getId())) {
                        return true;
                    }
                    return afterAvailableAmtOp.isPresent() && item.getValue().equals(((DimMember)afterAvailableAmtOp.get()).getId());
                }).map(ReportCalcVal::getCol).collect(Collectors.toSet());
                reportCalcModel.getDataValList().stream().filter(item -> disableColSet.contains(item.getCol())).forEach(item -> item.setEnable(false));
                if (template.getTemplateType() != TemplateType.DETAIL) continue;
                List<ReportCalcVal> pageDimValList = reportCalcModel.getPageDimValList();
                List<Long> pageDimIdList = pageDimValList.stream().map(ReportCalcVal::getDimensionId).collect(Collectors.toList());
                List<Object> pageDimVList = pageDimValList.stream().map(ReportCalcVal::getValue).collect(Collectors.toList());
                Predicate<ReportCalcVal> adjustAmtColPredicate = item -> item.getValue() != null && item.getValue().equals(justMember.getId());
                Set changeColSet = colDimValList.stream().filter(item -> adjustAmtColPredicate.or(ReportCalcVal::isRemarkCell).test((ReportCalcVal)item)).map(ReportCalcVal::getCol).collect(Collectors.toSet());
                Integer rowStart = reportCalcModel.getColDimValList().stream().map(ReportCalcVal::getRow).max(Integer::compareTo).get();
                List<ReportData> reportDataList = this.report.getReportDataByDimInfo(pageDimIdList, pageDimVList);
                OptionalInt maxOptional = reportDataList.stream().filter(item -> !item.isEditable()).mapToInt(ReportData::getRow).max();
                if (!maxOptional.isPresent()) {
                    maxOptional = OptionalInt.of(((PlanChangeReport)this.report).getNewDataStartRow() - 1);
                }
                if (!maxOptional.isPresent()) continue;
                int oldDataMaxLine = maxOptional.getAsInt();
                reportCalcModel.getDataValList().stream().filter(item -> item.getRow() > rowStart && item.getRow() <= oldDataMaxLine && !changeColSet.contains(item.getCol())).forEach(item -> item.setEnable(false));
            }
        }
    }
}

