/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.service.result.PeriodStartBalance;
import kd.tmc.fpm.business.spread.formula.enums.FormulaSymbolEnum;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.model.FormulaInfo;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class PositionAnalysisBuildAction
implements IReportDataProcessAction {
    private PeriodStartBalance balanceResult;
    private FundPlanSystem system;
    private Dimension accountTypeDimension;
    private Map<Long, String> accountTypeMemberType;
    private Dimension currencyDm;
    private Map<Long, DimMember> currencyMemberMap;
    private Dimension subjectDim;
    private String PERIOD_START_BALANCE_NAME = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"PositionAnalysisBuildAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
    private String CLEAN_FLOW_IN_BALANCE_NAME = ResManager.loadKDString((String)"\u672c\u671f\u51c0\u6d41\u5165", (String)"PositionAnalysisBuildAction_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
    private String PERIOD_END_BALANCE_NAME = ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d", (String)"PositionAnalysisBuildAction_2", (String)"tmc-fpm-business", (Object[])new Object[0]);

    public PositionAnalysisBuildAction(FundPlanSystem system, PeriodStartBalance balanceResult) {
        this.system = system;
        this.balanceResult = balanceResult;
        this.accountTypeDimension = this.system.getDimList().stream().filter(item -> item.getDimType() == DimensionType.ACCOUNTTYPE).findFirst().get();
        this.accountTypeMemberType = this.accountTypeDimension.getMemberList().stream().collect(Collectors.toMap(DimMember::getId, DimMember::getNumber));
        this.currencyDm = system.getMainDimensionByDimType(DimensionType.CURRENCY);
        this.currencyMemberMap = this.currencyDm.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity()));
        this.subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
    }

    @Override
    public void execute(ReportModel reportModel) {
        List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
        if (EmptyUtil.isEmpty(reportCalcModelList)) {
            return;
        }
        ReportCalcModel currReportCalcModel = reportCalcModelList.get(0);
        List<ReportCalcVal> rowDimValList = currReportCalcModel.getRowDimValList();
        int maxRow = rowDimValList.stream().map(ReportCalcVal::getRow).max(Integer::compareTo).orElse(0);
        List<ReportCalcVal> positionReportCalcValList = this.createPositionReportCalcVal(maxRow + 2, this.PERIOD_START_BALANCE_NAME, this.CLEAN_FLOW_IN_BALANCE_NAME, this.PERIOD_END_BALANCE_NAME);
        positionReportCalcValList.forEach(reportCalcVal -> currReportCalcModel.getExtValList().add((ReportCalcVal)reportCalcVal));
        List<ReportCalcVal> colDimValList = currReportCalcModel.getColDimValList();
        int maxCol = colDimValList.stream().map(ReportCalcVal::getCol).max(Integer::compareTo).orElse(0);
        Set summaryColSet = colDimValList.stream().filter(ReportCalcVal::isSummary).map(ReportCalcVal::getCol).collect(Collectors.toSet());
        Map<Integer, String> littleFlowMap = this.getLittleFlowMap(rowDimValList);
        Map<String, ReportCalcVal> reportCalcValMap = rowDimValList.stream().filter(rcv -> Objects.equals(this.subjectDim.getId(), rcv.getDimensionId())).filter(ReportCalcVal::isSummary).collect(Collectors.toMap(reportCalcVal -> (String)littleFlowMap.get(reportCalcVal.getRow()), Function.identity(), (a, b) -> a));
        for (int i = 2; i <= maxCol; ++i) {
            ReportCalcVal periodStart = positionReportCalcValList.get(0);
            ReportCalcVal cleanFlowIn = positionReportCalcValList.get(1);
            ReportCalcVal periodEnd = positionReportCalcValList.get(2);
            boolean isColSummary = summaryColSet.contains(i);
            ReportCalcVal periodStartValueCell = this.createPositionValueCell(i, periodStart.getRow(), isColSummary);
            ReportCalcVal cleanFlowInValueCell = this.createPositionValueCell(i, cleanFlowIn.getRow(), isColSummary);
            ReportCalcVal periodEndValueCell = this.createPositionValueCell(i, periodEnd.getRow(), isColSummary);
            currReportCalcModel.getExtValList().add(periodStartValueCell);
            currReportCalcModel.getExtValList().add(cleanFlowInValueCell);
            currReportCalcModel.getExtValList().add(periodEndValueCell);
            if (isColSummary) continue;
            this.setPeriodStart(currReportCalcModel, periodStartValueCell, maxRow);
            this.setCleanFlowIn(currReportCalcModel, cleanFlowInValueCell, reportCalcValMap);
            this.setPeriodEnd(periodEndValueCell, periodStartValueCell, cleanFlowInValueCell);
        }
    }

    private Map<Integer, String> getLittleFlowMap(List<ReportCalcVal> rowDimValList) {
        HashMap<Integer, String> rowFlowMap = new HashMap<Integer, String>(16);
        for (ReportCalcVal rowDimVal : rowDimValList) {
            int row;
            String flow;
            if (!Objects.equals(this.accountTypeDimension.getId(), rowDimVal.getDimensionId()) || EmptyUtil.isEmpty((String)(flow = this.accountTypeMemberType.get(rowDimVal.getValue())))) continue;
            for (int i = row = rowDimVal.getRow(); i < rowDimVal.getRowSpan() + row; ++i) {
                rowFlowMap.put(i, flow);
            }
        }
        return rowFlowMap;
    }

    private void setPeriodEnd(ReportCalcVal periodEnd, ReportCalcVal periodStart, ReportCalcVal cleanFlowInValueCell) {
        new FormulaInfo(periodEnd).add(periodStart, FormulaSymbolEnum.PLUS).add(cleanFlowInValueCell, FormulaSymbolEnum.PLUS).end();
    }

    private void setLineIfSummary(ReportCalcVal reportCalcVal) {
        reportCalcVal.setValue("--");
        reportCalcVal.setDisplayVal("--");
        reportCalcVal.setSummary(true);
    }

    private void setPeriodStart(ReportCalcModel currReportCalcModel, ReportCalcVal positionValueCell, int maxRow) {
        int currentCol;
        DimensionInfoBean endDimensionInfo;
        int col = positionValueCell.getCol();
        DimensionInfoBean dimensionInfo = currReportCalcModel.getDimensionInfo(col, maxRow);
        Object currencyMemberId = dimensionInfo.getMemberByDimensionId(this.currencyDm.getId());
        DimMember currencyMember = this.currencyMemberMap.get(currencyMemberId);
        if (col > 2 && (endDimensionInfo = currReportCalcModel.getDimensionInfo(currentCol = col - 1, maxRow + 2 + 2)) != null && Objects.equals(endDimensionInfo.getMemberByDimensionId(this.currencyDm.getId()), currencyMemberId)) {
            ReportCalcVal reportCalcVal = currReportCalcModel.getReportCalcVal(currentCol, maxRow + 4);
            while (reportCalcVal.isSummary()) {
                reportCalcVal = currReportCalcModel.getReportCalcVal(--currentCol, maxRow + 4);
            }
            new FormulaInfo(positionValueCell).add(reportCalcVal, FormulaSymbolEnum.PLUS).end();
        }
        if (Objects.nonNull(currencyMember)) {
            BigDecimal amount = this.balanceResult.getAmount(currencyMember.getSourceId());
            positionValueCell.setDisplayVal(amount.toPlainString());
            positionValueCell.setValue(amount);
        }
    }

    private void setCleanFlowIn(ReportCalcModel currReportCalcModel, ReportCalcVal positionValueCell, Map<String, ReportCalcVal> reportCalcValMap) {
        FormulaInfo formulaInfo = new FormulaInfo(positionValueCell);
        ReportCalcVal flowInReportCalcVal = reportCalcValMap.get(FlowType.IN.getNumber());
        ReportCalcVal flowOutReportCalcVal = reportCalcValMap.get(FlowType.OUT.getNumber());
        if (EmptyUtil.isEmpty((Object)flowInReportCalcVal) && EmptyUtil.isEmpty((Object)flowOutReportCalcVal)) {
            return;
        }
        if (EmptyUtil.isEmpty((Object)flowInReportCalcVal)) {
            ReportCalcVal reportCalcVal = currReportCalcModel.getReportCalcVal(positionValueCell.getCol(), flowOutReportCalcVal.getRow());
            if (Objects.isNull(reportCalcVal)) {
                return;
            }
            formulaInfo.add(FormulaSymbolEnum.MINUS).add(reportCalcVal, FormulaSymbolEnum.MINUS).end();
            return;
        }
        ReportCalcVal reportCalcValIn = currReportCalcModel.getReportCalcVal(positionValueCell.getCol(), flowInReportCalcVal.getRow());
        formulaInfo.add(reportCalcValIn, FormulaSymbolEnum.MINUS);
        if (EmptyUtil.isNoEmpty((Object)flowOutReportCalcVal)) {
            ReportCalcVal reportCalcVal = currReportCalcModel.getReportCalcVal(positionValueCell.getCol(), flowOutReportCalcVal.getRow());
            if (Objects.isNull(reportCalcVal)) {
                return;
            }
            formulaInfo.add(reportCalcVal, FormulaSymbolEnum.MINUS);
        }
        formulaInfo.end();
    }

    private ReportCalcVal createPositionValueCell(int col, int row, boolean isColSummary) {
        ReportCalcVal inDataCalVal = new ReportCalcVal();
        inDataCalVal.setRow(row);
        inDataCalVal.setCol(col);
        inDataCalVal.setColSpan(1);
        inDataCalVal.setRowSpan(1);
        inDataCalVal.setEnable(true);
        ReportValueType reportValueType = new ReportValueType();
        reportValueType.setReportCellType(isColSummary ? ReportCellType.TEXT : ReportCellType.AMOUNT);
        inDataCalVal.setValueType(reportValueType);
        inDataCalVal.setDisplayVal("0");
        inDataCalVal.setValue(0);
        if (isColSummary) {
            this.setLineIfSummary(inDataCalVal);
        }
        return inDataCalVal;
    }

    private List<ReportCalcVal> createPositionReportCalcVal(int startRow, String ... positionNames) {
        if (Objects.isNull(positionNames) || positionNames.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ReportCalcVal> positionReportCalcValList = new ArrayList<ReportCalcVal>(positionNames.length);
        for (String positionName : positionNames) {
            ReportCalcVal startAmountCalcVal = new ReportCalcVal();
            startAmountCalcVal.setCol(0);
            startAmountCalcVal.setRow(startRow++);
            startAmountCalcVal.setColSpan(2);
            ReportValueType type = new ReportValueType();
            type.setReportCellType(ReportCellType.TEXT);
            startAmountCalcVal.setValueType(type);
            startAmountCalcVal.setRowSpan(1);
            startAmountCalcVal.setDisplayVal(positionName);
            startAmountCalcVal.setValue(positionName);
            startAmountCalcVal.setEnable(false);
            positionReportCalcValList.add(startAmountCalcVal);
        }
        return positionReportCalcValList;
    }
}

