/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.List;
import java.util.Objects;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportQDTO;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;

public class ReferenceReportNotExistsLockReferenceCellAction
implements IReportDataProcessAction {
    private Report report;
    private IReportRepository reportRepository;

    public ReferenceReportNotExistsLockReferenceCellAction(ReportDataSource reportDataSource) {
        if (reportDataSource instanceof Report) {
            this.report = (Report)reportDataSource;
        }
        this.reportRepository = new ReportRepository();
    }

    @Override
    public void execute(ReportModel reportModel) {
        if (this.report == null) {
            return;
        }
        PeriodMember referencePeriodMember = this.report.getReferencePeriodMember();
        if (Objects.isNull(referencePeriodMember)) {
            return;
        }
        List<OrgMember> companyMemberList = this.report.getCompanyMemberList();
        if (EmptyUtil.isEmpty(companyMemberList)) {
            return;
        }
        OrgMember orgMember = companyMemberList.get(0);
        ReportQDTO reportQDTO = new ReportQDTO();
        reportQDTO.setReportOrgId(orgMember.getId());
        reportQDTO.setReportPeriodId(referencePeriodMember.getId());
        reportQDTO.setReportStatus(ReportStatus.ENABLE);
        reportQDTO.setReportPlanType(this.report.getReportPlanType());
        List<Report> reports = this.reportRepository.loadSimpleReport(reportQDTO, t -> {});
        if (EmptyUtil.isNoEmpty(reports)) {
            return;
        }
        List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
        reportCalcModelList.forEach(reportCalcModel -> {
            List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
            if (EmptyUtil.isEmpty(dataValList)) {
                return;
            }
            dataValList.forEach(r -> {
                if (r.isReferenceCell()) {
                    r.setEnable(false);
                }
            });
        });
    }
}

