/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.SpecialColorEnum;
import kd.tmc.fpm.common.utils.NumberUtils;

public class ReportDataProcessFixAction
implements IReportDataProcessAction {
    private ReportDataSource report;
    private FundPlanSystem system;
    private boolean isSumPlanReport;
    private boolean isInit;
    private ReportDataIndexQueryMap<Object> indexQueryMap;
    private Map<Object, ReportData> dataMap;
    private ReportDataIndexQueryMap<Object> remarkIndexQueryMap;
    private Map<Object, ReportData> remarkDataMap;
    private Long metricDimId;
    private Map<Long, MetricMember> metricMemberMap;
    private MetricMember reportAmtMember;
    private static final Log logger = LogFactory.getLog(ReportDataProcessFixAction.class);

    public ReportDataProcessFixAction(FundPlanSystem system, ReportDataSource report) {
        this.report = report;
        this.system = system;
        List<ReportData> reportDataList = report.getReportDataList();
        QueryIndexInfo queryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(reportDataList, system, rd -> !rd.isAuxiliaryInfo());
        this.indexQueryMap = queryIndexInfo.getIndexQueryMap();
        this.dataMap = queryIndexInfo.getDataMap();
        QueryIndexInfo remarkQueryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(reportDataList, system, ReportData::isAuxiliaryInfo);
        this.remarkIndexQueryMap = remarkQueryIndexInfo.getIndexQueryMap();
        this.remarkDataMap = remarkQueryIndexInfo.getDataMap();
        this.isSumPlanReport = report instanceof SumPlanReport;
        Dimension metricDim = this.system.getMainDimensionByDimType(DimensionType.METRIC);
        if (EmptyUtil.isEmpty((Object)metricDim)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c\u7ef4\u5ea6\u4e0d\u5b58\u5728\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4f53\u7cfb\u3010%s\u3011\u5ea6\u91cf\u503c\u7ef4\u5ea6\u662f\u5426\u5df2\u7ecf\u521d\u59cb\u5316", (String)"ReportDataProcessFixAction_0", (String)"tmc-fpm-business", (Object[])new Object[]{this.system.getName()}));
        }
        this.metricDimId = metricDim.getId();
        List<DimMember> allDimMemberList = metricDim.getAllDimMemberList();
        this.metricMemberMap = allDimMemberList.stream().map(MetricMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        this.reportAmtMember = this.metricMemberMap.values().stream().filter(metricMember -> metricMember.getTemplateMetricType() == TemplateMetricType.REPORTPLANAMT).findFirst().orElse(null);
        this.setInitFlag();
    }

    private void setInitFlag() {
        if (!(this.report instanceof Report)) {
            return;
        }
        this.isInit = ((Report)this.report).getInitFlag();
    }

    @Override
    public void execute(ReportModel reportModel) {
        List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
        for (ReportCalcModel reportCalcModel : reportCalcModelList) {
            List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
            for (ReportCalcVal reportCalcVal : dataValList) {
                if (reportCalcVal.isSummary()) continue;
                int col = reportCalcVal.getCol();
                int row = reportCalcVal.getRow();
                DimensionInfoBean dimensionInfo = reportCalcModel.getDimensionInfo(col, row);
                this.mountDataForDataCell(dimensionInfo, reportCalcVal);
            }
        }
    }

    private void mountDataForDataCell(DimensionInfoBean dimensionInfo, ReportCalcVal reportCalcVal) {
        Long metricMemId = this.filterMetricDimensionIfNeedAndGetMetricMemId(dimensionInfo, true);
        List<Object> list = this.indexQueryMap.findList(dimensionInfo);
        if (EmptyUtil.isEmpty(list)) {
            return;
        }
        List<ReportData> reportDataList = this.getReportDataList(reportCalcVal, dimensionInfo);
        if (reportDataList.size() == 1) {
            ReportData reportData = reportDataList.get(0);
            if (!this.isInit) {
                reportData.setCol(reportCalcVal.getCol());
                reportData.setRow(reportCalcVal.getRow());
            }
            this.setDataCell(reportCalcVal, reportData, metricMemId);
            this.setRemarkCell(reportCalcVal, reportData);
            return;
        }
        if (NumberUtils.greaterThan((Integer)reportDataList.size(), (Integer)1)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7ef4\u5ea6:%1$s\u7684\u6570\u636e\uff1a%2$s", (String)"ReportDataProcessFixAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]), dimensionInfo, reportDataList.stream().map(ReportData::getSourceIdList).collect(Collectors.toList())));
        }
    }

    private Long filterMetricDimensionIfNeedAndGetMetricMemId(DimensionInfoBean dimensionInfo, boolean needRemove) {
        Long metricMemId;
        List dimensionIdList = dimensionInfo.getDimensionIdList();
        List memberIdList = dimensionInfo.getMemberIdList();
        int index = dimensionIdList.indexOf(this.metricDimId);
        Long l = metricMemId = index == -1 ? Long.valueOf(0L) : (Long)memberIdList.get(index);
        if (index == -1) {
            logger.info("\u7ef4\u5ea6\u7ec4\u5408:{}\u627e\u4e0d\u5230\u5ea6\u91cf\u503c\u7ef4\u5ea6\uff1a{}", (Object)dimensionIdList, (Object)this.metricDimId);
            return 0L;
        }
        if (needRemove) {
            dimensionIdList.remove(index);
            memberIdList.remove(index);
        }
        return metricMemId;
    }

    private void setRemarkCell(ReportCalcVal reportCalcVal, ReportData reportData) {
        if (!reportCalcVal.isRemarkCell()) {
            return;
        }
        String remark = reportData.getAuxiliaryVal(reportCalcVal.getDimensionId());
        reportCalcVal.setDisplayVal(remark);
        reportCalcVal.setValue(remark);
        reportCalcVal.setDataId(reportData.getId());
        ReportValueType valueType = reportCalcVal.getValueType();
        valueType = valueType == null ? new ReportValueType() : valueType;
        valueType.setReportCellType(ReportCellType.TEXT);
        reportCalcVal.setValueType(valueType);
    }

    private void setDataCell(ReportCalcVal reportCalcVal, ReportData reportData, Long metricMemId) {
        if (!reportCalcVal.isDataCell()) {
            return;
        }
        Optional<MetricMember> metricMember = Optional.ofNullable(this.metricMemberMap.get(metricMemId));
        ReportValueType valueType = reportCalcVal.getValueType();
        valueType.setReportCellType(metricMember.filter(member -> member.getDataType().isPercent()).map(member -> ReportCellType.PERCENT).orElse(ReportCellType.AMOUNT));
        BigDecimal amtVal = EmptyUtil.isEmpty((Long)metricMemId) ? reportData.getPlanAmt() : reportData.getBigDecimalValueByMetric(metricMemId);
        amtVal = MetricValueUtils.transferScaleIfPercent(metricMember.isPresent() && metricMember.get().getDataType().isPercent(), amtVal);
        reportCalcVal.setValue(amtVal);
        reportCalcVal.setDataId(this.isSumPlanReport ? reportData.getSourceIdList() : reportData.getId());
        reportCalcVal.setDisplayVal(amtVal.toString());
        reportCalcVal.setDataCell(true);
        if (metricMember.isPresent() && Objects.equals(metricMember.get().getTemplateMetricType(), TemplateMetricType.ORIGINALPLANAMT)) {
            if (Objects.isNull(this.reportAmtMember)) {
                return;
            }
            BigDecimal reportPlanAmt = reportData.getBigDecimalValueByMetric(this.reportAmtMember.getId());
            if (Objects.compare(reportPlanAmt, amtVal, BigDecimal::compareTo) != 0) {
                reportCalcVal.setSpecialColor(SpecialColorEnum.APPROVED_COLOR);
            }
        }
    }

    private List<ReportData> getReportDataList(ReportCalcVal reportCalcVal, DimensionInfoBean dimensionInfo) {
        if (reportCalcVal.isDataCell()) {
            List<Object> list = this.indexQueryMap.findList(dimensionInfo);
            return list.stream().map(this.dataMap::get).collect(Collectors.toList());
        }
        Report report$ = (Report)this.report;
        PeriodMember referencePeriodMember = report$.getReferencePeriodMember();
        List<Object> list = this.remarkIndexQueryMap.findList(dimensionInfo);
        return list.stream().map(this.remarkDataMap::get).filter(rd -> Objects.equals(rd.getReportPeriodId(), reportCalcVal.isReferenceCell() ? referencePeriodMember.getId() : report$.getCurrentReportPeriod().getId())).collect(Collectors.toList());
    }
}

