/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.ImportDataTypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportFormHeader;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.IReportImportDataService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.spread.widget.DisplayTypeEnum;

public class ReportFormHeaderImportAction
implements IReportDataProcessAction {
    protected ReportDataSource report;
    protected FundPlanSystem system;
    protected IReportImportDataService reportImportDataService;
    private static final Map<ImportDataTypeEnum, String> HEADER_DESC_MAP = new HashMap<ImportDataTypeEnum, String>();

    public ReportFormHeaderImportAction(FundPlanSystem system, ReportDataSource report) {
        this.system = system;
        this.report = report;
        this.reportImportDataService = FpmServiceFactory.getBizService(IReportImportDataService.class);
    }

    @Override
    public void execute(ReportModel reportModel) {
        if (EmptyUtil.isEmpty((Object)reportModel)) {
            return;
        }
        Report report = (Report)this.report;
        ReportTemplate template = report.getTemplate();
        List<ReportFormHeader> reportFormHeaders = this.reportImportDataService.acquireHeader(report, this.system);
        ReportValueType valType = this.getValType(ReportCellType.TEXT, null);
        Map<Long, DimMember> dimMemberMap = this.system.getMainDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, o -> o, (a, b) -> a));
        HashMap<Long, String[]> colDropMap = new HashMap<Long, String[]>(2);
        HashMap<Long, String> dimMemberNameMap = new HashMap<Long, String>(2);
        Map<Long, TemplateDim> groupByDim = ReportFormHeaderImportAction.groupByDimTypeMap(report);
        this.fillDimMemberMap(colDropMap, dimMemberNameMap, groupByDim);
        ReportValueType connTerPartyValType = this.getConnTerPartyValType();
        List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList();
        int colOffset = this.reportImportDataService.getColOffset();
        int rowOffset = this.reportImportDataService.getRowOffset();
        HashSet<Integer> rowFlagSet = new HashSet<Integer>();
        HashSet<Integer> colFlagSet = new HashSet<Integer>();
        for (ReportCalcModel reportCalcModel : reportCalcModelList) {
            ReportCalcTree colTree;
            ArrayList<ReportCalcVal> descResultList = new ArrayList<ReportCalcVal>();
            ArrayList<ReportCalcVal> numberResultList = new ArrayList<ReportCalcVal>();
            ArrayList<ReportCalcVal> nameResultList = new ArrayList<ReportCalcVal>();
            descResultList.add(this.createCalcVal("", valType, 0, 0, false));
            numberResultList.add(this.createCalcVal(ResManager.loadKDString((String)"\u7f16\u7801", (String)"ReportFormHeaderImportAction_7", (String)"tmc-fpm-business", (Object[])new Object[0]), valType, 1, 0, false));
            nameResultList.add(this.createCalcVal(ResManager.loadKDString((String)"\u540d\u79f0", (String)"ReportFormHeaderImportAction_8", (String)"tmc-fpm-business", (Object[])new Object[0]), valType, 2, 0, false));
            int maxRCVCol = reportCalcModel.getColDimValList().stream().map(ReportCalcVal::getCol).max(Integer::compareTo).orElse(0);
            int pagePointer = 0;
            for (ReportFormHeader reportFormHeader : reportFormHeaders) {
                int headerCol = reportFormHeader.getCol();
                if (reportFormHeader.getImportDataTypeEnum() == ImportDataTypeEnum.PAGE_DIM) {
                    ReportCalcVal pageDim = reportCalcModel.getPageDimValList().get(pagePointer);
                    String pageDimName = String.format(HEADER_DESC_MAP.get((Object)reportFormHeader.getImportDataTypeEnum()), pagePointer + 1, pageDim.getDimensionName());
                    descResultList.add(this.createCalcVal(pageDimName, valType, 0, headerCol, false));
                    numberResultList.add(this.createCalcVal(dimMemberMap.get((Long)pageDim.getValue()).getNumber(), valType, 1, headerCol, false));
                    nameResultList.add(this.createCalcVal(pageDim.getDisplayVal(), valType, 2, headerCol, false));
                    ++pagePointer;
                    continue;
                }
                if (reportFormHeader.getImportDataTypeEnum() == ImportDataTypeEnum.DETAIL_ROW_INFO) {
                    Optional<ReportCalcVal> maxCalcValOptional;
                    String countColNam = ResManager.loadKDString((String)"\u660e\u7ec6\u8ba1\u5212\u884c\u6570", (String)"ReportFormHeaderImportAction_9", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    String beginNum = "";
                    String endNum = "";
                    int lineCnt = 0;
                    Optional<ReportCalcVal> minCalcValOptional = reportCalcModel.getDataValList().stream().min(Comparator.comparing(ReportCalcVal::getRow));
                    if (minCalcValOptional.isPresent()) {
                        beginNum = "B" + (minCalcValOptional.get().getRow() + 5);
                    }
                    if ((maxCalcValOptional = reportCalcModel.getDataValList().stream().max(Comparator.comparing(ReportCalcVal::getRow))).isPresent()) {
                        endNum = this.ITransformation(maxRCVCol + 2) + (maxCalcValOptional.get().getRow() + 5);
                    }
                    if (minCalcValOptional.isPresent() && maxCalcValOptional.isPresent()) {
                        lineCnt = maxCalcValOptional.get().getRow() - minCalcValOptional.get().getRow() + 1;
                    }
                    String location = String.format("%s;%s", beginNum, endNum);
                    descResultList.add(this.createCalcVal(countColNam, valType, 0, headerCol, false));
                    numberResultList.add(this.createCalcVal(location, valType, 1, headerCol, false));
                    nameResultList.add(this.createCalcVal(lineCnt, valType, 2, headerCol, false));
                    continue;
                }
                descResultList.add(this.createCalcVal(HEADER_DESC_MAP.get((Object)reportFormHeader.getImportDataTypeEnum()), valType, 0, headerCol, false));
                numberResultList.add(this.createCalcVal(reportFormHeader.getNumber(), valType, 1, headerCol, false));
                nameResultList.add(this.createCalcVal(reportFormHeader.getName(), valType, 2, headerCol, false));
            }
            List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
            this.addOriginalRowNum(template, valType, reportCalcModel, dataValList);
            this.detailReportCalcVal(template, valType, groupByDim, reportCalcModel, descResultList, maxRCVCol);
            List<ReportCalcVal> extValList = reportCalcModel.getExtValList();
            if (EmptyUtil.isEmpty(extValList)) {
                extValList = new ArrayList<ReportCalcVal>(10);
            }
            extValList.forEach(o -> o.setRow(o.getRow() + 3));
            extValList.addAll(descResultList);
            reportCalcModel.setExtValList(extValList);
            this.handelDataValList(colDropMap, dimMemberNameMap, connTerPartyValType, dataValList);
            dataValList.forEach(o -> {
                o.setRow(o.getRow() + rowOffset);
                o.setCol(o.getCol() + colOffset);
            });
            dataValList.addAll(numberResultList);
            dataValList.addAll(nameResultList);
            this.addExtCalcValList(template, valType, colDropMap, groupByDim, maxRCVCol, dataValList);
            List<ReportCalcVal> rowDimValList = reportCalcModel.getRowDimValList();
            rowDimValList.forEach(o -> {
                o.setRow(o.getRow() + rowOffset);
                o.setCol(o.getCol() + colOffset);
            });
            List<ReportCalcVal> colDimValList = reportCalcModel.getColDimValList();
            colDimValList.forEach(o -> {
                o.setRow(o.getRow() + rowOffset);
                o.setCol(o.getCol() + colOffset);
            });
            ReportCalcTree rowTree = reportCalcModel.getRowTree();
            if (rowTree != null && rowTree.getRoot() != null && !rowFlagSet.contains(rowTree.hashCode())) {
                List<ReportCalcValTreeNode> allChildren = rowTree.getRoot().getAllChildren();
                allChildren.forEach(c -> {
                    c.setRow(c.getRow() + rowOffset);
                    c.setCol(c.getCol() + colOffset);
                });
                rowFlagSet.add(rowTree.hashCode());
            }
            if ((colTree = reportCalcModel.getColTree()) != null && colTree.getRoot() != null && !colFlagSet.contains(colTree.hashCode())) {
                List<ReportCalcValTreeNode> allChildren = colTree.getRoot().getAllChildren();
                allChildren.forEach(c -> {
                    c.setRow(c.getRow() + rowOffset);
                    c.setCol(c.getCol() + colOffset);
                });
                colFlagSet.add(colTree.hashCode());
            }
            reportCalcModel.setRowOffset(reportCalcModel.getRowOffset() + rowOffset);
            reportCalcModel.setColOffset(reportCalcModel.getColOffset() + colOffset);
        }
    }

    private void addOriginalRowNum(ReportTemplate template, ReportValueType valType, ReportCalcModel reportCalcModel, List<ReportCalcVal> dataValList) {
        if (template.getTemplateType() == TemplateType.DETAIL) {
            Set originalRowS = dataValList.stream().filter(c -> c.getCol() >= 0 && c.getRow() > 0).filter(calcVal -> EmptyUtil.isNoEmpty((Object)calcVal.getValue())).map(ReportCalcVal::getRow).collect(Collectors.toSet());
            Optional<ReportCalcVal> rowEndInxOp = reportCalcModel.getColDimValList().stream().max(Comparator.comparing(ReportCalcVal::getRow));
            int colTreeHeight = rowEndInxOp.map(ReportCalcVal::getRow).orElse(0);
            int colTreeLevel = rowEndInxOp.map(ReportCalcVal::getLevel).orElse(0);
            int currentHeight = colTreeHeight;
            if (EmptyUtil.isNoEmpty(originalRowS)) {
                Iterator iterator = originalRowS.iterator();
                while (iterator.hasNext()) {
                    Integer originalRow;
                    Integer n = originalRow = (Integer)iterator.next();
                    Integer n2 = originalRow = Integer.valueOf(originalRow + 1);
                    if (colTreeHeight > colTreeLevel) {
                        n = originalRow;
                        n2 = originalRow = Integer.valueOf(originalRow - 1);
                    }
                    dataValList.add(this.createCalcVal(originalRow, valType, ++currentHeight, -1, false));
                }
                dataValList.add(this.createCalcVal(ResManager.loadKDString((String)"\u539f\u59cb\u8868\u884c\u53f7", (String)"ReportFormHeaderImportAction_10", (String)"tmc-fpm-business", (Object[])new Object[0]), valType, colTreeHeight, -1, false));
            }
        }
    }

    private static Map<Long, TemplateDim> groupByDimTypeMap(Report report) {
        HashMap<Long, TemplateDim> templateDimMap = new HashMap<Long, TemplateDim>(report.getTemplate().getColDimList().size());
        for (TemplateDim templateDim : report.getTemplate().getColDimList()) {
            if (report.getReportPeriodType().getDetailPeriodType() != null && templateDim.getDimType() == DimensionType.PERIOD) {
                List<Long> parentMemberIds = templateDim.getMemberScope();
                List<Long> periodMemberIds = report.getPeriodMemberList().stream().filter(c -> parentMemberIds.contains(c.getId())).map(DimMember::getChildren).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
                templateDim.setMemberScope(periodMemberIds);
            }
            if (EmptyUtil.isEmpty(templateDim.getMemberScope())) continue;
            templateDimMap.put(templateDim.getDimensionId(), templateDim);
        }
        return templateDimMap;
    }

    private ReportValueType getConnTerPartyValType() {
        List connTerPartyList = JSONArray.parseArray((String)DetailDimType.CONNTERPARTY_TYPE.getExtVal().toString(), JSONObject.class);
        return this.getValType(ReportCellType.ENUM, connTerPartyList.stream().map(c -> c.getString("value")).toArray(String[]::new));
    }

    private void addExtCalcValList(ReportTemplate template, ReportValueType valType, Map<Long, String[]> colDropMap, Map<Long, TemplateDim> groupByDim, int maxCol, List<ReportCalcVal> dataValList) {
        if (template.getTemplateType() == TemplateType.DETAIL) {
            int count = 0;
            for (Map.Entry<Long, TemplateDim> entry : groupByDim.entrySet()) {
                String[] dimMemberNameS = colDropMap.get(entry.getKey());
                for (int i = 0; i < dimMemberNameS.length; ++i) {
                    dataValList.add(this.createCalcVal(dimMemberNameS[i], valType, 6 + i, maxCol + 3 + count, false));
                }
                ++count;
            }
        }
    }

    private void handelDataValList(Map<Long, String[]> colDropMap, Map<Long, String> dimMemberMap, ReportValueType connTerPartyValType, List<ReportCalcVal> dataValList) {
        dataValList.forEach(c -> {
            ReportValueType valueType = c.getValueType();
            ReportCellType reportCellType = valueType.getReportCellType();
            if (reportCellType == ReportCellType.BASE_DATA) {
                Object[] dimMemberDrop = (String[])colDropMap.get(c.getDimensionId());
                if (EmptyUtil.isNoEmpty((Object[])dimMemberDrop)) {
                    ReportValueType dimMemberValType = this.getValType(ReportCellType.ENUM, dimMemberDrop);
                    c.setValueType(dimMemberValType);
                }
                if (EmptyUtil.isEmpty((Object)c.getValue())) {
                    return;
                }
                String dimMemberName = (String)dimMemberMap.get((Long)c.getValue());
                if (EmptyUtil.isNoEmpty((String)dimMemberName)) {
                    c.setDisplayVal(dimMemberName);
                }
            } else if (reportCellType == ReportCellType.MUTI_BASE_DATA) {
                c.setValueType(connTerPartyValType);
            } else if (reportCellType == ReportCellType.ENUM) {
                HashMap value = (HashMap)c.getValueType().getValue();
                c.getValueType().setValue(value.keySet().toArray(new String[0]));
            }
        });
    }

    private void fillDimMemberMap(Map<Long, String[]> colDropMap, Map<Long, String> dimMemberMap, Map<Long, TemplateDim> groupByDim) {
        for (Map.Entry<Long, TemplateDim> entry : groupByDim.entrySet()) {
            TemplateDim templateDim = entry.getValue();
            Long dimensionId = entry.getKey();
            Set<Long> dimMemberIdSet = templateDim.getDimType() == DimensionType.PERIOD ? this.report.getCurrentAllPeriodMembers().stream().map(DimMember::getId).collect(Collectors.toSet()) : new HashSet<Long>(templateDim.getMemberScope());
            if (templateDim.getDimType() == DimensionType.ACCOUNTTYPE) {
                String[] names = (String[])templateDim.getMemberScope().stream().map(c -> {
                    FlowType flowType = FlowType.getByVid(c);
                    if (Objects.isNull((Object)flowType)) {
                        return null;
                    }
                    FlowEnum flowEnum = FlowType.convertEnum(flowType);
                    if (Objects.isNull(flowEnum)) {
                        return null;
                    }
                    return String.join((CharSequence)"*", flowEnum.getValue(), flowEnum.getName());
                }).filter(Objects::nonNull).toArray(String[]::new);
                colDropMap.put(dimensionId, names);
                List<Long> memberScope = templateDim.getMemberScope();
                memberScope.forEach(item -> {
                    FlowType flowType = FlowType.getByVid(item);
                    if (Objects.isNull((Object)flowType)) {
                        return;
                    }
                    FlowEnum flowEnum = FlowType.convertEnum(flowType);
                    if (Objects.isNull(flowEnum)) {
                        return;
                    }
                    String name = String.join((CharSequence)"*", flowEnum.getValue(), flowEnum.getName());
                    dimMemberMap.put((Long)item, name);
                });
                continue;
            }
            Object[] dimMembers = TmcDataServiceHelper.load((String)"fpm_member", (String)String.join((CharSequence)",", "id", "number", "name"), (QFilter[])new QFilter[]{new QFilter("id", "in", dimMemberIdSet)}, (String)"startdate");
            if (EmptyUtil.isEmpty((Object[])dimMembers)) continue;
            colDropMap.put(dimensionId, (String[])Arrays.stream(dimMembers).map(c -> String.join((CharSequence)"*", c.getString("number"), c.getString("name"))).toArray(String[]::new));
            Arrays.stream(dimMembers).forEach(c -> dimMemberMap.put(c.getLong("id"), String.join((CharSequence)"*", c.getString("number"), c.getString("name"))));
        }
    }

    private void detailReportCalcVal(ReportTemplate template, ReportValueType valType, Map<Long, TemplateDim> groupByDim, ReportCalcModel reportCalcModel, List<ReportCalcVal> tempHeaderDescCalcValLst, int maxCol) {
        if (template.getTemplateType() == TemplateType.DETAIL) {
            String dimMemberTitle = ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u8303\u56f4", (String)"ReportFormHeaderImportAction_11", (String)"tmc-fpm-business", (Object[])new Object[0]);
            tempHeaderDescCalcValLst.add(this.createCalcVal(dimMemberTitle, valType, 4, maxCol + 3, false));
            List<ReportCalcVal> colDimValList = reportCalcModel.getColDimValList();
            Set dimensionIds = colDimValList.stream().map(ReportCalcVal::getDimensionId).collect(Collectors.toSet());
            int count = 0;
            for (Map.Entry<Long, TemplateDim> entry : groupByDim.entrySet()) {
                if (dimensionIds.contains(entry.getKey())) continue;
                TemplateDim templateDim = entry.getValue();
                colDimValList.add(this.createCalcVal(templateDim.getDimensionName(), valType, 1, maxCol + 2 + count, false));
                ++count;
            }
        }
    }

    private ReportCalcVal createCalcVal(Object value, ReportValueType type, int row, int col, boolean isEnable) {
        ReportCalcVal calcVal = new ReportCalcVal();
        calcVal.setRow(row);
        calcVal.setCol(col);
        calcVal.setValue(value);
        calcVal.setEnable(isEnable);
        calcVal.setSummary(false);
        calcVal.setRemarkCell(false);
        calcVal.setDataCell(false);
        calcVal.setValueType(type);
        calcVal.setDisplayVal(Optional.ofNullable(value).map(Object::toString).orElseGet(() -> "-"));
        calcVal.setRowSpan(1);
        calcVal.setColSpan(1);
        calcVal.setDisplayType(DisplayTypeEnum.NORMAR);
        return calcVal;
    }

    private ReportValueType getValType(ReportCellType cellType, Object val) {
        ReportValueType valType = new ReportValueType();
        valType.setValue(val);
        valType.setReportCellType(cellType);
        return valType;
    }

    public String ITransformation(Integer integer) {
        int pre;
        int len = 0;
        int power = 1;
        for (pre = 0; pre < integer; pre += (power *= 26)) {
            ++len;
        }
        char[] excelNum = new char[len];
        Integer n = integer = Integer.valueOf(integer - (pre - power));
        Integer n2 = integer = Integer.valueOf(integer - 1);
        for (int i = 0; i < len; ++i) {
            excelNum[i] = (char)(integer / (power /= 26) + 65);
            integer = integer % power;
        }
        return String.valueOf(excelNum);
    }

    static {
        HEADER_DESC_MAP.put(ImportDataTypeEnum.BODY_SYSTEM, ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"ReportFormHeaderImportAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER_DESC_MAP.put(ImportDataTypeEnum.REPORT, ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"ReportFormHeaderImportAction_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER_DESC_MAP.put(ImportDataTypeEnum.ORG, ResManager.loadKDString((String)"\u7f16\u62a5\u4e3b\u4f53", (String)"ReportFormHeaderImportAction_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER_DESC_MAP.put(ImportDataTypeEnum.PERIOD_DIM, ResManager.loadKDString((String)"\u7f16\u62a5\u7c7b\u578b", (String)"ReportFormHeaderImportAction_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER_DESC_MAP.put(ImportDataTypeEnum.PERIOD_MEMBER, ResManager.loadKDString((String)"\u7f16\u62a5\u671f\u95f4", (String)"ReportFormHeaderImportAction_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER_DESC_MAP.put(ImportDataTypeEnum.CURRENCY, ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d", (String)"ReportFormHeaderImportAction_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER_DESC_MAP.put(ImportDataTypeEnum.PAGE_DIM, ResManager.loadKDString((String)"\u9875\u9762\u7ef4%1$s\uff1a%2$s", (String)"ReportFormHeaderImportAction_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
        HEADER_DESC_MAP.put(ImportDataTypeEnum.DETAIL_ROW_INFO, ResManager.loadKDString((String)"\u660e\u7ec6\u8ba1\u5212\u884c\u6570", (String)"ReportFormHeaderImportAction_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
    }
}

