/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fpm.business.domain.enums.AuxiliaryFieldsUseType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricDataType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import org.apache.commons.collections.CollectionUtils;

public class ReportStructSplitBuildAction
implements IReportDataProcessAction {
    private FundPlanSystem system;
    private ReportDataSource report;
    private Map<Object, DimMember> dimMemberMap;
    private List<Long> pageDimS;
    private Integer pageIndex;

    public ReportStructSplitBuildAction(FundPlanSystem system, ReportDataSource report) {
        this.consComp(system, report);
    }

    public ReportStructSplitBuildAction(FundPlanSystem system, ReportDataSource report, List<Long> pageDimS) {
        this.consComp(system, report);
        this.pageDimS = pageDimS;
    }

    public ReportStructSplitBuildAction(FundPlanSystem system, ReportDataSource report, Integer pageIndex) {
        this.consComp(system, report);
        this.pageIndex = pageIndex;
    }

    private void consComp(FundPlanSystem system, ReportDataSource report) {
        this.system = system;
        this.report = report;
        this.dimMemberMap = this.system.getMainDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, o -> o, (a, b) -> a));
    }

    @Override
    public void execute(ReportModel reportModel) {
        ReportCalcModel templateModel = reportModel.getTemplateModel();
        ReportTemplate template = this.report.getTemplate();
        List<TemplateDim> pageDimList = template.getPageDimList();
        List<Object> pageChildMemCnt = new ArrayList(2);
        int cnt = 0;
        if (TemplateUseType.ANALYSIS == template.getTemplateUse()) {
            cnt = 1;
        } else if (this.pageDimS == null) {
            pageChildMemCnt = this.getPageMemChildCnt(pageDimList);
            cnt = (Integer)pageChildMemCnt.get(0);
            if (cnt == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u201c%1$s\u201d\u9875\u9762\u7ef4\u4fe1\u606f\u914d\u7f6e\u9519\u8bef\uff1a\u5b58\u5728\u65e0\u7ef4\u5ea6\u6210\u5458\u7684\u9875\u9762\u7ef4, \u8bf7\u68c0\u67e5\u3002", (String)"ReportStructSplitBuildAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]), template.getNumber()));
            }
        } else {
            cnt = 1;
        }
        ArrayList<ReportCalcModel> reportCalcModelList = new ArrayList<ReportCalcModel>(cnt);
        reportModel.setReportCalcModelList(reportCalcModelList);
        for (int i = 0; i < cnt; ++i) {
            if (this.pageIndex != null && this.pageIndex != i) continue;
            ReportCalcModel reportCalcModel = new ReportCalcModel();
            reportCalcModel.setColOffset(templateModel.getColOffset());
            reportCalcModel.setRowOffset(templateModel.getRowOffset());
            reportCalcModel.setRowTree(templateModel.getRowTree());
            reportCalcModel.setColTree(templateModel.getColTree());
            int pageDimSize = template.getPageDimList().size();
            ArrayList<ReportCalcVal> pageDimValList = new ArrayList<ReportCalcVal>(pageDimSize);
            if (TemplateUseType.ANALYSIS != template.getTemplateUse()) {
                for (int j = 0; j < pageDimSize; ++j) {
                    TemplateDim pageDim = pageDimList.get(j);
                    List<Long> memScope = pageDim.getMemberScope();
                    Long memId = null;
                    if (this.pageDimS == null) {
                        int childSize = j == pageDimSize - 1 ? 1 : (Integer)pageChildMemCnt.get(j + 1);
                        memId = memScope.get(i / childSize % memScope.size());
                    } else {
                        List currDimS = (List)CollectionUtils.intersection(this.pageDimS, memScope);
                        if (CollectionUtils.isEmpty((Collection)currDimS)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u4fe1\u606f\u6709\u8bef\u3002", (String)"ReportStructSplitBuildAction_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
                        }
                        memId = (Long)currDimS.get(0);
                    }
                    ReportCalcVal val = new ReportCalcVal();
                    val.setDimensionId(pageDim.getDimensionId());
                    val.setDimensionName(pageDim.getDimensionName());
                    val.setValue(memId);
                    val.setDisplayVal(this.dimMemberMap.get(memId).getName());
                    ReportValueType reportValueType = new ReportValueType();
                    reportValueType.setReportCellType(ReportCellType.TEXT);
                    val.setValueType(reportValueType);
                    pageDimValList.add(val);
                }
            }
            reportCalcModel.setPageDimValList(pageDimValList);
            List<ReportCalcVal> colDimValList = templateModel.getColDimValList();
            reportCalcModel.setColDimValList(this.cloneCalcValList(colDimValList));
            if (template.getTemplateType() == TemplateType.FIXED) {
                List<ReportCalcVal> rowDimValList = templateModel.getRowDimValList();
                reportCalcModel.setRowDimValList(this.cloneCalcValList(rowDimValList));
            } else {
                reportCalcModel.setRowDimValList(Collections.emptyList());
            }
            reportCalcModel.setDataValList(new ArrayList<ReportCalcVal>());
            reportCalcModelList.add(reportCalcModel);
        }
        for (ReportCalcModel reportCalcModel : reportCalcModelList) {
            this.initDataReportCalVal(reportCalcModel, reportModel);
        }
    }

    private List<Integer> getPageMemChildCnt(List<TemplateDim> dimList) {
        ArrayList<Integer> memChildSize = new ArrayList<Integer>(dimList.size());
        int childSize = 1;
        for (int i = dimList.size() - 1; i >= 0; --i) {
            TemplateDim templateDim = dimList.get(i);
            List<Long> memScope = templateDim.getMemberScope();
            int memSize = memScope.size();
            memChildSize.add(childSize *= memSize);
        }
        Collections.reverse(memChildSize);
        return memChildSize;
    }

    private List<ReportCalcVal> cloneCalcValList(List<ReportCalcVal> calcValList) {
        ArrayList<ReportCalcVal> result = new ArrayList<ReportCalcVal>(calcValList.size());
        for (ReportCalcVal reportCalcVal : calcValList) {
            result.add(reportCalcVal.clone());
        }
        return result;
    }

    private void initDataReportCalVal(ReportCalcModel reportCalcModel, ReportModel reportModel) {
        ArrayList<ReportCalcVal> dataValList = new ArrayList<ReportCalcVal>(16);
        ReportTemplate template = this.report.getTemplate();
        TemplateType templateType = template.getTemplateType();
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        List<ReportCalcVal> rowDimValList = reportCalcModel.getRowDimValList();
        List<ReportCalcVal> colDimValList = reportCalcModel.getColDimValList();
        Integer rowStartIndex = colDimValList.stream().map(ReportCalcVal::getRow).max(Integer::compareTo).get();
        if (TemplateType.DETAIL == templateType) {
            Integer maxLineCount = template.getMaxLineCount();
            if (TemplateUseType.ANALYSIS == template.getTemplateUse()) {
                maxLineCount = this.report.getReportDataList().size();
            }
            for (ReportCalcVal reportCalcVal : colDimValList) {
                if (reportCalcVal.getColSpan() != 1 || reportCalcVal.getRow() + reportCalcVal.getRowSpan() - 1 != rowStartIndex) continue;
                boolean isData = false;
                ReportValueType reportValueType = new ReportValueType();
                Long finalDimId = null;
                Long dimensionId = reportCalcVal.getDimensionId();
                TemplateDim templateDim = allTemplateDim.stream().filter(item -> item.getDimensionId().equals(dimensionId)).findFirst().get();
                if (DimensionType.DETAILDIM == templateDim.getDimType()) {
                    finalDimId = dimensionId;
                    DetailDimType detailDimType = templateDim.getDetailDimType();
                    if (DetailDimType.PLAN_AMOUNT == detailDimType) {
                        isData = true;
                    }
                    Dimension detailDim = this.system.getDetailDimensionByDetailType(detailDimType);
                    MemberType memberType = detailDim.getMemberType();
                    ReportCellType reportCellType = ReportCellType.valueOf(memberType.name());
                    reportValueType.setReportCellType(reportCellType);
                    if (ReportCellType.BASE_DATA == reportCellType || ReportCellType.MUTI_BASE_DATA == reportCellType) {
                        if (ReportCellType.MUTI_BASE_DATA == reportCellType) {
                            String extValStr = detailDimType.getExtVal().toString();
                            List extValList = JSONArray.parseArray((String)extValStr, JSONObject.class);
                            HashMap extMap = new HashMap(extValList.size());
                            for (JSONObject o : extValList) {
                                extMap.put(o.getString("value"), o.getString("key"));
                            }
                            reportValueType.setValue(extMap);
                        } else {
                            reportValueType.setValue(detailDimType.getExtVal() != null ? detailDimType.getExtVal() : templateDim.getBaseDataType());
                        }
                    } else if (ReportCellType.ENUM == reportCellType) {
                        List<String> memberValList = detailDim.getMemberValList();
                        HashMap<String, String> enumValueMap = new HashMap<String, String>(memberValList.size());
                        for (String memberVal : memberValList) {
                            enumValueMap.put(memberVal, memberVal);
                        }
                        reportValueType.setValue(enumValueMap);
                    }
                } else if (!templateDim.isExpand() && !templateDim.isViDim()) {
                    finalDimId = dimensionId;
                    reportValueType.setReportCellType(ReportCellType.BASE_DATA);
                    reportValueType.setValue("fpm_member");
                } else if (templateDim.getDimType() == DimensionType.ACCOUNTTYPE) {
                    reportCalcVal.setVirtualCell(true);
                } else {
                    isData = true;
                    reportValueType.setReportCellType(ReportCellType.AMOUNT);
                }
                for (int rowIndex = rowStartIndex + 1; rowIndex <= maxLineCount + rowStartIndex; ++rowIndex) {
                    ReportCalcVal reportCalcValNew = new ReportCalcVal();
                    ReportValueType reportValueTypeNew = new ReportValueType();
                    reportValueTypeNew.setValue(reportValueType.getValue());
                    reportValueTypeNew.setReportCellType(reportValueType.getReportCellType());
                    reportCalcValNew.setCol(reportCalcVal.getCol());
                    reportCalcValNew.setRow(rowIndex);
                    reportCalcValNew.setRowSpan(1);
                    reportCalcValNew.setColSpan(1);
                    reportCalcValNew.setDataCell(isData);
                    reportCalcValNew.setSummary(reportCalcVal.isSummary());
                    reportCalcValNew.setValueType(reportValueTypeNew);
                    reportCalcValNew.setDimensionId(finalDimId);
                    if (isData && !reportCalcVal.isSummary() || !isData && !reportCalcVal.isSummary() && !reportCalcVal.isRemarkCell()) {
                        reportCalcValNew.setEnable(true);
                    }
                    if (reportCalcVal.isReferenceCell()) {
                        reportCalcValNew.setEnable(false);
                    }
                    if (templateDim.getDimType() == DimensionType.ACCOUNTTYPE) {
                        reportCalcValNew.setEnable(false);
                        reportCalcValNew.setVirtualCell(true);
                    }
                    dataValList.add(reportCalcValNew);
                }
            }
        } else {
            Integer colStartIndex = CollectionUtils.isEmpty(rowDimValList) ? Integer.valueOf(0) : rowDimValList.stream().map(ReportCalcVal::getCol).max(Integer::compareTo).get();
            Integer colMaxRowIndex = colDimValList.stream().map(ReportCalcVal::getRow).max(Integer::compareTo).get();
            List<TemplateAccountSetting> accountSettings = template.getAccountSettings();
            List unEnableAccounts = accountSettings.stream().filter(item -> ReportInputType.FORMULA == item.getInputType() || ReportInputType.SUMMARY == item.getInputType() || ReportInputType.DETAIL_INPUT == item.getInputType()).collect(Collectors.toList());
            List summaryColList = colDimValList.stream().filter(ReportCalcVal::isSummary).collect(Collectors.toList());
            List isTotalSumList = colDimValList.stream().filter(ReportCalcVal::isTotalSummary).collect(Collectors.toList());
            for (ReportCalcVal reportCalcVal : colDimValList) {
                if (reportCalcVal.getCol() <= colStartIndex || reportCalcVal.getColSpan() != 1 || reportCalcVal.getRow() + reportCalcVal.getRowSpan() - 1 != colMaxRowIndex) continue;
                Integer rowEndIndex = CollectionUtils.isEmpty(rowDimValList) ? Integer.valueOf(0) : rowDimValList.stream().map(ReportCalcVal::getRow).max(Integer::compareTo).get();
                boolean summary = reportCalcVal.isSummary();
                if (!summary) {
                    for (ReportCalcVal calcVal : summaryColList) {
                        if (!calcVal.isCross(reportCalcVal.getCol(), reportCalcVal.getRow(), DimLocation.COL)) continue;
                        summary = true;
                        break;
                    }
                }
                boolean remark = reportCalcVal.isRemarkCell();
                boolean totalSummary = reportCalcVal.isTotalSummary();
                if (!totalSummary) {
                    for (ReportCalcVal calcVal : isTotalSumList) {
                        if (!calcVal.isCross(reportCalcVal.getCol(), reportCalcVal.getRow(), DimLocation.COL)) continue;
                        totalSummary = calcVal.isTotalSummary();
                        break;
                    }
                }
                for (int rowIndex = rowStartIndex + 1; rowIndex <= rowEndIndex; ++rowIndex) {
                    ReportValueType reportValueType = new ReportValueType();
                    reportValueType.setReportCellType(ReportCellType.AMOUNT);
                    int finalRowIndex = rowIndex;
                    List currRowDim = rowDimValList.stream().filter(item -> item.getRow() == finalRowIndex).collect(Collectors.toList());
                    boolean rowSummary = currRowDim.stream().filter(item -> item.isSummary()).findFirst().isPresent();
                    ReportCalcVal reportCalcValNew = new ReportCalcVal();
                    reportCalcValNew.setCol(reportCalcVal.getCol());
                    reportCalcValNew.setRow(rowIndex);
                    reportCalcValNew.setRowSpan(1);
                    reportCalcValNew.setColSpan(1);
                    reportCalcValNew.setMetric(reportCalcVal.isMetric());
                    reportCalcValNew.setReferenceCell(reportCalcVal.isReferenceCell());
                    reportCalcValNew.setRollCell(reportCalcVal.isRollCell());
                    if (!remark) {
                        reportCalcValNew.setDataCell(true);
                        reportCalcValNew.setValue(BigDecimal.ZERO);
                    } else {
                        reportValueType.setReportCellType(ReportCellType.TEXT);
                        reportCalcValNew.setDimensionId(reportCalcVal.getDimensionId());
                    }
                    reportCalcValNew.setRemarkCell(remark);
                    reportCalcValNew.setSummary(summary || rowSummary);
                    reportCalcValNew.setTotalSummary(totalSummary);
                    if (!reportCalcValNew.isSummary() && !reportCalcValNew.isReferenceCell()) {
                        reportCalcValNew.setEnable(true);
                    }
                    DimMember dimMember = this.dimMemberMap.get(reportCalcVal.getValue());
                    if (reportCalcVal.isMetric()) {
                        MetricMember metric = (MetricMember)dimMember;
                        if (metric.getDataType() == TemplateMetricDataType.PERCENT) {
                            reportValueType.setReportCellType(ReportCellType.PERCENT);
                        }
                        if (metric.getTemplateMetricType() != TemplateMetricType.PLANAMT) {
                            reportCalcValNew.setEnable(false);
                        }
                    }
                    reportCalcValNew.setValueType(reportValueType);
                    if (reportCalcVal.isReferenceCell()) {
                        reportCalcValNew.setEnable(false);
                        if (reportCalcVal.isRemarkCell() && reportCalcVal.getUseType() == AuxiliaryFieldsUseType.EXEC_DEVIATION_ANALYSIS && !reportCalcValNew.isSummary()) {
                            reportCalcValNew.setEnable(true);
                        }
                    }
                    List currDataRowDimList = rowDimValList.stream().filter(item -> item.isCross(reportCalcVal.getCol(), finalRowIndex, DimLocation.ROW)).map(ReportCalcVal::getValue).collect(Collectors.toList());
                    Optional<TemplateAccountSetting> first = unEnableAccounts.stream().filter(item -> currDataRowDimList.contains(item.getAccountMemId())).findFirst();
                    if (first.isPresent() && !reportCalcVal.isRemarkCell()) {
                        reportCalcValNew.setEnable(false);
                    }
                    dataValList.add(reportCalcValNew);
                }
            }
        }
        dataValList.sort((o1, o2) -> {
            int row2;
            int row1 = o1.getRow();
            if (row1 == (row2 = o2.getRow())) {
                return o1.getCol() - o2.getCol();
            }
            return row1 - row2;
        });
        reportCalcModel.setDataValList(dataValList);
    }
}

