/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;

public class SubjectFlowBuildAction
implements IReportDataProcessAction {
    private FundPlanSystem system;
    private ReportDataSource report;

    public SubjectFlowBuildAction(FundPlanSystem system, ReportDataSource report) {
        this.system = system;
        this.report = report;
    }

    @Override
    public void execute(ReportModel reportModel) {
        ReportTemplate template = this.report.getTemplate();
        Optional<TemplateDim> accountTypeOptional = template.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.ACCOUNTTYPE).findFirst();
        if (!accountTypeOptional.isPresent()) {
            return;
        }
        TemplateDim accountTypeTemDim = accountTypeOptional.get();
        Dimension accountTypeDim = this.system.getMainDimensionByDimType(DimensionType.ACCOUNTTYPE);
        List<DimMember> memberList = accountTypeDim.getMemberList();
        List<Long> accountTypeScope = accountTypeTemDim.getMemberScope();
        List accountTypeMemberList = memberList.stream().filter(item -> accountTypeScope.contains(item.getId())).collect(Collectors.toList());
        Optional<TemplateDim> accountOptional = template.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findFirst();
        if (!accountOptional.isPresent()) {
            return;
        }
        TemplateDim accountTemDim = accountOptional.get();
        Dimension subjectDim = this.system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        List<DimMember> subjectMemberList = subjectDim.getAllDimMemberList();
        List<Long> subjectScope = accountTemDim.getMemberScope();
        List accountMemberList = subjectMemberList.stream().filter(item -> subjectScope.contains(item.getId())).map(item -> (AccountMember)item).collect(Collectors.toList());
        ReportCalcModel templateModel = reportModel.getTemplateModel();
        ReportCalcTree rowTree = reportModel.getTemplateModel().getRowTree();
        if (accountTypeTemDim.getLocation() == DimLocation.ROW && accountTemDim.getLocation() == DimLocation.ROW) {
            List<ReportCalcVal> rowDimValList = templateModel.getRowDimValList();
            for (DimMember dimMember : accountTypeMemberList) {
                Optional<ReportCalcVal> currFlowRowOptional = rowDimValList.stream().filter(item -> item.getValue() != null && item.getValue().equals(dimMember.getId())).findFirst();
                if (!currFlowRowOptional.isPresent()) continue;
                ReportCalcVal currFlowCalcVal = currFlowRowOptional.get();
                List currFlowAccountIdS = accountMemberList.stream().filter(item -> item.getFlowType().getNumber().equals(dimMember.getNumber())).map(DimMember::getId).collect(Collectors.toList());
                List currFlowNoSubjectList = rowDimValList.stream().filter(item -> item.getRow() >= currFlowCalcVal.getRow() && item.getRow() <= currFlowCalcVal.getEndRow() && item.getCol() == accountTemDim.getLevel() - 1 && !currFlowAccountIdS.contains(item.getValue()) && !item.isSummary()).collect(Collectors.toList());
                rowDimValList.removeAll(currFlowNoSubjectList);
                Optional<ReportCalcValTreeNode> flowNodeOptional = rowTree.getRoot().getChildren().stream().filter(reportCalcValTreeNode -> reportCalcValTreeNode.getValue().equals(dimMember.getId())).findFirst();
                if (!flowNodeOptional.isPresent()) continue;
                ReportCalcValTreeNode flowNode = flowNodeOptional.get();
                flowNode.getChildren().removeIf(node -> !currFlowAccountIdS.contains((Long)node.getValue()) && !node.isSummary());
            }
            rowTree.refreshTree();
            List flowCalcList = rowDimValList.stream().filter(item -> item.getCol() == 0).sorted(Comparator.comparingInt(ReportCalcVal::getRow)).collect(Collectors.toList());
            for (int i = 0; i < flowCalcList.size(); ++i) {
                Object lastData;
                ReportCalcVal reportCalcVal = (ReportCalcVal)flowCalcList.get(i);
                List currFlowSubjectList = rowDimValList.stream().filter(item -> item.getRow() >= reportCalcVal.getRow() && item.getRow() <= reportCalcVal.getEndRow() && item.getCol() == accountTemDim.getLevel() - 1).sorted(Comparator.comparingInt(ReportCalcVal::getRow)).collect(Collectors.toList());
                int rowStart = reportCalcVal.getRow();
                if (i != 0) {
                    lastData = (ReportCalcVal)flowCalcList.get(i - 1);
                    rowStart = ((ReportCalcVal)lastData).getEndRow() + 1;
                }
                for (ReportCalcVal subjectReportCalcVal : currFlowSubjectList) {
                    subjectReportCalcVal.setRow(rowStart++);
                }
                reportCalcVal.setRowSpan(currFlowSubjectList.size());
                if (i == 0) continue;
                lastData = (ReportCalcVal)flowCalcList.get(i - 1);
                reportCalcVal.setRow(((ReportCalcVal)lastData).getEndRow() + 1);
            }
        }
    }
}

