/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.model;

import java.util.Deque;
import java.util.LinkedList;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperatorSymbol;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.enums.FormulaSymbolEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.util.CellReference;

public class FormulaInfo {
    private Formula formula;
    private ReportCalcVal leftCalcVal;

    public FormulaInfo(ReportCalcVal leftCalcVal) {
        this.leftCalcVal = leftCalcVal;
        this.formula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(new CellReference(leftCalcVal.getRow(), leftCalcVal.getCol()).formatAsString());
        this.formula.setLeftVal(leftOperationVal);
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        this.formula.setOperator(operator);
    }

    public FormulaInfo add(ReportCalcVal reportCalcVal, FormulaSymbolEnum formulaSymbolEnum) {
        String excelPost = new CellReference(reportCalcVal.getRow(), reportCalcVal.getCol()).formatAsString();
        FormulaOperationVal rightVal = new FormulaOperationVal();
        rightVal.setName(excelPost);
        if (reportCalcVal.getValue() != null) {
            rightVal.setValue(reportCalcVal.getValue().toString());
        }
        Deque<IFormulaOperator> operator = this.formula.getOperator();
        operator.add(rightVal);
        FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(formulaSymbolEnum);
        operator.add(addSymbol);
        return this;
    }

    public FormulaInfo add(FormulaSymbolEnum formulaSymbolEnum) {
        Deque<IFormulaOperator> operator = this.formula.getOperator();
        operator.add(new FormulaOperatorSymbol(formulaSymbolEnum));
        return this;
    }

    public void end() {
        Deque<IFormulaOperator> operator = this.formula.getOperator();
        if (CollectionUtils.isNotEmpty(operator)) {
            operator.removeLast();
        }
        this.leftCalcVal.setFormula(this.formula);
    }
}

