/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.service;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.index.generate.DimensionIndexMapGenerator;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.spread.generator.actions.service.IReportDataToCalcValStrategy;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.SpecialColorEnum;
import org.apache.commons.collections.CollectionUtils;

public class AdjustFixReportDataToCalcValStrategy
implements IReportDataToCalcValStrategy {
    private FundPlanSystem system;
    private ReportDataSource report;
    private boolean isInit;

    public AdjustFixReportDataToCalcValStrategy(FundPlanSystem system, ReportDataSource report) {
        this.system = system;
        this.report = report;
        this.setInitFlag();
    }

    private void setInitFlag() {
        if (!Report.class.isInstance(this.report)) {
            return;
        }
        if (PlanChangeReport.class.isInstance(this.report)) {
            this.isInit = true;
            return;
        }
        Report report$ = (Report)this.report;
        this.isInit = report$.getInitFlag();
    }

    @Override
    public void transfer(ReportDataSource report, ReportCalcModel reportCalcModel) {
        Map<Long, ReportData> reportDataMapping = report.getReportDataList().stream().filter(Objects::nonNull).collect(Collectors.toMap(ReportData::getId, o -> o, (a, b) -> a));
        ReportDataIndexQueryMap<Long> bmpMap = DimensionIndexMapGenerator.build(report.getReportDataList());
        DimensionIndexTree indexTree = report.getIndexTree(this.system);
        reportCalcModel.setIndexTree(indexTree);
        List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
        List<ReportCalcVal> colDimValList = reportCalcModel.getColDimValList();
        Map<Integer, Object> colAndMetricMap = colDimValList.stream().filter(ReportCalcVal::isMetric).collect(Collectors.toMap(ReportCalcVal::getCol, ReportCalcVal::getValue));
        Dimension metricDimension = this.system.getMainDimensionByDimType(DimensionType.METRIC);
        Map metricMemberMap = metricDimension.getAllDimMemberList().stream().map(MetricMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        for (ReportCalcVal reportCalcVal : dataValList) {
            DimensionInfoBean dimensionInfoBean;
            if (reportCalcVal.isSummary()) continue;
            if (reportCalcVal.isDataCell()) {
                ReportValueType valueType;
                ReportData reportData;
                dimensionInfoBean = reportCalcModel.getDimensionInfo(reportCalcVal.getCol(), reportCalcVal.getRow());
                TreeNode treeNode = indexTree.find(dimensionInfoBean);
                if (treeNode == null) continue;
                List currReportDataList = treeNode.getDataList() == null ? Collections.emptyList() : treeNode.getDataList().stream().filter(o -> o instanceof ReportData).map(o -> (ReportData)o).collect(Collectors.toList());
                ReportData reportData2 = reportData = CollectionUtils.isEmpty(currReportDataList) ? null : (ReportData)currReportDataList.get(0);
                if (reportData != null) {
                    Long metricId = (Long)colAndMetricMap.get(reportCalcVal.getCol());
                    BigDecimal amtVal = EmptyUtil.isEmpty((Long)metricId) ? reportData.getPlanAmt() : reportData.getBigDecimalValueByMetric(metricId);
                    MetricMember metricMember = (MetricMember)metricMemberMap.get(metricId);
                    if (EmptyUtil.isNoEmpty((Object)metricMember) && metricMember.getTemplateMetricType() == TemplateMetricType.REPORTPLANAMT) {
                        reportCalcVal.setSpecialColor(SpecialColorEnum.APPROVED_COLOR);
                    }
                    reportCalcVal.setValue(amtVal);
                    if (report instanceof SumPlanReport) {
                        reportCalcVal.setDataId(reportData.getSourceIdList());
                    } else {
                        reportCalcVal.setDataId(reportData.getId());
                    }
                    reportCalcVal.setDisplayVal(amtVal == null ? "" : amtVal.toString());
                    if (!(report instanceof Report && ((Report)report).getInitFlag().booleanValue() || report instanceof PlanChangeReport)) {
                        reportData.setCol(reportCalcVal.getCol());
                        reportData.setRow(reportCalcVal.getRow());
                    }
                }
                valueType = (valueType = reportCalcVal.getValueType()) == null ? new ReportValueType() : valueType;
                valueType.setReportCellType(ReportCellType.AMOUNT);
                reportCalcVal.setValueType(valueType);
                reportCalcVal.setDataCell(true);
                treeNode.addData(reportCalcVal);
                continue;
            }
            if (!reportCalcVal.isRemarkCell()) continue;
            dimensionInfoBean = reportCalcModel.getFixedTemplateDimensionInfo(reportCalcVal.getCol(), reportCalcVal.getRow());
            Long reportDataId = bmpMap.find(dimensionInfoBean);
            ReportData reportData = reportDataMapping.get(reportDataId);
            Consumer<ReportData> setValueCallBack = this.getSetValueCallBack(reportCalcVal);
            if (!EmptyUtil.isNoEmpty((Object)reportData)) continue;
            setValueCallBack.accept(reportData);
        }
    }

    private Consumer<ReportData> getSetValueCallBack(ReportCalcVal reportCalcVal) {
        return reportData -> {
            if (!this.isInit) {
                reportData.setCol(reportCalcVal.getCol());
                reportData.setRow(reportCalcVal.getRow());
            }
            this.setRemarkCell(reportCalcVal, (ReportData)reportData);
        };
    }

    private void setRemarkCell(ReportCalcVal reportCalcVal, ReportData reportData) {
        if (!reportCalcVal.isRemarkCell()) {
            return;
        }
        String remark = reportData.getAuxiliaryVal(reportCalcVal.getDimensionId());
        reportCalcVal.setDisplayVal(remark);
        reportCalcVal.setValue(remark);
        reportCalcVal.setDataId(reportData.getId());
        ReportValueType valueType = reportCalcVal.getValueType();
        valueType = valueType == null ? new ReportValueType() : valueType;
        valueType.setReportCellType(ReportCellType.TEXT);
        reportCalcVal.setValueType(valueType);
    }
}

