/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.actions.service;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AuxiliaryFieldsUseType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.index.generate.DimensionIndexTreeGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.WarpBean;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategyFactory;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.template.AuxiliaryField;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.spread.generator.actions.service.IReportDataToCalcValStrategy;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import org.apache.commons.collections.CollectionUtils;

public class FixReportDataToCalcValSplitStrategy
implements IReportDataToCalcValStrategy {
    private FundPlanSystem system;
    private Map<Long, AuxiliaryField> auxiliaryFieldMap;

    public FixReportDataToCalcValSplitStrategy(FundPlanSystem system) {
        this.system = system;
        this.auxiliaryFieldMap = system.getAuxiliaryFieldList().stream().collect(Collectors.toMap(AuxiliaryField::getId, v -> v, (k1, k2) -> k1));
    }

    @Override
    public void transfer(ReportDataSource report, ReportCalcModel reportCalcModel) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(FixReportDataToCalcValSplitStrategy.class.getSimpleName());){
            span.addTag("generate index");
            List warpBeanList = report.getReportDataList().stream().map(item -> {
                DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(item);
                return new WarpBean<String, ReportData>(UUID.randomUUID().toString(), dimensionInfoBean, (ReportData)item);
            }).collect(Collectors.toList());
            QueryIndexInfo queryIndexInfo = QueryIndexInfoMapGenerator.build(warpBeanList, this.system, ReportData::isAuxiliaryInfo);
            ReportDataIndexQueryMap<String> remarkIndexQueryMap = queryIndexInfo.getIndexQueryMap();
            Map<String, ReportData> remarkDataMap = queryIndexInfo.getDataMap();
            span.addTag("generate indexTree");
            IndexTreeGenerateStrategy strategy = IndexTreeGenerateStrategyFactory.createReportDataStrategy(report, this.system);
            DimensionIndexTreeGenerator generator = new DimensionIndexTreeGenerator(strategy);
            DimensionIndexTree indexTree = generator.build();
            List<ReportData> mountReportDataList = report.getReportDataList().stream().filter(o -> !o.isAuxiliaryInfo()).collect(Collectors.toList());
            ReportHelper.mountReportData(indexTree, mountReportDataList);
            reportCalcModel.setIndexTree(indexTree);
            List<ReportCalcVal> dataValList = reportCalcModel.getDataValList();
            span.addTag("init data cell");
            for (ReportCalcVal reportCalcVal : dataValList) {
                ReportData reportData;
                if (reportCalcVal.isSummary()) continue;
                if (reportCalcVal.isDataCell()) {
                    ReportData reportData2;
                    DimensionInfoBean dimensionInfoBean = reportCalcModel.getDimensionInfo(reportCalcVal.getCol(), reportCalcVal.getRow());
                    TreeNode treeNode = indexTree.find(dimensionInfoBean);
                    if (treeNode == null) continue;
                    List currReportDataList = treeNode.getDataList() == null ? Collections.emptyList() : treeNode.getDataList().stream().filter(o -> o instanceof ReportData).map(o -> (ReportData)o).collect(Collectors.toList());
                    ReportData reportData3 = reportData2 = CollectionUtils.isEmpty(currReportDataList) ? null : (ReportData)currReportDataList.get(0);
                    if (reportData2 != null) {
                        BigDecimal amtVal = reportData2.getBigDecimalValue();
                        reportCalcVal.setValue(amtVal);
                        if (report instanceof SumPlanReport) {
                            reportCalcVal.setDataId(reportData2.getSourceIdList());
                        } else {
                            reportCalcVal.setDataId(reportData2.getId());
                        }
                        reportCalcVal.setSourceIdList(reportData2.getSourceIdList());
                        reportCalcVal.setDisplayVal(amtVal == null ? "" : amtVal.toString());
                        if (!(report instanceof Report && ((Report)report).getInitFlag().booleanValue() || report instanceof PlanChangeReport)) {
                            reportData2.setCol(reportCalcVal.getCol());
                            reportData2.setRow(reportCalcVal.getRow());
                        }
                    }
                    if (reportCalcVal.getValueType() == null) {
                        ReportValueType reportValueType = new ReportValueType();
                        reportValueType.setReportCellType(ReportCellType.AMOUNT);
                        reportCalcVal.setValueType(reportValueType);
                    }
                    reportCalcVal.setDataCell(true);
                    treeNode.addData(reportCalcVal);
                    continue;
                }
                if (!reportCalcVal.isRemarkCell() || (reportData = this.findAuxiliaryValue(reportCalcModel, reportCalcVal, remarkIndexQueryMap, remarkDataMap, report)) == null) continue;
                String remark = reportData.getAuxiliaryVal(reportCalcVal.getDimensionId());
                reportCalcVal.setDisplayVal(remark);
                reportCalcVal.setValue(remark);
                if (!(report instanceof Report) || !((Report)report).getInitFlag().booleanValue()) {
                    reportData.setCol(reportCalcVal.getCol());
                    reportData.setRow(reportCalcVal.getRow());
                }
                reportCalcVal.setDataId(reportData.getId());
                ReportValueType valueType = reportCalcVal.getValueType();
                valueType = valueType == null ? new ReportValueType() : valueType;
                valueType.setReportCellType(ReportCellType.TEXT);
                reportCalcVal.setValueType(valueType);
            }
        }
    }

    private ReportData findAuxiliaryValue(ReportCalcModel reportCalcModel, ReportCalcVal reportCalcVal, ReportDataIndexQueryMap<String> remarkIndexQueryMap, Map<String, ReportData> remarkDataMap, ReportDataSource report) {
        PeriodMember referencePeriodMember;
        DimensionInfoBean dimensionInfoBean = reportCalcModel.getDimensionInfo(reportCalcVal.getCol(), reportCalcVal.getRow());
        List<String> list = remarkIndexQueryMap.findList(dimensionInfoBean);
        if (EmptyUtil.isEmpty(list)) {
            return null;
        }
        List reportDataList = list.stream().map(remarkDataMap::get).collect(Collectors.toList());
        ReportData reportData = null;
        Long dimensionId = reportCalcVal.getDimensionId();
        AuxiliaryField auxiliaryField = this.auxiliaryFieldMap.get(dimensionId);
        PeriodMember periodMember = report.getPeriodMemberList().get(0);
        Predicate<ReportData> predicate = auxiliaryField != null && auxiliaryField.getUseType() == AuxiliaryFieldsUseType.EXEC_DEVIATION_ANALYSIS ? ((referencePeriodMember = ((Report)report).getReferencePeriodMember()) == null ? r -> r.getReportPeriodId().equals(periodMember.getId()) : r -> r.getReportPeriodId().equals(referencePeriodMember.getId())) : r -> r.getReportPeriodId().equals(periodMember.getId());
        Optional<ReportData> find = reportDataList.stream().filter(predicate).findFirst();
        if (find.isPresent()) {
            reportData = find.get();
        }
        return reportData;
    }
}

