/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.executor.impl;

import java.util.ArrayList;
import java.util.List;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.AdjustReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.PlanChangeFormulaAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.PlanChangeFormulaProcessV3Action;
import kd.tmc.fpm.business.spread.generator.actions.impl.PlanChangeSpecialAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportStructBuildAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportTemplateBuildV2Action;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportTplVimDimBuildV2Action;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;

public class AdjustReportPlanExecutor
implements IReportDataProcessExecutor {
    private List<IReportDataProcessAction> actionList;

    public AdjustReportPlanExecutor(FundPlanSystem system, ReportDataSource report) {
        this.initActions(system, report, null);
    }

    public AdjustReportPlanExecutor(FundPlanSystem system, ReportDataSource report, List<Long> pageDimS) {
        this.initActions(system, report, pageDimS);
    }

    private void initActions(FundPlanSystem system, ReportDataSource report, List<Long> pageDimS) {
        this.actionList = new ArrayList<IReportDataProcessAction>(5);
        this.actionList.add(new ReportTemplateBuildV2Action(system, report));
        this.actionList.add(new ReportTplVimDimBuildV2Action(system, report));
        if (pageDimS == null) {
            this.actionList.add(new ReportStructBuildAction(system, report));
        } else if (pageDimS != null) {
            this.actionList.add(new ReportStructBuildAction(system, report, pageDimS));
        }
        this.actionList.add(new AdjustReportDataProcessAction(system, report));
        this.actionList.add(new PlanChangeFormulaProcessV3Action(system, report));
        this.actionList.add(new PlanChangeFormulaAction(system, report));
        this.actionList.add(new PlanChangeSpecialAction(system, report));
    }

    @Override
    public void executeAction(ReportModel reportModel) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(this.getClass().getName());){
            for (IReportDataProcessAction iReportDataProcessAction : this.actionList) {
                span.addTag(String.format("%s_Action", iReportDataProcessAction.getClass().getName()));
                iReportDataProcessAction.execute(reportModel);
            }
        }
    }
}

