/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.executor.impl;

import java.util.ArrayList;
import java.util.List;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.service.result.PeriodStartBalance;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.FundPosFormsExportAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.PositionAnalysisBuildAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.PositionFormulaProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportDataDefaultProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportDataProcessFixAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportStructBuildAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportTemplateBuildV2Action;
import kd.tmc.fpm.business.spread.generator.actions.impl.SubjectFlowBuildAction;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;

public class AnalysisReportPositionExecutorOfExport
implements IReportDataProcessExecutor {
    private List<IReportDataProcessAction> actionList;

    public AnalysisReportPositionExecutorOfExport(FundPlanSystem system, ReportDataSource report, PeriodStartBalance balanceResult, AnalysisHeader headerInfo) {
        this.initActions(system, report, balanceResult, headerInfo);
    }

    private void initActions(FundPlanSystem system, ReportDataSource report, PeriodStartBalance balanceResult, AnalysisHeader headerInfo) {
        this.actionList = new ArrayList<IReportDataProcessAction>(7);
        this.actionList.add(new ReportTemplateBuildV2Action(system, report));
        this.actionList.add(new SubjectFlowBuildAction(system, report));
        this.actionList.add(new ReportStructBuildAction(system, report));
        this.actionList.add(new ReportDataProcessFixAction(system, report));
        this.actionList.add(new FundPosFormsExportAction(headerInfo, system));
        this.actionList.add(new PositionFormulaProcessAction(system, report));
        this.actionList.add(new PositionAnalysisBuildAction(system, balanceResult));
        this.actionList.add(new ReportDataDefaultProcessAction());
    }

    @Override
    public void executeAction(ReportModel reportModel) {
        for (IReportDataProcessAction iReportDataProcessAction : this.actionList) {
            iReportDataProcessAction.execute(reportModel);
        }
    }
}

