/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.executor.impl;

import java.util.ArrayList;
import java.util.List;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;

public class ReportBaseExecutor
implements IReportDataProcessExecutor {
    private List<IReportDataProcessAction> actionList = new ArrayList<IReportDataProcessAction>();

    public void setActionList(List<IReportDataProcessAction> actionList) {
        this.actionList = actionList;
    }

    @Override
    public void executeAction(ReportModel reportModel) {
        for (IReportDataProcessAction action : this.actionList) {
            action.execute(reportModel);
        }
    }

    public static class ExecutorBuilder {
        private List<IReportDataProcessAction> actionList = new ArrayList<IReportDataProcessAction>();

        public ExecutorBuilder addAction(IReportDataProcessAction action) {
            this.actionList.add(action);
            return this;
        }

        public ReportBaseExecutor build() {
            ReportBaseExecutor baseExecutor = new ReportBaseExecutor();
            baseExecutor.setActionList(this.actionList);
            return baseExecutor;
        }
    }
}

