/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.executor.impl;

import java.util.ArrayList;
import java.util.List;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.DetailReportFormulaProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.DetailTotalRowBuildAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.PeriodStartEndSummaryFormulaDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportDataProcessV2Action;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportStructBuildAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportTemplateBuildV2Action;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;

public class ReportPlanExecutorOfExport
implements IReportDataProcessExecutor {
    private List<IReportDataProcessAction> actionList;

    public ReportPlanExecutorOfExport(FundPlanSystem system, ReportDataSource report) {
        this.initActions(system, report);
    }

    private void initActions(FundPlanSystem system, ReportDataSource report) {
        this.actionList = new ArrayList<IReportDataProcessAction>(5);
        this.actionList.add(new ReportTemplateBuildV2Action(system, report));
        this.actionList.add(new ReportStructBuildAction(system, report));
        this.actionList.add(new DetailTotalRowBuildAction(system, report));
        this.actionList.add(new ReportDataProcessV2Action(system, report, true));
        this.actionList.add(this.getFormulaProcessAction(system, report));
    }

    @Override
    public void executeAction(ReportModel reportModel) {
        for (IReportDataProcessAction iReportDataProcessAction : this.actionList) {
            iReportDataProcessAction.execute(reportModel);
        }
    }

    private IReportDataProcessAction getFormulaProcessAction(FundPlanSystem system, ReportDataSource report) {
        TemplateType templateType = report.getTemplate().getTemplateType();
        if (templateType == TemplateType.DETAIL) {
            return new DetailReportFormulaProcessAction(system, report);
        }
        return new PeriodStartEndSummaryFormulaDataProcessAction(system, report);
    }
}

