/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.executor.impl;

import java.util.ArrayList;
import java.util.List;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.spread.generator.actions.IReportDataProcessAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.DetailTotalRowBuildAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ExportTemplateBuildAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.FormulaProcessV3Action;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportDataProcessV2Action;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportDataRowResetAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportFormHeaderImportAction;
import kd.tmc.fpm.business.spread.generator.actions.impl.ReportStructSplitBuildAction;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;

public class ReportTemplExecutorOfExport
implements IReportDataProcessExecutor {
    private List<IReportDataProcessAction> actionList;

    public ReportTemplExecutorOfExport(FundPlanSystem system, ReportDataSource report) {
        this.initActions(system, report);
    }

    private void initActions(FundPlanSystem system, ReportDataSource report) {
        this.actionList = new ArrayList<IReportDataProcessAction>(5);
        this.actionList.add(new ExportTemplateBuildAction(system, report));
        this.actionList.add(new ReportStructSplitBuildAction(system, report));
        this.actionList.add(new DetailTotalRowBuildAction(system, report));
        this.actionList.add(new ReportDataRowResetAction(report));
        this.actionList.add(new ReportDataProcessV2Action(system, report, true));
        this.actionList.add(new ReportFormHeaderImportAction(system, report));
        this.actionList.add(new FormulaProcessV3Action(system, report));
    }

    @Override
    public void executeAction(ReportModel reportModel) {
        for (IReportDataProcessAction iReportDataProcessAction : this.actionList) {
            iReportDataProcessAction.execute(reportModel);
        }
    }
}

