/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.report;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.spread.generator.report.IReportSpreadDataGenerator;
import kd.tmc.fpm.business.spread.generator.report.cell.CellDataConvterFactory;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;

public class ReportSpreadDataGenerator
implements IReportSpreadDataGenerator {
    @Override
    public Book generate(final ReportCalcModel reportCalcModel) {
        Sheet sheet = new Sheet();
        Optional<ReportCalcVal> rowEndInxOp = reportCalcModel.getColDimValList().stream().max(Comparator.comparing(ReportCalcVal::getRow));
        Optional<ReportCalcVal> colEndInxOp = reportCalcModel.getRowDimValList().stream().max(Comparator.comparing(ReportCalcVal::getCol));
        sheet.setColEndInx(colEndInxOp.map(o -> o.getCol() + 1).orElseGet(() -> 0).intValue());
        sheet.setRowEndInx(rowEndInxOp.map(o -> o.getRow() + 1).orElseGet(() -> 0).intValue());
        this.frozenTotalRowIfNeed(sheet, reportCalcModel);
        ArrayList<Cell> cells = new ArrayList<Cell>(10){
            {
                super(x0);
                this.addAll(ReportSpreadDataGenerator.this.converToCell(reportCalcModel.getColDimValList(), CellDimTypeEnum.COLDIMS));
                this.addAll(ReportSpreadDataGenerator.this.converToCell(reportCalcModel.getRowDimValList(), CellDimTypeEnum.ROWDIMS));
                this.addAll(ReportSpreadDataGenerator.this.converToCell(reportCalcModel.getDataValList(), CellDimTypeEnum.DATADIMS));
                this.addAll(ReportSpreadDataGenerator.this.converToCell(reportCalcModel.getExtValList(), CellDimTypeEnum.EXTDIMS));
            }
        };
        sheet.setCellList((List)cells);
        return new Book(sheet);
    }

    @Override
    public List<Cell> generate(List<ReportCalcVal> reportCalcVals) {
        return this.converToCell(reportCalcVals, CellDimTypeEnum.DATADIMS);
    }

    private List<Cell> converToCell(List<ReportCalcVal> reportCalcValCol, CellDimTypeEnum cellDimType) {
        if (reportCalcValCol == null || reportCalcValCol.size() == 0) {
            return new ArrayList<Cell>(0);
        }
        List<Cell> cells = reportCalcValCol.stream().filter(Objects::nonNull).map(calcVal -> this.converToCell((ReportCalcVal)calcVal, cellDimType)).collect(Collectors.toList());
        return cells;
    }

    private Cell converToCell(ReportCalcVal reportCalcVal, CellDimTypeEnum cellDimType) {
        if (null == reportCalcVal) {
            return null;
        }
        ReportCellType type = reportCalcVal.getValueType().getReportCellType();
        return CellDataConvterFactory.createCellConvter(type, reportCalcVal, cellDimType).convter();
    }

    private void frozenTotalRowIfNeed(Sheet sheet, ReportCalcModel reportCalcModel) {
        if (Objects.isNull(reportCalcModel.getRowTree())) {
            OptionalInt totalRowInxOpt = reportCalcModel.getDataValList().stream().filter(ReportCalcVal::isTotalSummary).mapToInt(ReportCalcVal::getRow).map(row -> row + 1).max();
            int rowEndInx = totalRowInxOpt.orElseGet(() -> ((Sheet)sheet).getRowEndInx());
            sheet.setRowEndInx(rowEndInx);
        }
    }
}

