/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.report.cell;

import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.spread.generator.AuxiliaryCellStyleConvert;
import kd.tmc.fpm.business.spread.generator.AuxiliaryCellStyleInfo;
import kd.tmc.fpm.business.spread.generator.report.cell.ICellDisplayTypeStyleDeal;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.spread.widget.DisplayTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;

public abstract class AbsCellConvterStrategy
implements ICellDisplayTypeStyleDeal {
    private ReportCalcVal calcVal;
    private CellDimTypeEnum cellDimType;
    private CellStyleInfo styleInfo;
    private Cell cell;

    public Cell convter() {
        this.cell = new Cell();
        if (!EmptyUtil.isEmpty((Object)this.calcVal.getDataId())) {
            this.cell.setDataId(this.calcVal.getDataId());
        }
        this.cell.setRow(this.calcVal.getRow());
        this.cell.setCol(this.calcVal.getCol());
        this.cell.setRowSpan(this.calcVal.getRowSpan());
        this.cell.setColSpan(this.calcVal.getColSpan());
        this.cell.setLevel(this.calcVal.getLevel());
        this.cell.setLock(Boolean.valueOf(!this.calcVal.isEnable()));
        this.cell.setFormula(this.calcVal.getExcelFormula());
        this.cell.setDisplayType(this.calcVal.getDisplayType());
        this.cell.setSummary(this.calcVal.isSummary());
        this.cell.setCellDimType(this.cellDimType);
        this.cell.setInitDirty(this.calcVal.isDirty());
        this.cell.setSourceIdList(this.calcVal.getSourceIdList());
        AuxiliaryCellStyleInfo auxiliaryCellStyleInfo = new AuxiliaryCellStyleConvert().toAuxiliaryCellStyle(this.calcVal, this.cellDimType);
        this.cell.setCellStyleMark(auxiliaryCellStyleInfo.toCellStyleMark());
        this.setFeatureVal(this.cell, this.calcVal);
        Object displayVal = this.dealValue(this.calcVal.getDisplayVal());
        if (this.cellDimType == CellDimTypeEnum.COLDIMS || this.cellDimType == CellDimTypeEnum.ROWDIMS || this.cellDimType == CellDimTypeEnum.EXTDIMS && this.cell.isLock().booleanValue()) {
            StringBuilder stringBuilder = new StringBuilder("   %s   ");
            for (int i = 0; i < this.cell.getLevel(); ++i) {
                stringBuilder.insert(0, "       ");
            }
            displayVal = String.format(stringBuilder.toString(), displayVal);
        }
        this.cell.setDisplayValue(displayVal);
        this.cell.setValue(this.calcVal.getValue());
        if (this.cell.getDisplayType() == DisplayTypeEnum.MUSTRECORD) {
            this.cell.setDisplayValue((Object)String.format("%s *", this.cell.getDisplayValue().toString().trim()));
        }
        this.styleInfo = auxiliaryCellStyleInfo.generateStyle();
        this.setCellStyle(this.cell, this.styleInfo, this.cellDimType);
        this.cell.setStyleInfo(this.styleInfo);
        return this.cell;
    }

    protected abstract void setFeatureVal(Cell var1, ReportCalcVal var2);

    protected Object dealValue(Object value) {
        return value;
    }

    protected void setCellStyle(Cell cell, CellStyleInfo cellStyle, CellDimTypeEnum cellDimType) {
    }

    private void setSpecialStyle(CellStyleInfo cellStyle, DisplayTypeEnum displayType) {
        if (displayType == null || DisplayTypeEnum.NORMAR == displayType) {
            this.normal(cellStyle);
        } else if (displayType != null && DisplayTypeEnum.WARNING == displayType) {
            this.warning(cellStyle);
        } else if (displayType != null && DisplayTypeEnum.ERROR == displayType) {
            this.error(cellStyle);
        } else if (displayType != null && DisplayTypeEnum.MUSTRECORD == displayType) {
            this.mustRecord(cellStyle);
        }
    }

    public AbsCellConvterStrategy(ReportCalcVal calcVal, CellDimTypeEnum cellDimType) {
        this.calcVal = calcVal;
        this.cellDimType = cellDimType;
        this.styleInfo = new CellStyleInfo();
    }

    private AbsCellConvterStrategy() {
    }
}

