/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.report.cell;

import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.spread.generator.report.cell.AbsCellConvterStrategy;
import kd.tmc.fpm.business.spread.generator.report.cell.strategy.AmountCellConvterStrategy;
import kd.tmc.fpm.business.spread.generator.report.cell.strategy.BasedataCellConvterStrategy;
import kd.tmc.fpm.business.spread.generator.report.cell.strategy.CommonDefaultCellConvterStrategy;
import kd.tmc.fpm.business.spread.generator.report.cell.strategy.DateCellConvterStrategy;
import kd.tmc.fpm.business.spread.generator.report.cell.strategy.DownBoxCellConvterStrategy;
import kd.tmc.fpm.business.spread.generator.report.cell.strategy.MutiBasedataCellConvterStrategy;
import kd.tmc.fpm.business.spread.generator.report.cell.strategy.PercentCellConvterStrategy;
import kd.tmc.fpm.business.spread.generator.report.cell.strategy.TextCellConvterStrategy;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;

public class CellDataConvterFactory {
    public static AbsCellConvterStrategy createCellConvter(ReportCellType type, ReportCalcVal reportCalcVal, CellDimTypeEnum cellDimType) {
        AbsCellConvterStrategy absCellConvter = null;
        absCellConvter = type == ReportCellType.AMOUNT ? CellDataConvterFactory.createAmountCellConvter(reportCalcVal, cellDimType) : (type == ReportCellType.BASE_DATA ? CellDataConvterFactory.createBasedataCellConvter(reportCalcVal, cellDimType) : (type == ReportCellType.MUTI_BASE_DATA ? CellDataConvterFactory.createMutiBasedataCellConvter(reportCalcVal, cellDimType) : (type == ReportCellType.DATE ? CellDataConvterFactory.createDateCellConvter(reportCalcVal, cellDimType) : (type == ReportCellType.ENUM ? CellDataConvterFactory.createDownBoxCellConvter(reportCalcVal, cellDimType) : (type == ReportCellType.TEXT ? CellDataConvterFactory.createTextCellConvter(reportCalcVal, cellDimType) : (type == ReportCellType.PERCENT ? CellDataConvterFactory.createPercentCellConvter(reportCalcVal, cellDimType) : CellDataConvterFactory.createCommonDefaultCellConvter(reportCalcVal, cellDimType)))))));
        return absCellConvter;
    }

    public static AbsCellConvterStrategy createAmountCellConvter(ReportCalcVal reportCalcVal, CellDimTypeEnum cellDimType) {
        return new AmountCellConvterStrategy(reportCalcVal, cellDimType);
    }

    public static AbsCellConvterStrategy createBasedataCellConvter(ReportCalcVal reportCalcVal, CellDimTypeEnum cellDimType) {
        return new BasedataCellConvterStrategy(reportCalcVal, cellDimType);
    }

    public static AbsCellConvterStrategy createMutiBasedataCellConvter(ReportCalcVal reportCalcVal, CellDimTypeEnum cellDimType) {
        return new MutiBasedataCellConvterStrategy(reportCalcVal, cellDimType);
    }

    public static AbsCellConvterStrategy createDateCellConvter(ReportCalcVal reportCalcVal, CellDimTypeEnum cellDimType) {
        return new DateCellConvterStrategy(reportCalcVal, cellDimType);
    }

    public static AbsCellConvterStrategy createDownBoxCellConvter(ReportCalcVal reportCalcVal, CellDimTypeEnum cellDimType) {
        return new DownBoxCellConvterStrategy(reportCalcVal, cellDimType);
    }

    public static AbsCellConvterStrategy createTextCellConvter(ReportCalcVal reportCalcVal, CellDimTypeEnum cellDimType) {
        return new TextCellConvterStrategy(reportCalcVal, cellDimType);
    }

    public static AbsCellConvterStrategy createCommonDefaultCellConvter(ReportCalcVal reportCalcVal, CellDimTypeEnum cellDimType) {
        return new CommonDefaultCellConvterStrategy(reportCalcVal, cellDimType);
    }

    public static AbsCellConvterStrategy createPercentCellConvter(ReportCalcVal reportCalcVal, CellDimTypeEnum cellDimType) {
        return new PercentCellConvterStrategy(reportCalcVal, cellDimType);
    }
}

