/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.report.cell.strategy;

import java.util.Date;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.spread.generator.report.cell.AbsCellConvterStrategy;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;
import kd.tmc.fpm.spread.widget.style.HorizontalAlignEnum;

public class DateCellConvterStrategy
extends AbsCellConvterStrategy {
    private static final String FM_LONGDATE = "yyyy/MM/dd HH:mm:ss";
    private static final String FM_SHROTDATE = "yyyy/MM/dd";

    public DateCellConvterStrategy(ReportCalcVal calcVal, CellDimTypeEnum cellDimType) {
        super(calcVal, cellDimType);
    }

    @Override
    protected void setFeatureVal(Cell cell, ReportCalcVal calcVal) {
        cell.setCellType(CellTypeEnum.DATE);
        cell.setWidgetValue(null);
    }

    @Override
    protected Object dealValue(Object value) {
        String pattern = FM_SHROTDATE;
        if (value == null || value.toString().trim().isEmpty()) {
            value = "";
        } else {
            Date date = new Date(Long.parseLong(value.toString()));
            value = DateUtils.formatString((Date)date, (String)pattern);
        }
        return value;
    }

    @Override
    protected void setCellStyle(Cell cell, CellStyleInfo cellStyle, CellDimTypeEnum cellDimType) {
        super.setCellStyle(cell, cellStyle, cellDimType);
        cellStyle.setHa(HorizontalAlignEnum.Center);
        cellStyle.setFm(FM_SHROTDATE);
    }
}

