/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.generator.report.cell.strategy;

import java.math.BigDecimal;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.spread.generator.report.cell.AbsCellConvterStrategy;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;
import kd.tmc.fpm.spread.widget.style.HorizontalAlignEnum;

public class PercentCellConvterStrategy
extends AbsCellConvterStrategy {
    public PercentCellConvterStrategy(ReportCalcVal calcVal, CellDimTypeEnum cellDimType) {
        super(calcVal, cellDimType);
    }

    @Override
    protected void setFeatureVal(Cell cell, ReportCalcVal calcVal) {
        cell.setCellType(CellTypeEnum.PERCENT);
        cell.setWidgetValue(null);
        String value = calcVal.getDisplayVal();
        if (value != null && !value.trim().isEmpty() && BigDecimal.ONE.compareTo(new BigDecimal(value)) < 0) {
            CellStyleInfo tStyleInfo = cell.getStyleInfo();
            if (tStyleInfo == null) {
                tStyleInfo = new CellStyleInfo();
            }
            tStyleInfo.setFrc("#FF0000");
            cell.setStyleInfo(tStyleInfo);
        }
    }

    @Override
    protected Object dealValue(Object value) {
        value = value == null || value.toString().trim().isEmpty() ? "" : new BigDecimal(value.toString()).stripTrailingZeros();
        return value;
    }

    @Override
    protected void setCellStyle(Cell cell, CellStyleInfo cellStyle, CellDimTypeEnum cellDimType) {
        super.setCellStyle(cell, cellStyle, cellDimType);
        cellStyle.setHa(HorizontalAlignEnum.RIGHT);
        cellStyle.setFm("#,##0.00%");
        CellStyleInfo tStyleInfo = cell.getStyleInfo();
        if (tStyleInfo != null) {
            cellStyle.setFrc(tStyleInfo.getFrc());
        }
    }
}

