/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.update;

import kd.bos.dataentity.Tuple;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.spread.update.ICellSpecialStyle;
import kd.tmc.fpm.business.spread.update.ICellUpdate;
import kd.tmc.fpm.business.spread.update.bean.CellUpdateResult;
import kd.tmc.fpm.spread.command.event.CellValueEvent;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;
import kd.tmc.fpm.spread.widget.style.VerticalAlignEnum;

public abstract class AbsCellValueUpdate
implements ICellSpecialStyle,
ICellUpdate {
    protected static final Tuple<Boolean, String> CHECK_NOTCLEAR_MSG = Tuple.create((Object)Boolean.FALSE, null);
    private CellValueEvent event;
    private Cell originCell;

    public AbsCellValueUpdate(CellValueEvent event, Cell originCell) {
        this.event = event;
        this.originCell = originCell;
    }

    private AbsCellValueUpdate() {
    }

    @Override
    public CellUpdateResult update() throws Exception {
        CellStyleInfo csi;
        if (this.event == null || this.originCell == null) {
            return null;
        }
        CellUpdateResult cellUpdateResult = new CellUpdateResult();
        Tuple<Boolean, String> result = this.check(this.event, this.originCell.getCellType());
        cellUpdateResult.setClear((Boolean)result.item1);
        cellUpdateResult.setErrMsg((String)result.item2);
        cellUpdateResult.setSuccess(EmptyUtil.isEmpty((String)((String)result.item2)));
        Cell cell = new Cell();
        cell.setRowAndCol(this.event.getCell().getRow(), this.event.getCell().getCol());
        cell.setRowSpan(1);
        cell.setColSpan(1);
        if (!(this.originCell instanceof CacheCell)) {
            cell.setLock(this.originCell.isLock());
            cell.setCellType(this.originCell.getCellType());
            csi = this.originCell.getStyleInfo();
        } else {
            csi = new CellStyleInfo();
            cell.setLock(Boolean.valueOf(this.originCell.isSummary()));
        }
        this.custom(csi);
        if (cellUpdateResult.isClear()) {
            cell.setDisplayValue(null);
            cell.setValue(null);
            cell.setNewValue(null);
            this.error(csi);
        } else {
            this.normal(cell, csi);
            this.dealValue(cell, this.event.getNewValue());
        }
        if (EmptyUtil.isEmpty((Object)cell.getValue()) && cell.getValue() instanceof Number) {
            csi.setFrc("#999999");
        } else if (EmptyUtil.isNoEmpty((Object)cell.getValue()) && cell.getValue() instanceof Number) {
            csi.setFrc("#000000");
        }
        cell.setStyleInfo(csi);
        cellUpdateResult.setCell(cell);
        return cellUpdateResult;
    }

    @Override
    public void custom(CellStyleInfo cellStyle) {
        cellStyle.setVa(VerticalAlignEnum.Center);
    }

    protected abstract Tuple<Boolean, String> check(CellValueEvent var1, CellTypeEnum var2);

    protected abstract void dealValue(Cell var1, Object var2) throws Exception;

    public CellValueEvent getChangeEvent() {
        return this.event;
    }
}

