/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.update.strategy;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.spread.update.AbsCellValueUpdate;
import kd.tmc.fpm.spread.command.event.CellValueEvent;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;
import kd.tmc.fpm.spread.widget.style.HorizontalAlignEnum;

public class AmountCellValueUpdate
extends AbsCellValueUpdate {
    private static final String REGEXP_ISDIGITAL = "^-?[0-9]+(\\.[0-9]+)?$";
    private static final String REGEXP_SCIENTIFICCOUNT = "^-?[0-9]+(\\.[0-9]+)?([Ee][+-]?[0-9]+)?$";
    private static final String REGEXP_DIGITALRANGE = "^-?[0-9]{1,13}(\\.[0-9]{1,10})?$";
    private static final Integer DEFAULT_AMTPRECISION = 4;

    public AmountCellValueUpdate(CellValueEvent event, Cell originCell) {
        super(event, originCell);
    }

    @Override
    protected Tuple<Boolean, String> check(CellValueEvent event, CellTypeEnum cellType) {
        Object newValue = event.getNewValue();
        if (null == newValue || Objects.isNull(newValue)) {
            return CHECK_NOTCLEAR_MSG;
        }
        boolean scientificCheck = newValue.toString().matches(REGEXP_SCIENTIFICCOUNT);
        boolean fmResult = newValue.toString().matches(REGEXP_SCIENTIFICCOUNT);
        if (!fmResult) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5355\u5143\u683c%1$s\u4e3a%2$s\u7c7b\u578b\u5355\u5143\u683c\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u503c\u3002", (String)"AmountCellValueUpdate_0", (String)"tmc-fpm-business", (Object[])new Object[0]), ExcelUtils.xy2Pos((int)event.getCell().getCol(), (int)event.getCell().getRow()), cellType.getName());
            return Tuple.create((Object)Boolean.TRUE, (Object)errMsg);
        }
        if (!scientificCheck) {
            String errMsg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u79d1\u5b66\u8ba1\u6570\u6cd5\u7684\u6570\u5b57\uff0c\u539f\u56e0\uff1a\u5b58\u5728\u7cbe\u5ea6\u635f\u5931\u3002\u8bf7\u586b\u5199\u6b63\u786e\u7684\u503c\u3002", (String)"AmountCellValueUpdate_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
            return Tuple.create((Object)Boolean.TRUE, (Object)errMsg);
        }
        return CHECK_NOTCLEAR_MSG;
    }

    @Override
    protected void dealValue(Cell cell, Object value) {
        value = value == null || EmptyUtil.isEmpty((String)value.toString().trim()) ? BigDecimal.ZERO : value;
        String plainVal = new BigDecimal(value.toString()).stripTrailingZeros().toPlainString();
        BigDecimal tureVal = new BigDecimal(plainVal);
        cell.setValue((Object)tureVal);
        cell.setNewValue((Object)tureVal);
        cell.setDisplayValue((Object)tureVal);
    }

    @Override
    public void custom(CellStyleInfo cellStyle) {
        super.custom(cellStyle);
        cellStyle.setHa(HorizontalAlignEnum.RIGHT);
        cellStyle.setFm("#,##0.00");
    }
}

