/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.update.strategy;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fpm.business.spread.update.AbsCellValueUpdate;
import kd.tmc.fpm.spread.command.event.CellValueEvent;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;
import kd.tmc.fpm.spread.widget.style.HorizontalAlignEnum;

public class DateCellValueUpdate
extends AbsCellValueUpdate {
    private static Log logger = LogFactory.getLog(DateCellValueUpdate.class);
    private static final String UTCTIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String GMTTIME_FORMAT = "EEE MMM dd yyyy hh:mm:ss z";
    private static final String REGEXP_OADATE = "^/OADate\\(-?[0-9]+(\\.[0-9]+)?\\)/$";
    private static final String REGEXP_DIGITAL = "-?[0-9]+(\\.[0-9]+)?";
    private static final String REGEXP_DATE = "((^((1[8-9]\\d{2})|([2-9]\\d{3}))([-/._])(10|12|0?[13578])([-/._])(3[01]|[12][0-9]|0?[1-9])$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-/._])(11|0?[469])([-/._])(30|[12][0-9]|0?[1-9])$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-/._])(0?2)([-/._])(2[0-8]|1[0-9]|0?[1-9])$)|(^([2468][048]00)([-/._])(0?2)([-/._])(29)$)|(^([3579][26]00)([-/._])(0?2)([-/._])(29)$)|(^([1][89][0][48])([-/._])(0?2)([-/._])(29)$)|(^([2-9][0-9][0][48])([-/._])(0?2)([-/._])(29)$)|(^([1][89][2468][048])([-/._])(0?2)([-/._])(29)$)|(^([2-9][0-9][2468][048])([-/._])(0?2)([-/._])(29)$)|(^([1][89][13579][26])([-/._])(0?2)([-/._])(29)$)|(^([2-9][0-9][13579][26])([-/._])(0?2)([-/._])(29)$)|\\\\d{2}Z)";
    private static final String REGEXP_JSON_DATE = "\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[-/._]\\d{3}Z";

    public DateCellValueUpdate(CellValueEvent event, Cell originCell) {
        super(event, originCell);
    }

    @Override
    protected Tuple<Boolean, String> check(CellValueEvent event, CellTypeEnum cellType) {
        boolean formatCheck;
        Object newValue = event.getNewValue();
        if (null == newValue) {
            return CHECK_NOTCLEAR_MSG;
        }
        SimpleDateFormat sdfUTC = new SimpleDateFormat(UTCTIME_FORMAT, Locale.ENGLISH);
        sdfUTC.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            Date date = sdfUTC.parse(newValue.toString());
            newValue = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
        }
        catch (ParseException date) {
            // empty catch block
        }
        SimpleDateFormat sdfGMT = new SimpleDateFormat(GMTTIME_FORMAT, Locale.ENGLISH);
        sdfGMT.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            Date date = sdfGMT.parse(newValue.toString());
            newValue = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
        }
        catch (ParseException date) {
            // empty catch block
        }
        boolean oaResult = newValue.toString().matches(REGEXP_OADATE);
        boolean dateResult = newValue.toString().matches(REGEXP_DATE);
        boolean jsonResult = newValue.toString().matches(REGEXP_JSON_DATE);
        boolean bl = formatCheck = !dateResult && !oaResult && !jsonResult;
        if (formatCheck) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5355\u5143\u683c%1$s\u4e3a%2$s\u7c7b\u578b\u5355\u5143\u683c\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u503c\u3002", (String)"DateCellValueUpdate_2", (String)"tmc-fpm-business", (Object[])new Object[0]), ExcelUtils.xy2Pos((int)event.getCell().getCol(), (int)event.getCell().getRow()), cellType.getName());
            return Tuple.create((Object)Boolean.TRUE, (Object)errMsg);
        }
        return CHECK_NOTCLEAR_MSG;
    }

    @Override
    protected void dealValue(Cell cell, Object value) throws ParseException {
        if (value == null) {
            return;
        }
        String dateStr = value.toString();
        SimpleDateFormat sdf = new SimpleDateFormat(UTCTIME_FORMAT, Locale.ENGLISH);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = null;
        try {
            date = sdf.parse(dateStr);
            if (date != null) {
                dateStr = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
            }
        }
        catch (ParseException e) {
            String errMsg = String.format(ResManager.loadKDString((String)"%1$s\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\uff08%2$s\uff09\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u503c\u3002", (String)"DateCellValueUpdate_3", (String)"tmc-fpm-business", (Object[])new Object[0]), "UTC", dateStr);
            logger.warn(errMsg);
        }
        if (date == null) {
            SimpleDateFormat sdfGMT = new SimpleDateFormat(GMTTIME_FORMAT, Locale.ENGLISH);
            sdfGMT.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                date = sdfGMT.parse(dateStr);
                if (date != null) {
                    dateStr = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
                }
            }
            catch (ParseException e) {
                String errMsg = String.format(ResManager.loadKDString((String)"%1$s\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\uff08%2$s\uff09\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u503c\u3002", (String)"DateCellValueUpdate_3", (String)"tmc-fpm-business", (Object[])new Object[0]), "GMT", dateStr);
                logger.warn(errMsg);
            }
        }
        if (dateStr.matches(REGEXP_OADATE)) {
            Pattern pattern = Pattern.compile(REGEXP_DIGITAL);
            Matcher matcher = pattern.matcher(dateStr);
            if (matcher.find()) {
                String group = matcher.group();
                Double oaDate = Double.valueOf(group);
                date = this.convterToOADate(oaDate);
            }
        } else if (dateStr.matches(REGEXP_DATE)) {
            String[] partterns = new String[]{"yyyy-MM-dd", "yyyy/MM/dd"};
            date = this.parseDate(dateStr, partterns);
        } else {
            date = this.parseDate(dateStr, "yyyy-MM-dd");
        }
        cell.setDisplayValue((Object)DateUtils.formatString((Date)date, (String)"yyyy/MM/dd"));
        cell.setValue((Object)date);
        cell.setNewValue((Object)date);
    }

    private Date parseDate(String dateStr, String ... partterns) {
        for (String parttern : partterns) {
            SimpleDateFormat parser = new SimpleDateFormat(parttern);
            try {
                Date date = parser.parse(dateStr);
                return date;
            }
            catch (ParseException e) {
            }
        }
        throw new KDBizException("Unable to parse the date: " + dateStr);
    }

    private Date convterToOADate(double oatime) throws ParseException {
        double mantissa = oatime - (double)((long)oatime);
        double hour = mantissa * 24.0;
        double min = (hour - (double)((long)hour)) * 60.0;
        double sec = (min - (double)((long)min)) * 60.0;
        SimpleDateFormat myFormat = new SimpleDateFormat("dd MM yyyy");
        Date baseDate = myFormat.parse("30 12 1899");
        Calendar c = Calendar.getInstance();
        c.setTime(baseDate);
        c.add(5, (int)oatime);
        c.add(10, (int)hour);
        c.add(12, (int)min);
        c.add(13, (int)sec);
        return c.getTime();
    }

    private String timeConverterOfUTCOrGMT(String dateStr, String format, String timeType) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.ENGLISH);
        sdf.setTimeZone(TimeZone.getTimeZone(timeType));
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            String errMsg = String.format(ResManager.loadKDString((String)"%1$s\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\uff08%2$s\uff09\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u503c\u3002", (String)"DateCellValueUpdate_3", (String)"tmc-fpm-business", (Object[])new Object[0]), timeType, dateStr);
            logger.error(errMsg);
        }
        return DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
    }

    @Override
    public void custom(CellStyleInfo cellStyle) {
        super.custom(cellStyle);
        cellStyle.setHa(HorizontalAlignEnum.Center);
        cellStyle.setFm("yyyy/MM/dd");
    }
}

