/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.task;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.ext.tmc.utils.SerializeUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.tmc.fpm.business.domain.model.inspection.header.InspectHeader;
import kd.tmc.fpm.business.mvc.service.inspection.impl.InspectionExecuteBizService;
import org.apache.commons.lang3.StringUtils;

public class ExecInspectionTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ExecInspectionTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (map == null) {
            return;
        }
        Object traceId = map.get("traceId");
        logger.info("\u89e6\u53d1\u4efb\u52a1\u7684traceId:{}", traceId);
        String headerStr = (String)map.get("inspectHeader");
        InspectHeader inspectHeader = (InspectHeader)SerializeUtil.deserialize((String)headerStr, InspectHeader.class);
        this.doExecute(inspectHeader);
    }

    private void doExecute(InspectHeader inspectHeader) {
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>(16);
        returnDataMap.put("success", true);
        try {
            this.updatePercent(0, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85", (String)"ExecInspectionTask_0", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
            InspectionExecuteBizService inspectionExecuteBizService = new InspectionExecuteBizService();
            inspectionExecuteBizService.execute(inspectHeader);
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u5de1\u68c0\u5931\u8d25 ", (Throwable)e);
            returnDataMap.put("success", false);
            String errMsg = StringUtils.isEmpty((CharSequence)e.getMessage()) ? ResManager.loadKDString((String)"\u6267\u884c\u5de1\u68c0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExecInspectionTask_1", (String)"tmc-fpm-business", (Object[])new Object[0]) : e.getMessage();
            returnDataMap.put("errorMessage", errMsg);
        }
        this.feedbackCustomdata(returnDataMap);
        this.updatePercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"ExecInspectionTask_2", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
    }

    public void updatePercent(int process, String message, Map<String, Object> customData) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.feedbackProgress(process, message, customData);
        } else {
            this.feedbackProgress(process);
        }
    }
}

