/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fpm.business.domain.enums.TaskStatus;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.mvc.service.dto.TaskRecordQueryParamsDTO;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskHandleService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskRecordQueryService;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.TaskHandleServiceImpl;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.TaskRecordQueryServiceImpl;

public class LocalSequentMonitorTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(LocalSequentMonitorTask.class);
    private TaskRecordQueryService taskRecordQueryService = new TaskRecordQueryServiceImpl();
    private TaskHandleService handleService = new TaskHandleServiceImpl();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Date now = new Date();
        Date lastDay = DateUtils.getLastDay((Date)now, (int)1);
        TaskRecordQueryParamsDTO queryParamsDTO = new TaskRecordQueryParamsDTO();
        queryParamsDTO.setStatus(TaskStatus.HANDLING);
        queryParamsDTO.setCreateStartTime(lastDay);
        queryParamsDTO.setCreateEndTime(now);
        List<TaskRecord> taskRecords = this.taskRecordQueryService.loadTaskByParams(queryParamsDTO);
        if (CollectionUtils.isEmpty(taskRecords)) {
            logger.info("[LocalSequentMonitorTask] \u5f53\u524d\u65e0\u8d85\u65f6\u4efb\u52a1. \u65f6\u95f4\u68c0\u67e5\u8303\u56f4\uff1a{}~{}", (Object)DateUtils.formatString((Date)lastDay, (String)"yyyy-MM-dd HH:mm:ss"), (Object)DateUtils.formatString((Date)now, (String)"yyyy-MM-dd HH:mm:ss"));
            return;
        }
        ArrayList<TaskRecord> needUpdateTask = new ArrayList<TaskRecord>(10);
        for (TaskRecord taskRecord : taskRecords) {
            Date createTime = taskRecord.getCreateTime();
            int diffMinute = DateUtils.getDiffMinute((Date)createTime, (Date)now);
            if (diffMinute < 30) continue;
            taskRecord.setStatus(TaskStatus.FAILED.name());
            taskRecord.setErrorMsg("execute time out, need check monitor log");
            needUpdateTask.add(taskRecord);
            logger.warn("[LocalSequentMonitorTask] \u5f53\u524d\u4efb\u52a1\u5df2\u8d85\u65f6\uff0c\u4efb\u52a1ID\uff1a{}\uff0c \u4efb\u52a1\u7c7b\u578b\uff1a{}", (Object)taskRecord.getId(), (Object)taskRecord.getTaskType());
        }
        this.handleService.batchUpdateTask(needUpdateTask);
    }
}

