/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.task;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.ext.tmc.utils.SerializeUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.tmc.fpm.business.domain.model.inspection.header.RepairHeader;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.inspection.context.RepairContext;
import kd.tmc.fpm.business.mvc.service.inspection.factory.DataRepairServiceFactory;
import kd.tmc.fpm.business.mvc.service.inspection.factory.InspectContextFactory;
import kd.tmc.fpm.business.mvc.service.inspection.repair.IInspectDataRepair;
import org.apache.commons.lang3.StringUtils;

public class RepairDataTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(RepairDataTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (map == null) {
            return;
        }
        logger.info("traceId:{}", map.get("traceId"));
        String headerStr = (String)map.get("repairHeader");
        RepairHeader inspectHeader = (RepairHeader)SerializeUtil.deserialize((String)headerStr, RepairHeader.class);
        this.doExecute(inspectHeader);
    }

    private void doExecute(RepairHeader repairHeader) {
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>(16);
        returnDataMap.put("success", true);
        this.updatePercent(0, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85", (String)"RepairDataTask_0", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
        RepairContext repairContext = InspectContextFactory.getRepairContext(repairHeader);
        IInspectDataRepair inspectDataRepairService = DataRepairServiceFactory.getInspectDataRepairService(repairContext);
        FpmOperateResult<Object> fpmOperateResult = inspectDataRepairService.inspectDataRepair(repairContext);
        if (!fpmOperateResult.isSuccess()) {
            logger.error("\u6267\u884c\u5de1\u68c0\u5931\u8d25 ", fpmOperateResult.getMessageList());
            returnDataMap.put("success", false);
            String errMsg = ResManager.loadKDString((String)"\u6267\u884c\u6570\u636e\u4fee\u590d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RepairDataTask_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
            returnDataMap.put("errorMessage", errMsg);
        }
        this.feedbackCustomdata(returnDataMap);
        this.updatePercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"RepairDataTask_2", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
    }

    public void updatePercent(int process, String message, Map<String, Object> customData) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.feedbackProgress(process, message, customData);
        } else {
            this.feedbackProgress(process);
        }
    }
}

