/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.task;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.ReportImportTypeEnum;
import kd.tmc.fpm.business.mvc.service.IReportImportDataBizService;
import kd.tmc.fpm.business.mvc.service.impl.ReportImportDataBizServiceImpl;
import kd.tmc.fpm.business.utils.ImportDataHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReportImportDataTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ReportImportDataTask.class);
    private IFormView formView;
    private IPageCache pageCache;
    private IReportImportDataBizService reportImportDataBizService = new ReportImportDataBizServiceImpl();
    private ReportImportTypeEnum reportImportType;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (map == null) {
            return;
        }
        String pageId = (String)map.get("pageId");
        this.reportImportType = ReportImportTypeEnum.getByCode((String)map.get("reportImportType"));
        IFormView view = SessionManager.getCurrent().getView(pageId);
        PageCache pageCache = new PageCache(pageId);
        view.addService(IPageCache.class, (Object)pageCache);
        this.formView = view;
        this.pageCache = pageCache;
        this.pageCache.put("reportFileUrl", (String)map.get("reportFileUrl"));
        this.doExecute();
    }

    private void doExecute() {
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>(16);
        returnDataMap.put("success", true);
        try {
            this.updatePercent(0, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"ReportImportDataTask_0", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
            this.handleImportData();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5931\u8d25 ", (Throwable)e);
            returnDataMap.put("success", false);
            String errMsg = StringUtils.isEmpty((CharSequence)e.getMessage()) ? ResManager.loadKDString((String)"\u89e3\u6790\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportImportDataTask_1", (String)"tmc-fpm-business", (Object[])new Object[0]) : e.getMessage();
            returnDataMap.put("errorMessage", errMsg);
        }
        this.feedbackCustomdata(returnDataMap);
        this.updatePercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210\u3002", (String)"ReportImportDataTask_2", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
    }

    private void handleImportData() throws IOException {
        List<InputStream> importStreamFromCache = this.getImportStreamFromCache(this.pageCache);
        int size = importStreamFromCache.size();
        if (size > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bfc\u5165\u4e00\u4e2aExcel\u6587\u4ef6\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportImportDataTask_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        XSSFWorkbook xssfWorkBook = this.getXssfWorkBook(importStreamFromCache.get(0));
        if (xssfWorkBook.getNumberOfSheets() > 300) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7684Excel\u6587\u4ef6\u4e2d\u6700\u591a\u4ec5\u652f\u6301\u5bfc\u5165300\u4e2asheet\u9875\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ReportImportDataTask_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        this.validateImportData(xssfWorkBook);
        Map<String, List<Sheet>> sheetReportMap = this.groupSheet(xssfWorkBook);
        this.importWorkBookData(sheetReportMap, xssfWorkBook.getNumberOfSheets());
    }

    private void validateImportData(XSSFWorkbook xssfWorkBook) {
        String errMsg;
        HashMap<String, Sheet> sheetMap = new HashMap<String, Sheet>(1);
        boolean reportExists = true;
        for (Sheet sheet : xssfWorkBook) {
            if (xssfWorkBook.isSheetHidden(xssfWorkBook.getSheetIndex(sheet))) continue;
            String systemNum = ImportDataHelper.getSystemNum(sheet);
            String reportNumber = ImportDataHelper.getReportNumber(sheet);
            String reportPeriodNum = ImportDataHelper.getReportPeriodNum(sheet);
            sheetMap.put(systemNum + reportPeriodNum, sheet);
            reportExists = TmcDataServiceHelper.exists((String)"fpm_report", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)reportNumber), new QFilter("billstatus", "=", (Object)BillStatus.STAGE.getNumber())});
            if (!reportExists) break;
            if (this.reportImportType != ReportImportTypeEnum.IMPORT_SINGLE) continue;
            DynamicObject report = TmcDataServiceHelper.loadSingle((String)"fpm_report", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)reportNumber), new QFilter("billstatus", "=", (Object)BillStatus.STAGE.getNumber())});
            long currentReportId = this.formView.getModel().getDataEntity().getLong("reportid");
            if (report.getLong("id") == currentReportId) continue;
            String errMsg2 = ResManager.loadKDString((String)"\u6309\u201c\u62a5\u8868\u7f16\u7801\u201d\u65e0\u6cd5\u5339\u914d\u5230\u5f53\u524d\u8ba1\u5212\u7f16\u5236\u8868\u201c%1$s\u201d\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"ReportImportDataTask_5", (String)"tmc-fpm-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(errMsg2, currentReportId));
        }
        if (!reportExists) {
            errMsg = ResManager.loadKDString((String)"\u6309\u201c\u62a5\u8868\u7f16\u7801\u201d\u65e0\u6cd5\u5339\u914d\u5230\u7cfb\u7edf\u4e2d\u6682\u5b58\u72b6\u6001\u7684\u8ba1\u5212\u7f16\u5236\u8868\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"ReportImportDataTask_6", (String)"tmc-fpm-business", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        if (sheetMap.size() > 1) {
            errMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u4ec5\u652f\u6301\u5bfc\u5165\u540c\u4e00\u4e2a\u7f16\u62a5\u671f\u95f4\u7684\u8ba1\u5212\u8868\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReportImportDataTask_7", (String)"tmc-fpm-business", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
    }

    private Map<String, List<Sheet>> groupSheet(XSSFWorkbook xssfWorkBook) {
        HashMap<String, List<Sheet>> resultMap = new HashMap<String, List<Sheet>>(16);
        for (Sheet sheet : xssfWorkBook) {
            String reportNumber = ImportDataHelper.getReportNumber(sheet);
            if (!StringUtils.isNotBlank((CharSequence)reportNumber)) continue;
            if (resultMap.containsKey(reportNumber)) {
                ((List)resultMap.get(reportNumber)).add(sheet);
                continue;
            }
            ArrayList<Sheet> sheetList = new ArrayList<Sheet>();
            sheetList.add(sheet);
            resultMap.put(reportNumber, sheetList);
        }
        return resultMap;
    }

    private void importWorkBookData(Map<String, List<Sheet>> sheetReportMap, int size) {
        int idx = 0;
        for (Map.Entry<String, List<Sheet>> entry : sheetReportMap.entrySet()) {
            String reportNumber = entry.getKey();
            DynamicObject report = TmcDataServiceHelper.loadSingle((String)"fpm_report", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)reportNumber), new QFilter("billstatus", "=", (Object)BillStatus.STAGE.getNumber())});
            this.reportImportDataBizService.importReportBatch(report.getLong("id"), entry.getValue());
            int percent = (size - (idx + entry.getValue().size())) / size * 100;
            this.updatePercent(percent, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"ReportImportDataTask_8", (String)"tmc-fpm-business", (Object[])new Object[0]), null);
        }
    }

    public void updatePercent(int process, String message, Map<String, Object> customData) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.feedbackProgress(process, message, customData);
        } else {
            this.feedbackProgress(process);
        }
    }

    private List<InputStream> getImportStreamFromCache(IPageCache pageCache) {
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String fileUrl = pageCache.get("reportFileUrl");
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>(16);
        if (fileUrl != null) {
            List urls = (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
            try {
                for (String url : urls) {
                    String[] reqParams = new URL(url).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                    InputStream inputStream = content.getInputStream();
                    inputStreams.add(inputStream);
                }
            }
            catch (MalformedURLException e) {
                logger.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReportImportDataTask_9", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
        }
        if (inputStreams.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"ReportImportDataTask_10", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return inputStreams;
    }

    private XSSFWorkbook getXssfWorkBook(InputStream inputStream) throws IOException {
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        try {
            XSSFWorkbook xSSFWorkbook = (XSSFWorkbook)WorkbookFactory.create((InputStream)inputStream);
            return xSSFWorkbook;
        }
        finally {
            inputStream.close();
        }
    }
}

