/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.task;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.tmc.fpm.business.domain.model.bodysysimport.BodySysImportInfo;
import kd.tmc.fpm.business.service.fundsys.exportandimport.impl.BodySysImportServiceImpl;
import kd.tmc.fpm.business.task.AbstractTraceIdTask;
import kd.tmc.fpm.business.task.result.TaskResult;

public class SystemImportTask
extends AbstractTraceIdTask {
    public static final String BODY_NAME = "name";
    public static final String DUTY_ORG = "dutyorg";
    public static final String DUTY_ORG_CURRENCY = "dutyorgcurrency";
    public static final String RATE_TABLE = "ratetable";

    @Override
    void doExecute(RequestContext requestContext, Map<String, Object> map, TaskResult taskResult) {
        DynamicObject rateTable;
        DynamicObject dutyOrgCurrency;
        String uploadFileName = (String)map.get("uploadFileName");
        String pageId = (String)map.get("pageId");
        IFormView view = SessionManager.getCurrent().getView(pageId);
        BodySysImportInfo info = new BodySysImportInfo();
        info.setBodySysName((OrmLocaleValue)view.getModel().getValue(BODY_NAME));
        DynamicObject dutyOrg = (DynamicObject)view.getModel().getValue(DUTY_ORG);
        if (Objects.nonNull(dutyOrg)) {
            info.setDutyOrgId(dutyOrg);
        }
        if (Objects.nonNull(dutyOrgCurrency = (DynamicObject)view.getModel().getValue(DUTY_ORG_CURRENCY))) {
            info.setDutyOrgCurrencyId(dutyOrgCurrency);
        }
        if (Objects.nonNull(rateTable = (DynamicObject)view.getModel().getValue(RATE_TABLE))) {
            info.setRateTableId(rateTable);
        }
        BodySysImportServiceImpl bodySysImportService = new BodySysImportServiceImpl(info, (List)SerializationUtils.fromJsonString((String)uploadFileName, List.class));
        bodySysImportService.upload();
        taskResult.addResultInfo("status", (Object)bodySysImportService.getStatus());
        taskResult.addResultInfo("message", String.join((CharSequence)"\r\n", bodySysImportService.getMessage()));
    }
}

