/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.task.result;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TaskResult
implements Serializable {
    private boolean success = true;
    private final Set<String> errorMessages = new LinkedHashSet<String>(16);
    private final Map<String, Object> resultInfo = new HashMap<String, Object>(16);

    public void addErrorMessage(String message) {
        this.errorMessages.add(message);
        this.success = false;
    }

    public void addResultInfo(String key, Object value) {
        this.resultInfo.put(key, value);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorMessage() {
        return this.getErrorMessage("\r\n");
    }

    public String getErrorMessage(String delimiter) {
        return String.join((CharSequence)";", this.errorMessages);
    }

    public boolean getBooleanResultInfo(String key) {
        return (Boolean)this.resultInfo.getOrDefault(key, Boolean.FALSE);
    }

    public <T> T getResultInfo(String key, Class<T> clazz) {
        return (T)this.resultInfo.get(key);
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Map<String, Object> getCustomData() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.resultInfo);
        map.put("success", this.success);
        map.put("errorMessage", this.getErrorMessage());
        return map;
    }
}

