/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.model.dimension.member.CurrencyMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.olap.utils.ShrekIdUtil;

public class CommonUtils {
    private static final Log logger = LogFactory.getLog(CommonUtils.class);

    public static <T> FpmOperateResult<T> processInDLock(String dLockName, Supplier<FpmOperateResult<T>> supplier) {
        return CommonUtils.processInDLock(dLockName, 120000L, supplier, true);
    }

    public static <T> FpmOperateResult<T> processInDLock(String dLockName, Long duration, Supplier<FpmOperateResult<T>> supplier) {
        return CommonUtils.processInDLock(dLockName, duration, supplier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> FpmOperateResult<T> processInDLock(String dLockName, Long duration, Supplier<FpmOperateResult<T>> supplier, boolean needInTransaction) {
        DLock dLock = DLock.create((String)dLockName);
        logger.info("\u51c6\u5907\u83b7\u53d6\u5206\u5e03\u5f0f\u9501:{}\u3002\u3002\u3002", (Object)dLockName);
        if (dLock.tryLock(duration.longValue())) {
            logger.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501:{}\u6210\u529f\u3002\u3002\u3002\u3002", (Object)dLockName);
            try {
                FpmOperateResult<T> fpmOperateResult = needInTransaction ? CommonUtils.processInTransaction(supplier) : supplier.get();
                return fpmOperateResult;
            }
            finally {
                logger.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\uff1a{}", (Object)dLockName);
                dLock.unlock();
            }
        }
        logger.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff1a{}\u5931\u8d25", (Object)dLockName);
        return FpmOperateResult.error("get dLock failed:{}");
    }

    public static <T> FpmOperateResult<T> processInDLockRequiresNew(String dLockName, Supplier<FpmOperateResult<T>> supplier) {
        return CommonUtils.processInDLockRequiresNew(dLockName, 120000L, supplier);
    }

    public static <T> FpmOperateResult<T> processInDLockRequiresNew(String dLockName, Long duration, Supplier<FpmOperateResult<T>> supplier) {
        return CommonUtils.processInDLockRequiresNewIfNeed(dLockName, duration, supplier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> FpmOperateResult<T> processInDLockRequiresNewIfNeed(String dLockName, Long duration, Supplier<FpmOperateResult<T>> supplier, boolean requiresNew) {
        DLock dLock = DLock.create((String)dLockName);
        logger.info("\u51c6\u5907\u83b7\u53d6\u5206\u5e03\u5f0f\u9501:{}\u3002\u3002\u3002", (Object)dLockName);
        if (dLock.tryLock(duration.longValue())) {
            logger.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501:{}\u6210\u529f\u3002\u3002\u3002\u3002", (Object)dLockName);
            try {
                FpmOperateResult<T> fpmOperateResult = requiresNew ? CommonUtils.processInTransactionRequiresNew(supplier) : CommonUtils.processInTransaction(supplier);
                return fpmOperateResult;
            }
            finally {
                logger.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\uff1a{}", (Object)dLockName);
                dLock.unlock();
            }
        }
        logger.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff1a{}\u5931\u8d25", (Object)dLockName);
        return FpmOperateResult.error("get dLock failed:{}");
    }

    public static <T> FpmOperateResult<T> processInTransaction(Supplier<FpmOperateResult<T>> supplier) {
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            FpmOperateResult<T> fpmOperateResult = supplier.get();
            return fpmOperateResult;
        }
        catch (Exception e) {
            h.markRollback();
            logger.error(e.getMessage(), (Throwable)e);
            FpmOperateResult fpmOperateResult = FpmOperateResult.error(e.getMessage());
            return fpmOperateResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public static <T> FpmOperateResult<T> processInTransactionRequiresNew(Supplier<FpmOperateResult<T>> supplier) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            FpmOperateResult<T> fpmOperateResult = supplier.get();
            return fpmOperateResult;
        }
        catch (Exception e) {
            h.markRollback();
            logger.error(e.getMessage(), (Throwable)e);
            FpmOperateResult fpmOperateResult = FpmOperateResult.error(e.getMessage());
            return fpmOperateResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public static <T> T inTransaction(Supplier<T> supplier) {
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            T t = supplier.get();
            return t;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static <T> FpmOperateResult<T> processInNewTransaction(Supplier<FpmOperateResult<T>> supplier) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            FpmOperateResult<T> fpmOperateResult = supplier.get();
            return fpmOperateResult;
        }
        catch (Exception e) {
            h.markRollback();
            logger.error(e.getMessage(), (Throwable)e);
            FpmOperateResult fpmOperateResult = FpmOperateResult.error(e.getMessage());
            return fpmOperateResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    /*
     * Exception decompiling
     */
    public static <T> FpmOperateResult<T> trace(String traceName, Function<IFpmTraceSpan, FpmOperateResult<T>> function) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> FpmOperateResult<T> traceInTracer(String traceName, Function<IFpmTraceSpan, FpmOperateResult<T>> function) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(traceName);){
            FpmOperateResult<T> fpmOperateResult = function.apply(span);
            return fpmOperateResult;
        }
    }

    /*
     * Exception decompiling
     */
    public static <T> T printTrace(String traceName, Function<IFpmTraceSpan, T> function) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> T getOrDefault(T val, T defaultVal) {
        return Objects.isNull(val) ? defaultVal : val;
    }

    public static BigDecimal getIfZeroValue(BigDecimal value) {
        if (BigDecimal.ZERO.compareTo(value) == 0) {
            return BigDecimal.ZERO;
        }
        return value;
    }

    public static BigDecimal getValueIfNull(BigDecimal bigDecimal) {
        return CommonUtils.getIfZeroValue(CommonUtils.getValueOrDefault(bigDecimal, BigDecimal.ZERO));
    }

    public static <T> T getValueOrDefault(T value, T defaultVal) {
        if (Objects.isNull(value)) {
            return defaultVal;
        }
        return value;
    }

    public static Deque<Long> batchGenerateIds(int count) {
        LinkedList<Long> idQueue = new LinkedList<Long>();
        if (count > 0) {
            long[] idArr;
            for (long id : idArr = DB.genGlobalLongIds((int)count)) {
                idQueue.offer(id);
            }
        }
        return idQueue;
    }

    public static BigDecimal getBigDecimalValue(Object value) {
        if (Objects.isNull(value)) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        }
        if (value instanceof Integer) {
            return BigDecimal.valueOf(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return BigDecimal.valueOf((Long)value);
        }
        if (value instanceof BigInteger) {
            return new BigDecimal(value.toString());
        }
        if (value instanceof String) {
            try {
                return new BigDecimal((String)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return BigDecimal.ZERO;
    }

    public static String getSyncShrekKey(DimMember dimMember) {
        if (dimMember instanceof CurrencyMember) {
            return ShrekIdUtil.getSpecialMemberNumber((String)String.valueOf(dimMember.getId()), (String)dimMember.getNumber());
        }
        return ShrekIdUtil.getDefaultMemberNumber((String)dimMember.getNumber());
    }

    public static BigDecimal getNegativeValueIfNeed(BigDecimal bigDecimal, boolean negative) {
        if (!negative) {
            return bigDecimal;
        }
        if (EmptyUtil.isEmpty((BigDecimal)bigDecimal)) {
            return bigDecimal;
        }
        return bigDecimal.negate();
    }

    public static <T> List<T> getSubListForSize(List<T> dataList, int maxLength) {
        return CommonUtils.getSubListForSize(dataList, 0, maxLength);
    }

    public static <T> List<T> getSubListForSize(List<T> dataList, int formIndex, int maxLength) {
        if (EmptyUtil.isEmpty(dataList)) {
            return dataList;
        }
        if (formIndex < 0) {
            return dataList;
        }
        int size = dataList.size();
        if (formIndex >= size) {
            return Collections.emptyList();
        }
        int endIndex = Math.min(formIndex + maxLength, size);
        return dataList.subList(formIndex, endIndex);
    }

    public static String getEnumNumberOrDefault(ITypeEnum typeEnum, String defaultVal) {
        if (Objects.isNull(typeEnum)) {
            return defaultVal;
        }
        return typeEnum.getNumber();
    }

    public static String getBooleanStringValue(Boolean bVal) {
        return CommonUtils.getBooleanStringValue(bVal, "1", "0");
    }

    public static String getBooleanStringValue(Boolean bVal, String successVal, String failValue) {
        if (Objects.isNull(bVal)) {
            return failValue;
        }
        if (bVal.booleanValue()) {
            return successVal;
        }
        return failValue;
    }

    public static <T, V> List<T> getDistinctList(List<T> list, Function<T, V> function) {
        if (EmptyUtil.isEmpty(list)) {
            return list;
        }
        Map vtMap = list.stream().collect(Collectors.toMap(function, Function.identity(), (a, b) -> a));
        return new ArrayList(vtMap.values());
    }
}

