/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDataType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.model.control.DimValueListInfo;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.DimensionIndexTreeGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategyFactory;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionCombination;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionVal;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.IDimensionMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.CommonDimMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.ReportDimensionMemberStrategy;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.common.utils.DateTimeUtil;
import org.apache.commons.collections4.CollectionUtils;

public class DimensionInfoHelper {
    private static final Log logger = LogFactory.getLog(DimensionInfoHelper.class);

    public static DimensionInfoBean replaceSumOrgFromDownDimensionInfo(ReportData reportData, Long sumOrgId) {
        return DimensionInfoHelper.replaceSumOrgFromDownDimensionInfo(reportData, sumOrgId, true);
    }

    public static void replaceDimValue(DimensionInfoBean dimensionInfoBean, Long dimensionId, Object value) {
        List dimensionIdList = dimensionInfoBean.getDimensionIdList();
        List memberIdList = dimensionInfoBean.getMemberIdList();
        int index = dimensionIdList.indexOf(dimensionId);
        if (index == -1) {
            return;
        }
        memberIdList.set(index, value);
    }

    public static DimensionInfoBean replaceSumOrgFromDownDimensionInfo(ReportData reportData, Long sumOrgId, boolean filterDetailDim) {
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        return DimensionInfoHelper.replaceSumOrgFromDownDimensionInfo(dimList, dimValList, sumOrgId, filterDetailDim);
    }

    public static DimensionInfoBean replaceSumOrgFromDownDimensionInfo(List<TemplateDim> dimList, List<Object> dimValList, Long sumOrgId, boolean filterDetailDim) {
        ArrayList<Long> dimensionIdList = new ArrayList<Long>(dimList.size());
        ArrayList<Object> dimensionValueList = new ArrayList<Object>(dimList.size());
        for (int i = dimList.size() - 1; i >= 0; --i) {
            TemplateDim templateDim = dimList.get(i);
            if (templateDim.isDetailDim() && filterDetailDim) continue;
            dimensionIdList.add(templateDim.getDimensionId());
            dimensionValueList.add(templateDim.getDimType() == DimensionType.ORG ? sumOrgId : dimValList.get(i));
        }
        return DimensionInfoBean.of(dimensionIdList, dimensionValueList);
    }

    public static DimensionInfoBean getDimensionInfoBean(ReportData reportData) {
        return DimensionInfoHelper.getDimensionInfoBeanByFilter(reportData, td -> true);
    }

    public static DimensionInfoBean getDimensionInfoBean(List<TemplateDim> dimList, List<Object> dimValList) {
        return DimensionInfoHelper.getDimensionInfoBeanByFilter(dimList, dimValList, true, td -> true);
    }

    public static DimensionInfoBean getDimensionInfoBean(List<TemplateDim> dimList, List<Object> dimValList, Predicate<TemplateDim> predicate) {
        return DimensionInfoHelper.getDimensionInfoBeanByFilter(dimList, dimValList, true, predicate);
    }

    public static DimensionInfoBean getDimensionInfoBean(ReportData reportData, ReportTemplate reportTemplate) {
        return DimensionInfoHelper.getDimensionInfoBean(reportData, reportTemplate, (TemplateDim td) -> !td.isDetailDim() && td.isVisible());
    }

    public static DimensionInfoBean getMainDimensionInfoBean(ReportData reportData) {
        return DimensionInfoHelper.getDimensionInfoBeanByFilter(reportData, templateDim -> templateDim.getDimType().isMainDimensionType());
    }

    public static DimensionInfoBean getDimensionInfoBean(ReportData reportData, ReportTemplate reportTemplate, Predicate<TemplateDim> predicate) {
        List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
        Set dimensionIds = allTemplateDim.stream().filter(predicate::test).map(TemplateDim::getDimensionId).collect(Collectors.toSet());
        EvalDimensionCombination evalDimensionCombination = EvalDimensionCombination.getEvalDimensionCombinationByReportData(reportData, templateDim -> dimensionIds.contains(templateDim.getDimensionId()));
        List<EvalDimensionVal> evalDimensionValList = evalDimensionCombination.getEvalDimensionValList();
        return DimensionInfoBean.of(evalDimensionValList.stream().map(EvalDimensionVal::getDimensionId).collect(Collectors.toList()), evalDimensionValList.stream().map(EvalDimensionVal::getValue).collect(Collectors.toList()));
    }

    public static DimensionInfoBean getDimensionInfoBeanByFilter(ReportData reportData, Predicate<TemplateDim> predicate) {
        return DimensionInfoHelper.getDimensionInfoBeanByFilter(reportData, true, predicate);
    }

    public static DimensionInfoBean getDimensionInfoBeanByFilter(ReportData reportData, boolean filterEmptyVale, Predicate<TemplateDim> predicate) {
        List<Object> dimValList = reportData.getDimValList();
        List<TemplateDim> dimList = reportData.getDimList();
        return DimensionInfoHelper.getDimensionInfoBeanByFilter(dimList, dimValList, filterEmptyVale, predicate);
    }

    public static DimensionInfoBean getDimensionInfoBeanByFilter(List<TemplateDim> dimList, List<Object> dimValList, boolean filterEmptyVale, Predicate<TemplateDim> predicate) {
        ArrayList<Long> dimensionIdList = new ArrayList<Long>(dimList.size());
        ArrayList<Object> dimensionValueList = new ArrayList<Object>(dimList.size());
        for (int i = dimList.size() - 1; i >= 0; --i) {
            TemplateDim templateDim = dimList.get(i);
            if (templateDim.getDimType() == DimensionType.DETAILDIM || !predicate.test(templateDim)) continue;
            Object val = dimValList.get(i);
            if (filterEmptyVale && EmptyUtil.isEmpty((Object)val)) continue;
            dimensionIdList.add(templateDim.getDimensionId());
            dimensionValueList.add(val);
        }
        return DimensionInfoBean.of(dimensionIdList, dimensionValueList);
    }

    public static Function<DimensionInfoBean, String> getDimPathFunction(FundPlanSystem system) {
        Map dimensionMap = system.getMainDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        Map<Long, DimMember> dimMemberMap = system.getMainDimList().stream().map(Dimension::getAllDimMemberList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, m -> m, (a, b) -> a));
        return dimensionInfoBean -> {
            List dimensionIdList = dimensionInfoBean.getDimensionIdList();
            List memberIdList = dimensionInfoBean.getMemberIdList();
            HashMap<Long, String> dimNameMap = new HashMap<Long, String>(dimensionIdList.size());
            for (int i = 0; i < dimensionIdList.size(); ++i) {
                Object memberId;
                DimMember dimMember;
                Long dimensionId = (Long)dimensionIdList.get(i);
                if (!dimensionMap.containsKey(dimensionId) || Objects.isNull(dimMember = (DimMember)dimMemberMap.get(memberId = memberIdList.get(i)))) continue;
                dimNameMap.putIfAbsent(dimensionId, dimMember.getName());
            }
            return dimNameMap.keySet().stream().map(dimensionMap::get).sorted(Comparator.comparing(dimension -> DimensionInfoHelper.getScoreByDimensionType(dimension))).map(Dimension::getId).map(dimNameMap::get).collect(Collectors.joining("/"));
        };
    }

    public static int getScoreByDimensionType(Dimension dimension) {
        DimensionType dimType = dimension.getDimType();
        switch (dimType) {
            case ORG: {
                return 1;
            }
            case CURRENCY: {
                return 20;
            }
            case PERIOD: {
                return 30;
            }
            case SUBJECTS: {
                return 40;
            }
            case ACCOUNTTYPE: 
            case COMPANY: 
            case SETTLEMENT_TYPE: {
                return 50;
            }
            case CUSTOM: {
                return 60;
            }
            case DETAILDIM: {
                DetailDimType detailDimType = dimension.getDetailDimType();
                if (detailDimType == DetailDimType.PLAN_AMOUNT) {
                    return 0;
                }
                if (detailDimType == DetailDimType.CONNTERPARTY_TYPE) {
                    return 90;
                }
                return 100;
            }
        }
        return 0;
    }

    public static Map<Long, Object> getDetailDimValueMap(ReportData reportData, Set<Long> detailControlBaseDimensionIds) {
        return DimensionInfoHelper.getDetailDimValueMap(reportData, detailControlBaseDimensionIds, true);
    }

    public static Map<Long, Object> getDetailDimValueMap(ReportData reportData, Set<Long> detailControlBaseDimensionIds, boolean filterNullOrEmpty) {
        HashMap<Long, Object> detailDimValueMap = new HashMap<Long, Object>(detailControlBaseDimensionIds.size());
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        for (int i = 0; i < dimList.size(); ++i) {
            Long dimensionId;
            TemplateDim templateDim = dimList.get(i);
            if (!templateDim.isVisible() || !detailControlBaseDimensionIds.contains(dimensionId = templateDim.getDimensionId())) continue;
            Object val = dimValList.get(i);
            if (filterNullOrEmpty && EmptyUtil.isEmpty((Object)val)) continue;
            detailDimValueMap.put(dimensionId, val);
        }
        return detailDimValueMap;
    }

    public static Predicate<ReportData> getDetailFieldMatchFilter(Map<Long, Object> detailDimValueMap) {
        return DimensionInfoHelper.getDetailFieldMatchFilter(detailDimValueMap, detailDimValueMap.keySet());
    }

    public static Predicate<ReportData> getDetailFieldMatchFilter(Map<Long, Object> detailDimValueMap, Set<Long> detailControlBaseDimensionIds) {
        return rd -> {
            Map<Long, Object> rdDetailDimValueMap = DimensionInfoHelper.getDetailDimValueMap(rd, detailControlBaseDimensionIds);
            logger.info("\u660e\u7ec6\u5b57\u6bb5\u5339\u914d,\u5f85\u5339\u914d\u7684\u660e\u7ec6\u5b57\u6bb5\u7ef4\u5ea6id\uff1a{}\uff0c\u5f85\u5339\u914d\u7684\u7f16\u5236\u6570\u636e\uff1a{}\uff0c\u5bf9\u5e94\u7684\u660e\u7ec6\u5b57\u6bb5\u503c\uff1a{}\uff0c\u76ee\u6807\u7f16\u5236\u6570\u636e\u7684\u660e\u7ec6\u5b57\u6bb5\u503c\uff1a{}", new Object[]{detailControlBaseDimensionIds, rd.getId(), rdDetailDimValueMap, detailDimValueMap});
            if (detailDimValueMap.size() != rdDetailDimValueMap.size()) {
                return false;
            }
            for (Map.Entry entry : detailDimValueMap.entrySet()) {
                Long key = (Long)entry.getKey();
                Object value = entry.getValue();
                Object val = rdDetailDimValueMap.get(key);
                if (Objects.equals(val, value)) continue;
                return false;
            }
            return true;
        };
    }

    public static Object getMainDimVal(List<TemplateDim> dimList, List<Object> dimValList, DimensionType dimType) {
        if (dimType == DimensionType.DETAILDIM) {
            return null;
        }
        return DimensionInfoHelper.getDimVal(dimList, dimValList, dimType, null);
    }

    public static Object getDimVal(List<TemplateDim> dimList, List<Object> dimValList, DimensionType dimType, DetailDimType detailDimType) {
        OptionalInt dimValIdxOpt = DimensionInfoHelper.getDimIdx(dimList, dimType, detailDimType);
        return dimValIdxOpt.isPresent() ? dimValList.get(dimValIdxOpt.getAsInt()) : null;
    }

    public static String getDimValDisplayName(List<TemplateDim> dimList, List<Object> dimValList, DimensionType dimType, DetailDimType detailDimType) {
        OptionalInt dimValIdxOpt = DimensionInfoHelper.getDimIdx(dimList, dimType, detailDimType);
        if (!dimValIdxOpt.isPresent()) {
            return null;
        }
        int idx = dimValIdxOpt.getAsInt();
        Object auxDimVal = null;
        if (detailDimType == DetailDimType.COUNTERPARTY_NAME) {
            OptionalInt opUserTypeDetailDimIdx = DimensionInfoHelper.getDimIdx(dimList, DimensionType.DETAILDIM, DetailDimType.CONNTERPARTY_TYPE);
            auxDimVal = opUserTypeDetailDimIdx.isPresent() ? dimValList.get(opUserTypeDetailDimIdx.getAsInt()) : null;
        }
        return DimensionInfoHelper.getDimValDisplayName(dimList.get(idx), dimValList.get(idx), auxDimVal);
    }

    private static OptionalInt getDimIdx(List<TemplateDim> dimList, DimensionType dimType, DetailDimType detailDimType) {
        return IntStream.range(0, dimList.size()).filter(idx -> dimType == ((TemplateDim)dimList.get(idx)).getDimType() && (detailDimType == null || detailDimType == ((TemplateDim)dimList.get(idx)).getDetailDimType())).findAny();
    }

    public static String getDimValDisplayName(TemplateDim dimTpl, Object dimVal, Object auxDimVal) {
        if (EmptyUtil.isEmpty((Object)dimVal)) {
            return null;
        }
        if (dimTpl.getDimType() != DimensionType.DETAILDIM) {
            DynamicObject dynamicObject = TmcDataServiceHelper.loadSingleFromCache((Object)dimVal, (String)"fpm_member", (String)"name");
            return dynamicObject.getLocaleString("name").getLocaleValue();
        }
        DetailDimType detailDimType = dimTpl.getDetailDimType();
        if (Arrays.asList(DetailDimType.BANK_CATE, DetailDimType.BANK_ACCOUNT, DetailDimType.BUSINESS_PARTNER).contains((Object)detailDimType)) {
            return DimensionInfoHelper.getDetailDimDataDisplayName(DetailDataType.BASEDATA, dimVal, String.valueOf(detailDimType.getExtVal()));
        }
        if (DetailDimType.PLAN_DATE == detailDimType) {
            return DimensionInfoHelper.getDetailDimDataDisplayName(DetailDataType.DATE, dimVal, null);
        }
        if (DetailDimType.COUNTERPARTY_NAME == detailDimType) {
            if (Objects.nonNull(auxDimVal)) {
                String bdEntity = (String)auxDimVal;
                return DimensionInfoHelper.getDetailDimDataDisplayName(DetailDataType.MUTIBASEDATA, dimVal, bdEntity);
            }
            return String.valueOf(dimVal);
        }
        if (DetailDimType.isExtraField(detailDimType)) {
            return DimensionInfoHelper.getDetailDimDataDisplayName(dimTpl.getDetailDataType(), dimVal, dimTpl.getBaseDataType());
        }
        return String.valueOf(dimVal);
    }

    private static String getDetailDimDataDisplayName(DetailDataType detailDataType, Object dimVal, String baseDataType) {
        if (EmptyUtil.isEmpty((Object)detailDataType)) {
            return null;
        }
        switch (detailDataType) {
            case DATE: {
                return dimVal instanceof Date ? DateTimeUtil.format((Date)((Date)dimVal), (String)"yyyy/MM/dd") : String.valueOf(dimVal);
            }
            case AMOUNT: {
                return dimVal instanceof BigDecimal ? ((BigDecimal)dimVal).toPlainString() : String.valueOf(dimVal);
            }
            case BASEDATA: 
            case MUTIBASEDATA: {
                Long pkId = dimVal instanceof Long ? (Long)dimVal : Long.valueOf(String.valueOf(dimVal));
                DynamicObject dynamicObject = TmcDataServiceHelper.loadSingleFromCache((Object)pkId, (String)baseDataType, (String)"name");
                return Objects.nonNull(dynamicObject) ? dynamicObject.getLocaleString("name").getLocaleValue() : null;
            }
        }
        return String.valueOf(dimVal);
    }

    public static List<DimensionInfoBean> getDimensionInfoBeanFromDimensionValueInfo(DimValueListInfo dimValueListInfo) {
        if (dimValueListInfo.isEmpty()) {
            return Collections.emptyList();
        }
        List<List<Object>> dimValueList = dimValueListInfo.getDimValueList();
        List<Dimension> dimensionList = dimValueListInfo.getDimensionList();
        List<Object> dimensionInfoBeanList = Collections.emptyList();
        for (int i = 0; i < dimensionList.size(); ++i) {
            List<Object> objectList = dimValueList.get(i);
            Dimension dimension = dimensionList.get(i);
            Long dimensionId = dimension.getId();
            dimensionInfoBeanList = EmptyUtil.isEmpty(dimensionInfoBeanList) ? objectList.stream().map(memberId -> DimensionInfoBean.of((List)Lists.newArrayList((Object[])new Long[]{dimensionId}), (List)Lists.newArrayList((Object[])new Object[]{memberId}))).collect(Collectors.toList()) : dimensionInfoBeanList.stream().map(dimensionInfoBean -> objectList.stream().map(memberId -> {
                DimensionInfoBean copy = dimensionInfoBean.copy();
                copy.addDimensionInfo(dimensionId, memberId);
                return copy;
            }).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return dimensionInfoBeanList;
    }

    public static List<IDimensionMemberStrategy> getDimensionMemberStrategyList(Report report) {
        return Lists.newArrayList((Object[])new IDimensionMemberStrategy[]{new ReportDimensionMemberStrategy(report), new CommonDimMemberStrategy()});
    }

    public static List<DimensionInfoBean> getDimensionInfoBeanListFromTemplate(FundPlanSystem system, ReportTemplate template, List<IDimensionMemberStrategy> dimensionMemberStrategyList) {
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        Map dimensionMap = system.getMainDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity(), (a, b) -> a));
        DimValueListInfo dimValueListInfo = new DimValueListInfo();
        block0: for (TemplateDim templateDim : allTemplateDim) {
            Dimension dimension = (Dimension)dimensionMap.get(templateDim.getDimensionId());
            for (IDimensionMemberStrategy dimensionMemberStrategy : dimensionMemberStrategyList) {
                List<?> memberScope = dimensionMemberStrategy.getMemberScope(dimension, templateDim);
                if (memberScope == null) continue;
                memberScope.forEach(val -> dimValueListInfo.addDimensionValue(dimension, val));
                continue block0;
            }
        }
        return DimensionInfoHelper.getDimensionInfoBeanFromDimensionValueInfo(dimValueListInfo);
    }

    public static DimensionIndexTree buildIndex(ReportDataSource reportDataSource, FundPlanSystem system) {
        IndexTreeGenerateStrategy strategy = IndexTreeGenerateStrategyFactory.createReportDataStrategy(reportDataSource, system);
        DimensionIndexTreeGenerator generator = new DimensionIndexTreeGenerator(strategy);
        DimensionIndexTree indexTree = generator.build();
        List<ReportData> mountReportDataList = reportDataSource.getReportDataList().stream().filter(o -> !o.isAuxiliaryInfo()).collect(Collectors.toList());
        ReportHelper.mountReportData(indexTree, mountReportDataList);
        return indexTree;
    }

    public static Map<Long, Long> createViAccountDim(FundPlanSystem system) {
        if (system.getDimList().stream().anyMatch(dim -> dim.getDimType() == DimensionType.ACCOUNTTYPE)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Dimension viSubjectDim = DimensionInfoHelper.createSubjectFlowDim();
        List<Dimension> dimList = system.getDimList();
        Optional<Dimension> subjectOptional = dimList.stream().filter(item -> item.getDimType().isSubjectDim()).findFirst();
        if (!subjectOptional.isPresent()) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        List<DimMember> memberList = viSubjectDim.getMemberList();
        Map virtualSubjectFlowMemberMap = memberList.stream().collect(Collectors.toMap(DimMember::getNumber, Function.identity(), (a, b) -> a));
        Dimension subject = subjectOptional.get();
        List subjectMemberList = subject.getAllDimMemberList().stream().map(AccountMember.class::cast).collect(Collectors.toList());
        HashMap subject2SubjectFlowMap = Maps.newHashMapWithExpectedSize((int)subjectMemberList.size());
        for (AccountMember subjectMember : subjectMemberList) {
            FlowType flowType = subjectMember.getFlowType();
            DimMember virtualSubjectFlowMember = (DimMember)virtualSubjectFlowMemberMap.get(flowType.getNumber());
            if (Objects.isNull(virtualSubjectFlowMember)) continue;
            subject2SubjectFlowMap.putIfAbsent(subjectMember.getId(), virtualSubjectFlowMember.getId());
        }
        dimList.add(viSubjectDim);
        return subject2SubjectFlowMap;
    }

    public static Dimension createSubjectFlowDim() {
        String dimName = ResManager.loadKDString((String)"\u6d41\u5411", (String)"ReportTemplateBuildV2Action_9", (String)"tmc-fpm-business", (Object[])new Object[0]);
        Dimension subjectFlowDim = DimensionInfoHelper.createVirtualDim(DimensionType.ACCOUNTTYPE, dimName);
        DimensionInfoHelper.fillFlowMember(subjectFlowDim);
        return subjectFlowDim;
    }

    public static Dimension createVirtualDim(DimensionType dimensionType, String dimName) {
        long dimId = DB.genGlobalLongId();
        Dimension virtualDim = new Dimension();
        virtualDim.setId(dimId);
        virtualDim.setDimType(dimensionType);
        virtualDim.setName(dimName);
        virtualDim.setVisible(true);
        virtualDim.setNumber(dimensionType.getNumber());
        virtualDim.setShrekKey(virtualDim.getNumber());
        virtualDim.setMemberList(new ArrayList<DimMember>(0));
        return virtualDim;
    }

    private static void fillFlowMember(Dimension virtualDim) {
        FlowType[] values = FlowType.values();
        ArrayList<DimMember> memberList = new ArrayList<DimMember>(values.length);
        for (FlowType flowType : values) {
            DimMember inDimMember = new DimMember();
            inDimMember.setId(flowType.getVirtualId());
            inDimMember.setNumber(flowType.getNumber());
            inDimMember.setLongNumber(flowType.getNumber());
            inDimMember.setSortCode(flowType.getNumber());
            Optional<FlowEnum> flowEnumOpt = Arrays.stream(FlowEnum.values()).filter(flowEnum -> flowEnum.getValue().equals(flowType.getNumber())).findAny();
            inDimMember.setName(flowEnumOpt.isPresent() ? flowEnumOpt.get().getName() : "");
            inDimMember.setMemberType(MemberType.DIM_MEMBER);
            inDimMember.setShrekKey(flowType.getNumber());
            inDimMember.setDimensionId(virtualDim.getId());
            memberList.add(inDimMember);
        }
        virtualDim.setMemberList(memberList);
    }

    public static Set<Long> getDimValues(ReportData reportData) {
        HashSet<Long> set = new HashSet<Long>(8);
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dataDimValList = reportData.getDimValList();
        for (int i = 0; i < dimList.size(); ++i) {
            if (dimList.get(i).isDetailDim()) continue;
            set.add((Long)dataDimValList.get(i));
        }
        return set;
    }

    public static Map<Long, Long> getBeginEndSubjectReverseMap(FundPlanSystem system) {
        return DimensionInfoHelper.getBeginEndSubjectReverseMap(system, null);
    }

    public static Map<Long, Long> getAutoPlanAmtBeginEndSubjectReverseMap(FundPlanSystem system) {
        return DimensionInfoHelper.getBeginEndSubjectReverseMap(system, true);
    }

    public static Map<Long, Long> getBeginEndSubjectReverseMap(FundPlanSystem system, Boolean autoPlanAmt) {
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        if (Objects.isNull(subjectDim)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        List<DimMember> memberList = subjectDim.getAllDimMemberList();
        List endMemberList = memberList.stream().map(AccountMember.class::cast).filter(item -> Objects.nonNull(item.getPeriodDirection()) && Objects.nonNull(item.getAssociateAccount())).collect(Collectors.toList());
        return endMemberList.stream().filter(item -> DimensionInfoHelper.isAutoPlanAmt(autoPlanAmt, item)).collect(Collectors.toMap(DimMember::getId, accountMember -> accountMember.getAssociateAccount().getId(), (k1, k2) -> k1));
    }

    public static Map<Long, Long> getBeginEndSubjectMap(FundPlanSystem system) {
        return DimensionInfoHelper.getBeginEndSubjectMap(system, null);
    }

    public static Map<Long, Long> getBeginEndSubjectMap(FundPlanSystem system, Boolean autoPlanAmt) {
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        if (Objects.isNull(subjectDim)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        List<DimMember> memberList = subjectDim.getAllDimMemberList();
        List endMemberList = memberList.stream().map(AccountMember.class::cast).filter(item -> Objects.nonNull(item.getPeriodDirection()) && Objects.nonNull(item.getAssociateAccount())).collect(Collectors.toList());
        return endMemberList.stream().filter(item -> DimensionInfoHelper.isAutoPlanAmt(autoPlanAmt, item)).collect(Collectors.toMap(k -> k.getAssociateAccount().getId(), DimMember::getId, (k1, k2) -> k1));
    }

    public static Set<Long> listBeginEndSubjectIds(FundPlanSystem system, Boolean autoPlanAmt) {
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        if (Objects.isNull(subjectDim)) {
            return new HashSet<Long>(0);
        }
        List<DimMember> memberList = subjectDim.getAllDimMemberList();
        List endMemberList = memberList.stream().map(AccountMember.class::cast).filter(item -> Objects.nonNull(item.getPeriodDirection()) && Objects.nonNull(item.getAssociateAccount())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(endMemberList)) {
            return new HashSet<Long>(0);
        }
        List endMember = endMemberList.stream().filter(item -> DimensionInfoHelper.isAutoPlanAmt(autoPlanAmt, item)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(endMember)) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> result = new HashSet<Long>(16);
        result.addAll(endMember.stream().map(DimMember::getId).collect(Collectors.toSet()));
        result.addAll(endMember.stream().map(i -> i.getAssociateAccount().getId()).collect(Collectors.toSet()));
        return result;
    }

    private static boolean isAutoPlanAmt(Boolean autoPlanAmt, AccountMember item) {
        return Objects.isNull(autoPlanAmt) || Objects.equals(item.getAssociateAccount().isPlanAmtAuto(), autoPlanAmt);
    }
}

