/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fpm.business.constant.ExecutePlanConstant;
import kd.tmc.fpm.business.constant.ReportConstant;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.common.property.EvaluateAmtDetailProp;
import kd.tmc.fpm.common.property.ReportLinkExecRecordProp;

public class DimensionMappingHelper {
    public static final String REPORT_DETAIL_PREFIX = "detailext";
    public static final String LINK_EXECUTE_RECORD_DETAIL_PREFIX = "limit_detailext";
    public static final String DETAIL_DETAIL_PREFIX = "detail_detailext";
    public static final Map<String, String> ENTITY_DETAIL_FIELD_NAME_MAP = new HashMap<String, String>(){
        {
            this.put("fpm_report", DimensionMappingHelper.REPORT_DETAIL_PREFIX);
            this.put("fpm_report_bak", DimensionMappingHelper.REPORT_DETAIL_PREFIX);
            this.put("fpm_executeplan", DimensionMappingHelper.REPORT_DETAIL_PREFIX);
            this.put("fpm_report_process", DimensionMappingHelper.REPORT_DETAIL_PREFIX);
            this.put("fpm_linkexecrecord", DimensionMappingHelper.LINK_EXECUTE_RECORD_DETAIL_PREFIX);
            this.put("fpm_querybalance", DimensionMappingHelper.DETAIL_DETAIL_PREFIX);
            this.put("fpm_detailamtevaluate", DimensionMappingHelper.DETAIL_DETAIL_PREFIX);
            this.put("fpm_reportplan_adjust", DimensionMappingHelper.DETAIL_DETAIL_PREFIX);
        }
    };

    public static Map<String, String> getDetailExtraFieldsMapping(Long systemId, String appId) {
        String detailPrefix = ENTITY_DETAIL_FIELD_NAME_MAP.get(appId);
        String selectField = String.join((CharSequence)",", "detaildimtype", "id");
        QFilter qFilter = new QFilter("bodysys", "=", (Object)systemId);
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"fpm_detailplanfields", (String)selectField, (QFilter[])new QFilter[]{qFilter});
        HashMap<String, String> detailMappingMap = new HashMap<String, String>(32);
        for (DynamicObject dynamicObject : loadFromCache.values()) {
            String detailDimTypeStr = dynamicObject.getString("detaildimtype");
            DetailDimType detailDimType = DetailDimType.getDimsionByNumber(detailDimTypeStr);
            if (detailDimType == null || !DetailDimType.isExtraField(detailDimType)) continue;
            String suffix = detailDimType.getNumber().split("_")[1];
            String detailField = detailPrefix + suffix;
            detailMappingMap.put(detailDimType.getNumber(), detailField);
        }
        return detailMappingMap;
    }

    public static Map<String, String> getLinkExecDetailMappingWithoutEntry(Long systemId) {
        Map<String, String> linkExecExtraMappingWithoutEntry = DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_linkexecrecord");
        HashMap<String, String> detailMappingMap = new HashMap<String, String>(ReportLinkExecRecordProp.detailPlanFieldMap);
        detailMappingMap.putAll(linkExecExtraMappingWithoutEntry);
        return detailMappingMap;
    }

    public static Map<String, String> getQueryBalanceExtraMappingWithoutEntry(Long systemId) {
        return DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_querybalance");
    }

    public static Map<String, String> getReportPlanDetailMappingWithEntry(Long systemId) {
        HashMap<String, String> detailMappingMap = new HashMap<String, String>(ReportDataQueryService.DETAILDIM_ENTRY_MAPPING_MAP);
        Map<String, String> detailExtraFieldsMapping = DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_report");
        detailExtraFieldsMapping.forEach((k, v) -> detailMappingMap.put((String)k, String.join((CharSequence)".", "detailentry", v)));
        return detailMappingMap;
    }

    public static Map<String, String> getEvaluateDetailMappingWithoutEntry(Long systemId) {
        HashMap<String, String> detailMappingMap = new HashMap<String, String>(EvaluateAmtDetailProp.DETAIL_ENTRY_DIM_TYPE_FIELD_MAP);
        Map<String, String> detailExtraFieldsMapping = DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_detailamtevaluate");
        detailMappingMap.putAll(detailExtraFieldsMapping);
        return detailMappingMap;
    }

    public static Map<String, String> getExecutePlanMappingWithoutEntry(Long systemId) {
        HashMap<String, String> detailMappingMap = new HashMap<String, String>(ExecutePlanConstant.DETAILDIM_ENTRY_MAPPING_MAP);
        Map<String, String> detailExtraFieldsMapping = DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_executeplan");
        detailMappingMap.putAll(detailExtraFieldsMapping);
        return detailMappingMap;
    }

    public static Map<String, String> getAdjustDetailMappingWithEntry(Long systemId) {
        HashMap<String, String> detailMappingMap = new HashMap<String, String>(ReportConstant.DETAIL_DIM_ENTRY_ENTIRE_NAME_MAPPING_MAP);
        Map<String, String> detailExtraFieldsMapping = DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_reportplan_adjust");
        detailExtraFieldsMapping.forEach((k, v) -> detailMappingMap.put((String)k, String.join((CharSequence)".", "detail_entryentity", v)));
        return detailMappingMap;
    }

    public static Map<String, String> getAdjustAllDimMappingWithoutEntry(Long systemId) {
        HashMap<String, String> mappingMap = new HashMap<String, String>(ReportConstant.TYPE_MAPPING_MAP);
        Map<String, String> detailExtraFieldsMapping = DimensionMappingHelper.getDetailExtraFieldsMapping(systemId, "fpm_reportplan_adjust");
        mappingMap.putAll(detailExtraFieldsMapping);
        return mappingMap;
    }
}

