/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ListHelper {
    @SafeVarargs
    public static <T> List<T> asList(T ... items) {
        if (Objects.isNull(items) || items.length == 0) {
            return new ArrayList(1);
        }
        ArrayList<T> list = new ArrayList<T>(items.length);
        for (T item : items) {
            if (EmptyUtil.isEmpty(item)) continue;
            list.add(item);
        }
        return list;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... items) {
        if (Objects.isNull(items) || items.length == 0) {
            return new HashSet(2);
        }
        HashSet<T> set = new HashSet<T>(items.length);
        for (T item : items) {
            if (EmptyUtil.isEmpty(item)) continue;
            set.add(item);
        }
        return set;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(Set<T> ... sets) {
        if (Objects.isNull(sets) || sets.length == 0) {
            return new HashSet(2);
        }
        return Arrays.stream(sets).filter(EmptyUtil::isNoEmpty).flatMap(Collection::stream).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
    }
}

