/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LogHelper {
    private final Log logger;
    private final StringBuilder logStr = new StringBuilder();
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    private LogHelper() {
        this(LogHelper.class);
    }

    private LogHelper(Class<?> clazz) {
        this.logger = LogFactory.getLog(clazz);
    }

    public LogHelper(Log logger) {
        this.logger = logger;
    }

    public static LogHelper get() {
        return new LogHelper();
    }

    public static LogHelper get(Class<?> clazz) {
        return new LogHelper(clazz);
    }

    public static LogHelper get(Log logger) {
        return new LogHelper(logger);
    }

    public LogHelper logger(String message) {
        this.logStr.append(this.simpleDateFormat.format(new Date())).append("   ").append("[").append("time: ").append(System.currentTimeMillis()).append("]").append("  ").append(": ").append(message).append("\r\n");
        return this;
    }

    public LogHelper logger(String message, Object ... params) {
        message = message.replace("{}", "%s");
        return this.logger(String.format(message, params));
    }

    public <T> LogHelper logger(Class<T> clazz, String message) {
        this.logStr.append(this.simpleDateFormat.format(new Date())).append("   ").append("[").append("time: ").append(System.currentTimeMillis()).append("]").append("  ").append(clazz.getName()).append(": ").append(message).append("\r\n");
        return this;
    }

    public LogHelper logger(Class<?> clazz, String message, Object ... params) {
        message = message.replace("{}", "%s");
        return this.logger(clazz, String.format(message, params));
    }

    public void clear() {
        this.logStr.delete(0, this.logStr.length() - 1);
    }

    public void info() {
        if (this.logStr.length() == 0) {
            return;
        }
        this.logger.info(this.logStr.toString());
        this.clear();
    }

    public void debug() {
        if (this.logStr.length() == 0) {
            return;
        }
        this.logger.debug(this.logStr.toString());
        this.clear();
    }

    public void error() {
        if (this.logStr.length() == 0) {
            return;
        }
        this.logger.error(this.logStr.toString());
        this.clear();
    }

    public void error(Throwable e) {
        this.logger.error(this.logStr.append(e.getMessage()).toString(), e);
        this.clear();
    }
}

