/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.dataproc.save.IReportEntrySaveService;
import kd.tmc.fpm.business.dataproc.save.impl.ReportEntrySaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataWrapper;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;

public class MutexAuxiliarySaveHelper {
    private static final String EXEC_BIAS_REASON_LOCK_OP = "execBiasReason";
    private static final IReportEntrySaveService reportEntrySaveService = new ReportEntrySaveServiceImpl();
    private static final IReportDataQueryService reportDataQueryService = new ReportDataQueryService();
    private MutexAuxiliarySaveInfo mutexAuxiliarySaveInfo;

    public static MutexAuxiliarySaveHelper getInstance(MutexAuxiliarySaveInfo mutexAuxiliarySaveInfo) {
        return new MutexAuxiliarySaveHelper(mutexAuxiliarySaveInfo);
    }

    public MutexAuxiliarySaveHelper(MutexAuxiliarySaveInfo mutexAuxiliarySaveInfo) {
        this.mutexAuxiliarySaveInfo = mutexAuxiliarySaveInfo;
    }

    public void saveOrUpdateAuxiliaryReportDataForFix(List<ReportDataWrapper> reportDataWrapperList) {
        if (EmptyUtil.isEmpty(reportDataWrapperList)) {
            return;
        }
        if (!this.mutexAuxiliarySaveInfo.getInputType().needMutex()) {
            this.updateExistsFlagIfNeed(reportDataWrapperList);
            reportEntrySaveService.saveOrUpdateAuxiliaryReportDataForFix(reportDataWrapperList);
            return;
        }
        try {
            if (this.mutexLock()) {
                this.updateExistsFlagIfNeed(reportDataWrapperList);
                reportEntrySaveService.saveOrUpdateAuxiliaryReportDataForFix(reportDataWrapperList);
                return;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5dee\u5f02\u539f\u56e0\u586b\u62a5\u4fdd\u5b58\u5931\u8d25\uff0c\u6709\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4fdd\u5b58\u5f53\u524d\u7f16\u62a5\u4e3b\u4f53\u3010%1$s\u3011\u7684\u6267\u884c\u504f\u5dee\u539f\u56e0\uff0c\u8bf7\u7a0d\u540e\u5904\u7406\u3002", (String)"MutexAuxiliarySaveHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0]), this.mutexAuxiliarySaveInfo.getReport().getPeriodMemberList().get(0).getName()));
        }
        finally {
            this.mutexUnLock();
        }
    }

    private void updateExistsFlagIfNeed(List<ReportDataWrapper> reportDataWrapperList) {
        Map<Boolean, List<ReportDataWrapper>> reportDataWrapperMap = reportDataWrapperList.stream().collect(Collectors.groupingBy(ReportDataWrapper::isNewData));
        List<ReportDataWrapper> newDataList = reportDataWrapperMap.get(Boolean.TRUE);
        if (EmptyUtil.isEmpty(newDataList)) {
            return;
        }
        BitMap<Long, ReportData> existsBitMap = this.getExistsBitMap();
        if (existsBitMap == null) {
            return;
        }
        for (ReportDataWrapper reportDataWrapper : newDataList) {
            ReportData reportData = reportDataWrapper.getReportData();
            Set<Long> dimValues = DimensionInfoHelper.getDimValues(reportData);
            dimValues.add(reportData.getReportId());
            ReportData rd = existsBitMap.findOne(dimValues);
            if (EmptyUtil.isEmpty((Object)rd)) continue;
            reportDataWrapper.setNewData(false);
            rd.setAuxiliaryValMap(reportData.getAuxiliaryValMap());
            reportDataWrapper.setReportData(rd);
        }
    }

    private BitMap<Long, ReportData> getExistsBitMap() {
        List<ReportData> reportDataList = reportDataQueryService.queryReportData(t -> {
            t.setReportIdS(Collections.singletonList(this.mutexAuxiliarySaveInfo.getReport().getId()));
            Dimension dimension = new Dimension();
            dimension.setDimType(DimensionType.PERIOD);
            t.setDimIdList(Collections.singletonList(dimension));
            t.setDimValList(Collections.singletonList(Collections.singletonList(0L)));
        });
        if (EmptyUtil.isEmpty(reportDataList)) {
            return null;
        }
        BitMap<Long, ReportData> reportDataBitMap = new BitMap<Long, ReportData>(reportDataList.size());
        for (ReportData reportData : reportDataList) {
            reportDataBitMap.addValue(reportData.getReportId(), reportData);
            reportDataBitMap.addValue(DimensionInfoHelper.getDimValues(reportData), reportData);
        }
        return reportDataBitMap;
    }

    private boolean mutexLock() {
        return MutexServiceHelper.request((String)this.mutexAuxiliarySaveInfo.getId().toString(), (String)"fpm_report", (String)EXEC_BIAS_REASON_LOCK_OP);
    }

    private void mutexUnLock() {
        MutexServiceHelper.release((String)this.mutexAuxiliarySaveInfo.getId().toString(), (String)"fpm_report", (String)EXEC_BIAS_REASON_LOCK_OP);
    }

    public static enum InputType {
        EXEC_BIAS_SUM_PLAN,
        EXEC_BIAS_REPORT,
        SUM_PLAN,
        SUM_PLAN_CONTAINS_REFERENCE,
        REPORT,
        REPORT_CONTAINS_REFERENCE;


        public boolean needMutex() {
            return this != SUM_PLAN && this != REPORT;
        }
    }

    public static class MutexAuxiliarySaveInfo {
        private Long id;
        private Report report;
        private InputType inputType;

        public MutexAuxiliarySaveInfo() {
        }

        public MutexAuxiliarySaveInfo(Long id, Report report) {
            this.id = id;
            this.report = report;
        }

        public MutexAuxiliarySaveInfo(Long id, Report report, InputType inputType) {
            this.id = id;
            this.report = report;
            this.inputType = inputType;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Report getReport() {
            return this.report;
        }

        public void setReport(Report report) {
            this.report = report;
        }

        public InputType getInputType() {
            return this.inputType;
        }

        public void setInputType(InputType inputType) {
            this.inputType = inputType;
        }
    }
}

