/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.math.BigDecimal;
import java.text.NumberFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class POIHelper {
    public static Object getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            CellType cachedFormulaResultType = cell.getCachedFormulaResultType();
            switch (cachedFormulaResultType) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        return cell.getDateCellValue();
                    }
                    NumberFormat instance = NumberFormat.getInstance();
                    instance.setMaximumFractionDigits(16);
                    instance.setGroupingUsed(false);
                    String result = instance.format(BigDecimal.valueOf(cell.getNumericCellValue()));
                    if (result.contains(",") && !result.contains(".")) {
                        return result.replace(",", "") + ".0";
                    }
                    return result.replace(",", "");
                }
                case STRING: {
                    return cell.getStringCellValue();
                }
                case BOOLEAN: {
                    return cell.getBooleanCellValue();
                }
                case BLANK: {
                    return "";
                }
            }
            FormulaEvaluator formulaEvaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
            return formulaEvaluator.evaluate(cell).getStringValue();
        }
        if (cellType == CellType.NUMERIC) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                return cell.getDateCellValue();
            }
            NumberFormat instance = NumberFormat.getInstance();
            instance.setMaximumFractionDigits(16);
            instance.setGroupingUsed(false);
            String result = instance.format(BigDecimal.valueOf(cell.getNumericCellValue()));
            if (result.contains(",") && !result.contains(".")) {
                return result.replace(",", "") + ".0";
            }
            return result.replace(",", "");
        }
        if (cellType == CellType.BOOLEAN) {
            return cell.getBooleanCellValue();
        }
        if (cellType == CellType.STRING) {
            return cell.getStringCellValue();
        }
        if (cellType == CellType.BLANK) {
            return "";
        }
        return "";
    }

    public static Row getOrCreateRow(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    public static Cell getOrCreateCell(Row row, int col) {
        Cell cell = row.getCell(col);
        if (cell == null) {
            cell = row.createCell(col);
        }
        return cell;
    }

    public static Object getCellValue(int rowIdx, int colIdx, Sheet sheet) {
        Row row = POIHelper.getOrCreateRow(sheet, rowIdx);
        Cell cell = POIHelper.getOrCreateCell(row, colIdx);
        return POIHelper.getCellValue(cell);
    }

    public static CellStyle getCellStyle(int rowIdx, int colIdx, Sheet sheet) {
        Row row = POIHelper.getOrCreateRow(sheet, rowIdx);
        Cell cell = POIHelper.getOrCreateCell(row, colIdx);
        return cell.getCellStyle();
    }

    public static boolean isEmptyRow(Sheet sheet, int rowIdx, int colFrom, int colTo) {
        Row row = sheet.getRow(rowIdx);
        if (row == null || row.getLastCellNum() == 0) {
            return true;
        }
        for (int i = colFrom; i <= colTo; ++i) {
            Cell cell = row.getCell(i);
            if (POIHelper.isBlankCell(cell)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlankCell(Cell cell) {
        if (cell == null) {
            return true;
        }
        if (cell.getCellType() == CellType.BLANK) {
            return true;
        }
        if (cell.getCellType() == CellType.STRING) {
            return StringUtils.isBlank((CharSequence)cell.getStringCellValue());
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return BigDecimal.valueOf(cell.getNumericCellValue()).compareTo(BigDecimal.ZERO) == 0;
        }
        return false;
    }
}

