/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.utils;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.tmc.fpm.common.enums.DimsionEnums;

public class TreeEntryEntityUtils {
    public static final String treeentryentity = "treeentryentity";
    public static final String NUMBER = "number";
    public static final String NAME = "name";

    public static void fillTreeEntryEntityUserSeq(DimsionEnums dim, IDataModel model, DynamicObject[] memberColls, List<String> propertyList, boolean checkIsLeaf) {
        TreeEntryEntityUtils.fillTreeEntryEntityUserSeq(dim, model, memberColls, propertyList, checkIsLeaf, 0L);
    }

    public static void fillTreeEntryEntityUserSeq(DimsionEnums dim, IDataModel model, DynamicObject[] memberColls, List<String> propertyList, boolean checkIsLeaf, Long parentid) {
        int memberSize = memberColls.length;
        model.getDataEntity(true);
        model.batchCreateNewEntryRow(treeentryentity, memberSize + 1);
        DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, 0);
        rowObj.set(NUMBER, (Object)dim.getNumber());
        rowObj.set(NAME, (Object)dim.getName());
        SecureRandom random = new SecureRandom();
        long rootId = random.nextLong();
        rowObj.set("id", (Object)rootId);
        rowObj.set("pid", (Object)0);
        rowObj.set("parentid", (Object)0);
        rowObj.set("isgroupnode", (Object)true);
        if (memberSize == 0) {
            return;
        }
        String parentKey = "parent";
        if (!(memberColls[memberSize - 1].get("parent") instanceof Long)) {
            parentKey = "parent.id";
        }
        ArrayList<Long> allMembIds = new ArrayList<Long>(memberColls.length);
        for (DynamicObject memb : memberColls) {
            allMembIds.add(memb.getLong("id"));
        }
        HashMap<Long, TreeSet<DynamicObject>> searchChild = new HashMap<Long, TreeSet<DynamicObject>>();
        Comparator<DynamicObject> comparator = TreeEntryEntityUtils.getMembDseqComparator();
        for (int i = 0; i < memberSize; ++i) {
            DynamicObject memberObject = memberColls[i];
            long parent = memberObject.getLong(parentKey);
            if (!allMembIds.contains(parent)) {
                parent = rootId;
            }
            if (searchChild.containsKey(parent)) {
                ((TreeSet)searchChild.get(parent)).add(memberObject);
                continue;
            }
            TreeSet<DynamicObject> children = new TreeSet<DynamicObject>(comparator);
            children.add(memberObject);
            searchChild.put(parent, children);
        }
        TreeEntryEntityUtils.expandNextLevel(model, propertyList, 0, rootId, searchChild, checkIsLeaf);
    }

    private static int expandNextLevel(IDataModel model, List<String> propertyList, int row, Long parentId, Map<Long, TreeSet<DynamicObject>> searchChild, boolean checkIsLeaf) {
        if (searchChild.containsKey(parentId)) {
            TreeSet<DynamicObject> childrenMap = searchChild.get(parentId);
            for (DynamicObject child : childrenMap) {
                DynamicObject rowObj;
                if (null == (rowObj = model.getEntryRowEntity(treeentryentity, ++row))) continue;
                for (int k = 0; k < propertyList.size(); ++k) {
                    String property = propertyList.get(k);
                    rowObj.set(property, child.get(property));
                }
                rowObj.set("id", (Object)child.getLong("id"));
                rowObj.set("memberid", (Object)child.getLong("id"));
                rowObj.set("pid", (Object)parentId);
                rowObj.set("parentid", (Object)parentId);
                row = TreeEntryEntityUtils.expandNextLevel(model, propertyList, row, child.getLong("id"), searchChild, checkIsLeaf);
            }
        }
        return row;
    }

    public static Comparator<DynamicObject> getMembDseqComparator() {
        Comparator<DynamicObject> comparator = new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return Long.compare(o1.getLong("serial"), o2.getLong("serial"));
            }
        };
        return comparator;
    }

    public static void fillTreeEntryEntityUserSeq(IDataModel model, List<Map<String, Object>> memberColls, List<String> propertyList) {
        model.batchCreateNewEntryRow(treeentryentity, memberColls.size());
        Map<String, Object> root = null;
        HashMap<Long, TreeMap<Integer, Map<String, Object>>> searchChild = new HashMap<Long, TreeMap<Integer, Map<String, Object>>>();
        if (memberColls != null && memberColls.size() > 0) {
            for (Map<String, Object> dd : memberColls) {
                Object data = dd.get("parent");
                Long parent = Long.parseLong(data + "");
                int dseq = Integer.parseInt((String)dd.get("kseq"));
                if (Long.valueOf(0L).equals(parent)) {
                    root = dd;
                    continue;
                }
                if (searchChild.containsKey(parent)) {
                    ((TreeMap)searchChild.get(parent)).put(dseq, dd);
                    continue;
                }
                TreeMap<Integer, Map<String, Object>> children = new TreeMap<Integer, Map<String, Object>>();
                children.put(dseq, dd);
                searchChild.put(parent, children);
            }
        }
        DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, 0);
        for (int k = 0; k < propertyList.size(); ++k) {
            String property = propertyList.get(k);
            if (root == null) continue;
            rowObj.set(property, root.get(property));
        }
        rowObj.set("pid", (Object)0);
        if (root != null) {
            TreeEntryEntityUtils.expandNextLevel(model, propertyList, 0, root, searchChild);
        }
    }

    private static int expandNextLevel(IDataModel model, List<String> propertyList, int row, Map<String, Object> parent, Map<Long, TreeMap<Integer, Map<String, Object>>> searchChild) {
        if (searchChild.containsKey(parent.get("id"))) {
            TreeMap<Integer, Map<String, Object>> childrenMap = searchChild.get(parent.get("id"));
            Collection<Map<String, Object>> children = childrenMap.values();
            for (Map<String, Object> child : children) {
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, ++row);
                for (int k = 0; k < propertyList.size(); ++k) {
                    String property = propertyList.get(k);
                    rowObj.set(property, child.get(property));
                }
                rowObj.set("pid", parent.get("id"));
                row = TreeEntryEntityUtils.expandNextLevel(model, propertyList, row, child, searchChild);
            }
        }
        return row;
    }
}

