/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class AuxiliaryFieldsDeleteValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("ispreset");
        selector.add("number");
        selector.add("name");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        String remarkBDProp = String.join((CharSequence)".", "remarkfield", "fbasedataid");
        String remarkSelectProp = String.join((CharSequence)",", "id", "number", "name", remarkBDProp);
        List ids = Arrays.stream(extendedDataEntities).map(e -> e.getDataEntity().getPkValue()).collect(Collectors.toList());
        DynamicObjectCollection remarkLoad = QueryServiceHelper.query((String)"fpm_template", (String)remarkSelectProp, (QFilter[])new QFilter(remarkBDProp, "in", ids).toArray());
        Map<Long, String> remarkMap = remarkLoad.stream().collect(Collectors.groupingBy(d -> d.getLong(remarkBDProp), Collectors.mapping(o -> o.getString("number") + o.getString("name"), Collectors.joining("\u3011\u3010"))));
        String auxBDProp = String.join((CharSequence)".", "reporttypeentry", "auxiliaryfield", "fbasedataid");
        String auxSelectProp = String.join((CharSequence)",", "id", "number", "name", auxBDProp);
        DynamicObjectCollection auxLoad = QueryServiceHelper.query((String)"fpm_template", (String)auxSelectProp, (QFilter[])new QFilter(auxBDProp, "in", ids).toArray());
        Map<Long, String> auxMap = auxLoad.stream().collect(Collectors.groupingBy(d -> d.getLong(auxBDProp), Collectors.mapping(o -> o.getString("number") + o.getString("name"), Collectors.joining("\u3011\u3010"))));
        String reportAuxBDProp = String.join((CharSequence)".", "auxentry", "aux_bdtype");
        String reportSelectProp = String.join((CharSequence)",", "id", "billno", "name", reportAuxBDProp);
        DynamicObjectCollection reportAuxLoad = QueryServiceHelper.query((String)"fpm_report", (String)reportSelectProp, (QFilter[])new QFilter(reportAuxBDProp, "in", ids).toArray());
        Map<Long, String> reportAuxMap = reportAuxLoad.stream().filter(AuxiliaryFieldsDeleteValidator.distinctByKey(r -> r.getLong("id"))).collect(Collectors.groupingBy(d -> d.getLong(reportAuxBDProp), Collectors.mapping(o -> o.getString("billno") + o.getString("name"), Collectors.joining("\u3011\u3010"))));
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            Long pkId;
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            boolean isPreset = dynamicObject.getBoolean("ispreset");
            if (isPreset) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002\u7cfb\u7edf\u9884\u7f6e\u7684\u8f85\u52a9\u5217\u5b57\u6bb5\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AuxiliaryFieldsDeleteValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            if (remarkMap.containsKey(pkId = (Long)dynamicObject.getPkValue())) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u5217\u5b57\u6bb5\u201c%1$s\u201d\uff08%2$s\uff09\u5df2\u88ab\u201c%3$s\u201d\u6a21\u677f\u5173\u8054\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"AuxiliaryFieldsDeleteValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), dynamicObject.getString("number"), dynamicObject.getString("name"), remarkMap.get(pkId)));
            }
            if (auxMap.containsKey(pkId)) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u5217\u5b57\u6bb5\u201c%1$s\u201d\uff08%2$s\uff09\u5df2\u88ab\u201c%3$s\u201d\u5355\u636e\u5173\u8054\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"AuxiliaryFieldsDeleteValidator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), dynamicObject.getString("number"), dynamicObject.getString("name"), auxMap.get(pkId)));
            }
            if (!reportAuxMap.containsKey(pkId)) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u5217\u5b57\u6bb5\u3010%1$s %2$s\u3011\u5df2\u88ab\u3010%3$s\u3011\u5355\u636e\u5173\u8054\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AuxiliaryFieldsDeleteValidator_3", (String)"tmc-fpm-business", (Object[])new Object[0]), dynamicObject.getString("number"), dynamicObject.getString("name"), reportAuxMap.get(pkId)));
        }
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap(64);
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

