/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BodySysManageCopyValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        List pks = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).map(o -> o.getPkValue()).collect(Collectors.toList());
        DynamicObjectCollection systemDyColl = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        Map<Long, String> systemNameMap = systemDyColl.stream().collect(Collectors.toMap(key -> key.getLong("id"), val -> val.getString("name")));
        HashMap needSecondCheckedSystemNameMap = Maps.newHashMapWithExpectedSize((int)extendedDataEntities.length);
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            String systemName = systemNameMap.get(dy.getPkValue());
            if (!EmptyUtil.isNoEmpty((String)systemName)) continue;
            String[] nameSplit = systemName.split("V");
            if (nameSplit[0].length() >= 50) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u540d\u79f0\u201c%s\u201d\u5df2\u8fbe\u5230\u89c4\u5b9a\u957f\u5ea6\uff0c\u5907\u4efd\u540e\u5c06\u4e0d\u7b26\u5408\u89c4\u5b9a\u957f\u5ea6\uff0c\u65e0\u6cd5\u5907\u4efd\u3002", (String)"BodySysManageCopyValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), nameSplit[0]));
                continue;
            }
            needSecondCheckedSystemNameMap.put(dy.getLong("id"), nameSplit[0]);
        }
        this.secondCheckSystemName(extendedDataEntities, needSecondCheckedSystemNameMap);
    }

    private void secondCheckSystemName(ExtendedDataEntity[] extendedDataEntities, Map<Long, String> needSecondCheckedSystemNameMap) {
        if (needSecondCheckedSystemNameMap.isEmpty()) {
            return;
        }
        QFilter qFilter = null;
        for (String prefixName : needSecondCheckedSystemNameMap.values()) {
            if (qFilter == null) {
                qFilter = new QFilter("name", "like", (Object)(prefixName + "V%"));
                continue;
            }
            qFilter.or(new QFilter("name", "like", (Object)(prefixName + "V%")));
        }
        if (qFilter == null) {
            return;
        }
        DynamicObjectCollection backedSysNameColl = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)"name", (QFilter[])qFilter.toArray());
        Set backedSysNameSet = backedSysNameColl.stream().map(dy -> dy.getString("name")).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject dy2 = dataEntity.getDataEntity();
            Long id = dy2.getLong("id");
            if (!needSecondCheckedSystemNameMap.containsKey(id)) continue;
            String prefixName = needSecondCheckedSystemNameMap.get(id) + "V";
            long backedSysNameSize = backedSysNameSet.stream().filter(sysName -> sysName.indexOf(prefixName) == 0).count();
            String newName = prefixName + (backedSysNameSize + 2L) + ".0";
            if (newName.length() <= 50) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5907\u4efd\u4f53\u7cfb\u65b0\u540d\u79f0\u201c%s\u201d\u957f\u5ea6\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6\uff0c\u65e0\u6cd5\u5907\u4efd\u3002", (String)"BodySysManageCopyValidator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), newName));
        }
    }
}

