/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.validate.basesetting;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.common.enums.DimsionEnums;

public class BodySysMangeEnableValidator
extends AbstractTmcBizOppValidator {
    private static final String[] DEFAULTORGINFO = new String[]{"Org", "OrgNone"};

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applyrereportentry");
        selector.add("applyrereportentry.rerporttype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity entity : extendedDataEntities) {
            DynamicObject[] modelDataArr;
            DynamicObject dyObj = entity.getDataEntity();
            Object id = dyObj.get("id");
            DynamicObject[] currOrgMemberArr = TmcDataServiceHelper.load((String)"fpm_orgmember", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", id), new QFilter("dimtype", "=", (Object)DimsionEnums.ORG.getNumber()), new QFilter("number", "not in", (Object)DEFAULTORGINFO)});
            if (currOrgMemberArr.length <= 0) continue;
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
            List orgNumberList = Stream.of(currOrgMemberArr).map(e -> e.get("number")).collect(Collectors.toList());
            qFilterList.add(new QFilter("bodysystem", "!=", id));
            qFilterList.add(new QFilter("number", "in", orgNumberList));
            DynamicObject[] orgMemberArr = TmcDataServiceHelper.load((String)"fpm_orgmember", (String)"bodysystem,number,name", (QFilter[])qFilterList.toArray(new QFilter[0]));
            if (orgMemberArr.length <= 0) continue;
            Map<Object, List<DynamicObject>> modelNumberMap = Stream.of(orgMemberArr).filter(i -> i.get("bodysystem.id") != null).collect(Collectors.groupingBy(i -> i.get("bodysystem.id")));
            Set<Object> keySet = modelNumberMap.keySet();
            for (DynamicObject modelData : modelDataArr = TmcDataServiceHelper.load((Object[])keySet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_bodysysmanage"))) {
                if (!modelData.getBoolean("enable")) continue;
                List<DynamicObject> orgNumberDataList = modelNumberMap.get(modelData.get("id").toString());
                List orgNameList = orgNumberDataList.stream().map(e -> e.getString("name")).collect(Collectors.toList());
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u542f\u7528\u5931\u8d25\u3002\u539f\u56e0\uff1a\u4f53\u7cfb\u5185\u7f16\u62a5\u7ec4\u7ec7\u201c%1$s\u201d\u5df2\u88ab\u53ef\u7528\u72b6\u6001\u4e0b\u7684%2$s\u5173\u8054\u5f15\u7528\u3002", (String)"BodySysMangeEnableValidator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), String.join((CharSequence)",", orgNameList), modelData.get("name")));
            }
        }
    }
}

